/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.filter;

import org.apache.directory.shared.ldap.filter.FilterVisitor;
import org.apache.directory.shared.ldap.filter.LeafNode;
import org.apache.directory.shared.ldap.util.StringTools;

public class ExtensibleNode
extends LeafNode {
    private final byte[] value;
    private final String matchingRuleId;
    private boolean dnAttributes = false;

    public ExtensibleNode(String attribute, String value, String matchingRuleId, boolean dnAttributes) {
        this(attribute, StringTools.getBytesUtf8(value), matchingRuleId, dnAttributes);
    }

    public ExtensibleNode(String attribute, byte[] value, String matchingRuleId, boolean dnAttributes) {
        super(attribute, 6);
        this.value = value;
        this.matchingRuleId = matchingRuleId;
        this.dnAttributes = dnAttributes;
    }

    public boolean dnAttributes() {
        return this.dnAttributes;
    }

    public String getMatchingRuleId() {
        return this.matchingRuleId;
    }

    public final byte[] getValue() {
        return this.value;
    }

    public StringBuffer printToBuffer(StringBuffer buf) {
        buf.append('(').append(this.getAttribute());
        buf.append("-");
        buf.append(this.dnAttributes);
        buf.append("-EXTENSIBLE-");
        buf.append(this.matchingRuleId);
        buf.append("-");
        buf.append(StringTools.utf8ToString(this.value));
        buf.append("/");
        buf.append(StringTools.dumpBytes(this.value));
        buf.append(')');
        if (this.getAnnotations() != null && this.getAnnotations().containsKey("count")) {
            buf.append('[');
            buf.append(this.getAnnotations().get("count").toString());
            buf.append("] ");
        } else {
            buf.append(' ');
        }
        return buf;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        this.printToBuffer(buf);
        return buf.toString();
    }

    public void accept(FilterVisitor visitor) {
        if (visitor.canVisit(this)) {
            visitor.visit(this);
        }
    }
}

