/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.search.controls;

import java.nio.ByteBuffer;
import org.apache.directory.shared.asn1.Asn1Object;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.codec.EncoderException;

public class PSearchControl
extends Asn1Object {
    private boolean changesOnly;
    private boolean returnECs;
    private int changeTypes;
    public static final int CHANGE_TYPE_ADD = 1;
    public static final int CHANGE_TYPE_DELETE = 2;
    public static final int CHANGE_TYPE_MODIFY = 4;
    public static final int CHANGE_TYPE_MODDN = 8;
    public static final int CHANGE_TYPES_MIN = 1;
    public static final int CHANGE_TYPES_MAX = 15;
    private transient int psearchSeqLength;

    public void setChangesOnly(boolean changesOnly) {
        this.changesOnly = changesOnly;
    }

    public boolean isChangesOnly() {
        return this.changesOnly;
    }

    public void setReturnECs(boolean returnECs) {
        this.returnECs = returnECs;
    }

    public boolean isReturnECs() {
        return this.returnECs;
    }

    public void setChangeTypes(int changeTypes) {
        this.changeTypes = changeTypes;
    }

    public int getChangeTypes() {
        return this.changeTypes;
    }

    public int computeLength() {
        int changeTypesLength = 2 + Value.getNbBytes((int)this.changeTypes);
        int changesOnlyLength = 3;
        int returnRCsLength = 3;
        this.psearchSeqLength = changeTypesLength + changesOnlyLength + returnRCsLength;
        return 1 + TLV.getNbBytes((int)this.psearchSeqLength) + this.psearchSeqLength;
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        ByteBuffer bb = ByteBuffer.allocate(this.computeLength());
        bb.put((byte)48);
        bb.put(TLV.getBytes((int)this.psearchSeqLength));
        Value.encode((ByteBuffer)bb, (int)this.changeTypes);
        Value.encode((ByteBuffer)bb, (boolean)this.changesOnly);
        Value.encode((ByteBuffer)bb, (boolean)this.returnECs);
        return bb;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    Persistant Search Control\n");
        sb.append("        changeTypes : '").append(this.changeTypes).append("'\n");
        sb.append("        changesOnly : '").append(this.changesOnly).append("'\n");
        sb.append("        returnECs   : '").append(this.returnECs).append("'\n");
        return sb.toString();
    }
}

