/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.search;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.ldap.codec.LdapMessage;
import org.apache.directory.shared.ldap.codec.util.LdapURL;

public class SearchResultReference
extends LdapMessage {
    private ArrayList searchResultReferences = new ArrayList();
    private transient int searchResultReferenceLength;

    public int getMessageType() {
        return 18;
    }

    public void addSearchResultReference(LdapURL searchResultReference) {
        this.searchResultReferences.add(searchResultReference);
    }

    public ArrayList getSearchResultReferences() {
        return this.searchResultReferences;
    }

    public int computeLength() {
        this.searchResultReferenceLength = 0;
        Iterator referencesIterator = this.searchResultReferences.iterator();
        while (referencesIterator.hasNext()) {
            int ldapUrlLength = ((LdapURL)referencesIterator.next()).getNbBytes();
            this.searchResultReferenceLength += 1 + TLV.getNbBytes((int)ldapUrlLength) + ldapUrlLength;
        }
        return 1 + TLV.getNbBytes((int)this.searchResultReferenceLength) + this.searchResultReferenceLength;
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException("Cannot put a PDU in a null buffer !");
        }
        try {
            buffer.put((byte)115);
            buffer.put(TLV.getBytes((int)this.searchResultReferenceLength));
            Iterator referencesIterator = this.searchResultReferences.iterator();
            while (referencesIterator.hasNext()) {
                LdapURL reference = (LdapURL)referencesIterator.next();
                Value.encode((ByteBuffer)buffer, (String)reference.getString());
            }
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException("The PDU buffer size is too small !");
        }
        return buffer;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    Search Result Reference\n");
        if (this.searchResultReferences == null || this.searchResultReferences.size() == 0) {
            sb.append("        No Reference\n");
        } else {
            sb.append("        References\n");
            Iterator referencesIterator = this.searchResultReferences.iterator();
            while (referencesIterator.hasNext()) {
                sb.append("            '").append(((LdapURL)referencesIterator.next()).toString()).append("'\n");
            }
        }
        return sb.toString();
    }
}

