/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.search;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.ldap.codec.LdapMessage;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.util.AttributeUtils;
import org.apache.directory.shared.ldap.util.StringTools;

public class SearchResultEntry
extends LdapMessage {
    private LdapDN objectName;
    private Attributes partialAttributeList = new BasicAttributes(true);
    private transient Attribute currentAttributeValue;
    private transient int searchResultEntryLength;
    private transient int attributesLength;
    private transient List attributeLength;
    private transient List valsLength;

    public int getMessageType() {
        return 17;
    }

    public LdapDN getObjectName() {
        return this.objectName;
    }

    public void setObjectName(LdapDN objectName) {
        this.objectName = objectName;
    }

    public Attributes getPartialAttributeList() {
        return this.partialAttributeList;
    }

    public void setPartialAttributeList(Attributes partialAttributeList) {
        this.partialAttributeList = partialAttributeList;
    }

    public void addAttributeValues(String type) {
        this.currentAttributeValue = new BasicAttribute(StringTools.lowerCase(type));
        this.partialAttributeList.put(this.currentAttributeValue);
    }

    public void addAttributeValue(Object value) {
        this.currentAttributeValue.add(value);
    }

    public int computeLength() {
        this.searchResultEntryLength = 1 + TLV.getNbBytes((int)LdapDN.getNbBytes(this.objectName)) + LdapDN.getNbBytes(this.objectName);
        this.attributesLength = 0;
        if (this.partialAttributeList != null && this.partialAttributeList.size() != 0) {
            NamingEnumeration<? extends Attribute> attributes = this.partialAttributeList.getAll();
            this.attributeLength = new LinkedList();
            this.valsLength = new LinkedList();
            while (attributes.hasMoreElements()) {
                Attribute attribute = (Attribute)attributes.nextElement();
                int localAttributeLength = 0;
                int localValuesLength = 0;
                int idLength = attribute.getID().getBytes().length;
                localAttributeLength = 1 + TLV.getNbBytes((int)idLength) + idLength;
                if (attribute.size() != 0) {
                    try {
                        NamingEnumeration<?> values = attribute.getAll();
                        if (values.hasMoreElements()) {
                            localValuesLength = 0;
                            while (values.hasMoreElements()) {
                                Object value = values.next();
                                if (value instanceof String) {
                                    String stringValue = (String)value;
                                    int stringLength = StringTools.getBytesUtf8(stringValue).length;
                                    localValuesLength += 1 + TLV.getNbBytes((int)stringLength) + stringLength;
                                    continue;
                                }
                                byte[] binaryValue = (byte[])value;
                                localValuesLength += 1 + TLV.getNbBytes((int)binaryValue.length) + binaryValue.length;
                            }
                            localAttributeLength += 1 + TLV.getNbBytes((int)localValuesLength) + localValuesLength;
                        }
                        localAttributeLength += 2;
                    }
                    catch (NamingException ne) {
                        return 0;
                    }
                } else {
                    localAttributeLength += 2;
                }
                this.attributesLength += 1 + TLV.getNbBytes((int)localAttributeLength) + localAttributeLength;
                this.attributeLength.add(new Integer(localAttributeLength));
                this.valsLength.add(new Integer(localValuesLength));
            }
        }
        this.searchResultEntryLength += 1 + TLV.getNbBytes((int)this.attributesLength) + this.attributesLength;
        return 1 + TLV.getNbBytes((int)this.searchResultEntryLength) + this.searchResultEntryLength;
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        block10: {
            if (buffer == null) {
                throw new EncoderException("Cannot put a PDU in a null buffer !");
            }
            try {
                buffer.put((byte)100);
                buffer.put(TLV.getBytes((int)this.searchResultEntryLength));
                Value.encode((ByteBuffer)buffer, (byte[])LdapDN.getBytes(this.objectName));
                buffer.put((byte)48);
                buffer.put(TLV.getBytes((int)this.attributesLength));
                if (this.partialAttributeList == null || this.partialAttributeList.size() == 0) break block10;
                NamingEnumeration<? extends Attribute> attributes = this.partialAttributeList.getAll();
                int attributeNumber = 0;
                while (attributes.hasMoreElements()) {
                    Attribute attribute = (Attribute)attributes.nextElement();
                    buffer.put((byte)48);
                    int localAttributeLength = (Integer)this.attributeLength.get(attributeNumber);
                    buffer.put(TLV.getBytes((int)localAttributeLength));
                    Value.encode((ByteBuffer)buffer, (String)attribute.getID());
                    buffer.put((byte)49);
                    int localValuesLength = (Integer)this.valsLength.get(attributeNumber);
                    buffer.put(TLV.getBytes((int)localValuesLength));
                    if (attribute.size() != 0) {
                        try {
                            NamingEnumeration<?> values = attribute.getAll();
                            if (values.hasMoreElements()) {
                                while (values.hasMoreElements()) {
                                    Object value = values.next();
                                    if (value instanceof String) {
                                        Value.encode((ByteBuffer)buffer, (String)((String)value));
                                        continue;
                                    }
                                    Value.encode((ByteBuffer)buffer, (byte[])((byte[])value));
                                }
                            }
                        }
                        catch (NamingException ne) {
                            throw new EncoderException("Cannot enumerate the values");
                        }
                    }
                    ++attributeNumber;
                }
            }
            catch (BufferOverflowException boe) {
                throw new EncoderException("The PDU buffer size is too small !");
            }
        }
        return buffer;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    Search Result Entry\n");
        sb.append("        Object Name : '").append(this.objectName.toString()).append("'\n");
        sb.append("        Attributes\n");
        if (this.partialAttributeList == null || this.partialAttributeList.size() == 0) {
            sb.append("            No attributes\n");
        } else {
            sb.append(AttributeUtils.toString("            ", this.partialAttributeList));
        }
        return sb.toString();
    }

    public String getCurrentAttributeValueType() {
        return this.currentAttributeValue.getID();
    }
}

