/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.message;

import javax.naming.directory.Attributes;
import org.apache.directory.shared.ldap.message.AbstractAbandonableRequest;
import org.apache.directory.shared.ldap.message.AddRequest;
import org.apache.directory.shared.ldap.message.AddResponse;
import org.apache.directory.shared.ldap.message.AddResponseImpl;
import org.apache.directory.shared.ldap.message.MessageTypeEnum;
import org.apache.directory.shared.ldap.message.ResultResponse;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.util.AttributeUtils;

public class AddRequestImpl
extends AbstractAbandonableRequest
implements AddRequest {
    static final long serialVersionUID = 7534132448349520346L;
    private LdapDN entry;
    private Attributes attributes;
    private AddResponse response;

    public AddRequestImpl(int id) {
        super(id, TYPE);
    }

    public LdapDN getEntry() {
        return this.entry;
    }

    public void setEntry(LdapDN entry) {
        this.entry = entry;
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Attributes attributes) {
        this.attributes = attributes;
    }

    public MessageTypeEnum getResponseType() {
        return RESP_TYPE;
    }

    public ResultResponse getResultResponse() {
        if (this.response == null) {
            this.response = new AddResponseImpl(this.getMessageId());
        }
        return this.response;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        AddRequest req = (AddRequest)obj;
        if (this.entry != null && req.getEntry() == null) {
            return false;
        }
        if (this.entry == null && req.getEntry() != null) {
            return false;
        }
        if (this.entry != null && req.getEntry() != null && !this.entry.equals(req.getEntry())) {
            return false;
        }
        if (this.attributes != null && req.getAttributes() == null) {
            return false;
        }
        if (this.attributes == null && req.getAttributes() != null) {
            return false;
        }
        return this.attributes == null || req.getAttributes() == null || this.attributes.equals(req.getAttributes());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    Add Request\n");
        sb.append("        Entry : '").append(this.entry.toString()).append("'\n");
        if (this.attributes == null || this.attributes.size() == 0) {
            sb.append("            No attributes\n");
        } else {
            sb.append(AttributeUtils.toString("            ", this.attributes));
        }
        return sb.toString();
    }
}

