/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.util;

import java.io.UnsupportedEncodingException;
import org.apache.directory.shared.ldap.codec.util.LdapStringEncodingException;
import org.apache.directory.shared.ldap.util.StringTools;

public class LdapString {
    public static final transient LdapString EMPTY_STRING = new LdapString();
    protected String string;
    protected byte[] bytes;

    public LdapString() {
        this.bytes = StringTools.EMPTY_BYTES;
        this.string = "";
    }

    public LdapString(byte[] bytes) throws LdapStringEncodingException {
        try {
            this.string = new String(bytes, "UTF-8");
            this.bytes = new byte[bytes.length];
            System.arraycopy(bytes, 0, this.bytes, 0, bytes.length);
        }
        catch (UnsupportedEncodingException uee) {
            throw new LdapStringEncodingException("The byte array is not an UTF-8 encoded Unicode String : " + uee.getMessage());
        }
    }

    public String getString() {
        return this.string;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public int getNbBytes() {
        return this.bytes != null ? this.bytes.length : 0;
    }

    public String toString() {
        return this.string;
    }
}

