/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.modify;

import javax.naming.InvalidNameException;
import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.shared.asn1.ber.grammar.IGrammar;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.asn1.util.IntegerDecoder;
import org.apache.directory.shared.asn1.util.IntegerDecoderException;
import org.apache.directory.shared.ldap.codec.LdapMessage;
import org.apache.directory.shared.ldap.codec.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.LdapStatesEnum;
import org.apache.directory.shared.ldap.codec.ResponseCarryingException;
import org.apache.directory.shared.ldap.codec.modify.ModifyRequest;
import org.apache.directory.shared.ldap.codec.util.LdapString;
import org.apache.directory.shared.ldap.codec.util.LdapStringEncodingException;
import org.apache.directory.shared.ldap.message.ModifyResponseImpl;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModifyRequestGrammar
extends AbstractGrammar
implements IGrammar {
    private static final Logger log = LoggerFactory.getLogger((Class)ModifyRequestGrammar.class);
    private static final boolean IS_DEBUG = log.isDebugEnabled();
    private static IGrammar instance = new ModifyRequestGrammar();

    private ModifyRequestGrammar() {
        this.name = ModifyRequestGrammar.class.getName();
        this.statesEnum = LdapStatesEnum.getInstance();
        this.transitions = new GrammarTransition[LdapStatesEnum.LAST_MODIFY_REQUEST_STATE][256];
        this.transitions[LdapStatesEnum.MODIFY_REQUEST_TAG][102] = new GrammarTransition(LdapStatesEnum.MODIFY_REQUEST_TAG, LdapStatesEnum.MODIFY_REQUEST_VALUE, null);
        this.transitions[LdapStatesEnum.MODIFY_REQUEST_VALUE][102] = new GrammarTransition(LdapStatesEnum.MODIFY_REQUEST_VALUE, LdapStatesEnum.MODIFY_REQUEST_OBJECT_TAG, new GrammarAction("Init ModifyRequest"){

            public void action(IAsn1Container container) {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                ldapMessage.setProtocolOP(new ModifyRequest());
            }
        });
        this.transitions[LdapStatesEnum.MODIFY_REQUEST_OBJECT_TAG][4] = new GrammarTransition(LdapStatesEnum.MODIFY_REQUEST_OBJECT_TAG, LdapStatesEnum.MODIFY_REQUEST_OBJECT_VALUE, null);
        this.transitions[LdapStatesEnum.MODIFY_REQUEST_OBJECT_VALUE][4] = new GrammarTransition(LdapStatesEnum.MODIFY_REQUEST_OBJECT_VALUE, LdapStatesEnum.MODIFY_REQUEST_MODIFICATIONS_TAG, new GrammarAction("Store Modify request object Value"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                ModifyRequest modifyRequest = ldapMessage.getModifyRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                LdapDN object = LdapDN.EMPTY_LDAPDN;
                if (tlv.getLength().getLength() == 0) {
                    modifyRequest.setObject(object);
                } else {
                    byte[] dnBytes = tlv.getValue().getData();
                    try {
                        object = new LdapDN(dnBytes);
                    }
                    catch (InvalidNameException ine) {
                        String msg = "Invalid DN given : " + StringTools.utf8ToString(dnBytes) + " (" + StringTools.dumpBytes(dnBytes) + ") is invalid";
                        log.error("{} : {}", (Object)msg, (Object)ine.getMessage());
                        ModifyResponseImpl response = new ModifyResponseImpl(ldapMessage.getMessageId());
                        throw new ResponseCarryingException(msg, response, ResultCodeEnum.INVALIDDNSYNTAX, LdapDN.EMPTY_LDAPDN, ine);
                    }
                    modifyRequest.setObject(object);
                }
                if (IS_DEBUG) {
                    log.debug("Modification of DN {}", (Object)modifyRequest.getObject());
                }
            }
        });
        this.transitions[LdapStatesEnum.MODIFY_REQUEST_MODIFICATIONS_TAG][48] = new GrammarTransition(LdapStatesEnum.MODIFY_REQUEST_MODIFICATIONS_TAG, LdapStatesEnum.MODIFY_REQUEST_MODIFICATIONS_VALUE, null);
        this.transitions[LdapStatesEnum.MODIFY_REQUEST_MODIFICATIONS_VALUE][48] = new GrammarTransition(LdapStatesEnum.MODIFY_REQUEST_MODIFICATIONS_VALUE, LdapStatesEnum.MODIFY_REQUEST_MODIFICATION_SEQUENCE_TAG, new GrammarAction("Init modifications array list"){

            public void action(IAsn1Container container) {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                ModifyRequest modifyRequest = ldapMessage.getModifyRequest();
                modifyRequest.initModifications();
            }
        });
        this.transitions[LdapStatesEnum.MODIFY_REQUEST_MODIFICATION_SEQUENCE_TAG][48] = new GrammarTransition(LdapStatesEnum.MODIFY_REQUEST_MODIFICATION_SEQUENCE_TAG, LdapStatesEnum.MODIFY_REQUEST_MODIFICATION_SEQUENCE_VALUE, null);
        this.transitions[LdapStatesEnum.MODIFY_REQUEST_ATTRIBUTE_VALUE_OR_MODIFICATION_TAG][48] = new GrammarTransition(LdapStatesEnum.MODIFY_REQUEST_ATTRIBUTE_VALUE_OR_MODIFICATION_TAG, LdapStatesEnum.MODIFY_REQUEST_MODIFICATION_SEQUENCE_VALUE, null);
        this.transitions[LdapStatesEnum.MODIFY_REQUEST_MODIFICATION_SEQUENCE_VALUE][48] = new GrammarTransition(LdapStatesEnum.MODIFY_REQUEST_MODIFICATION_SEQUENCE_VALUE, LdapStatesEnum.MODIFY_REQUEST_OPERATION_TAG, null);
        this.transitions[LdapStatesEnum.MODIFY_REQUEST_OPERATION_TAG][10] = new GrammarTransition(LdapStatesEnum.MODIFY_REQUEST_OPERATION_TAG, LdapStatesEnum.MODIFY_REQUEST_OPERATION_VALUE, null);
        this.transitions[LdapStatesEnum.MODIFY_REQUEST_OPERATION_VALUE][10] = new GrammarTransition(LdapStatesEnum.MODIFY_REQUEST_OPERATION_VALUE, LdapStatesEnum.MODIFY_REQUEST_MODIFICATION_TAG, new GrammarAction("Store operation type"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                ModifyRequest modifyRequest = ldapMessage.getModifyRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                int operation = 0;
                try {
                    operation = IntegerDecoder.parse((Value)tlv.getValue(), (int)0, (int)2);
                }
                catch (IntegerDecoderException ide) {
                    String msg = "Invalid operation ( " + StringTools.dumpBytes(tlv.getValue().getData()) + "), it should be 0, 1 or 2";
                    log.error(msg);
                    throw new DecoderException(msg);
                }
                modifyRequest.setCurrentOperation(operation);
                if (IS_DEBUG) {
                    switch (operation) {
                        case 0: {
                            log.debug("Modification operation : ADD");
                            break;
                        }
                        case 1: {
                            log.debug("Modification operation : DELETE");
                            break;
                        }
                        case 2: {
                            log.debug("Modification operation : REPLACE");
                        }
                    }
                }
            }
        });
        this.transitions[LdapStatesEnum.MODIFY_REQUEST_MODIFICATION_TAG][48] = new GrammarTransition(LdapStatesEnum.MODIFY_REQUEST_MODIFICATION_TAG, LdapStatesEnum.MODIFY_REQUEST_MODIFICATION_VALUE, null);
        this.transitions[LdapStatesEnum.MODIFY_REQUEST_MODIFICATION_VALUE][48] = new GrammarTransition(LdapStatesEnum.MODIFY_REQUEST_MODIFICATION_VALUE, LdapStatesEnum.MODIFY_REQUEST_TYPE_TAG, null);
        this.transitions[LdapStatesEnum.MODIFY_REQUEST_TYPE_TAG][4] = new GrammarTransition(LdapStatesEnum.MODIFY_REQUEST_TYPE_TAG, LdapStatesEnum.MODIFY_REQUEST_TYPE_VALUE, null);
        this.transitions[LdapStatesEnum.MODIFY_REQUEST_TYPE_VALUE][4] = new GrammarTransition(LdapStatesEnum.MODIFY_REQUEST_TYPE_VALUE, LdapStatesEnum.MODIFY_REQUEST_VALS_TAG, new GrammarAction("Store type"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                ModifyRequest modifyRequest = ldapMessage.getModifyRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                LdapString type = null;
                if (tlv.getLength().getLength() == 0) {
                    String msg = "The type can't be null";
                    log.error(msg);
                    ModifyResponseImpl response = new ModifyResponseImpl(ldapMessage.getMessageId());
                    throw new ResponseCarryingException(msg, response, ResultCodeEnum.INVALIDATTRIBUTESYNTAX, modifyRequest.getObject(), null);
                }
                try {
                    type = new LdapString(tlv.getValue().getData());
                    modifyRequest.addAttributeTypeAndValues(type);
                }
                catch (LdapStringEncodingException lsee) {
                    String msg = "Invalid type : " + StringTools.dumpBytes(tlv.getValue().getData());
                    log.error(msg);
                    ModifyResponseImpl response = new ModifyResponseImpl(ldapMessage.getMessageId());
                    throw new ResponseCarryingException(msg, response, ResultCodeEnum.INVALIDATTRIBUTESYNTAX, modifyRequest.getObject(), lsee);
                }
                if (IS_DEBUG) {
                    log.debug("Modifying type : {}", (Object)type);
                }
            }
        });
        this.transitions[LdapStatesEnum.MODIFY_REQUEST_VALS_TAG][49] = new GrammarTransition(LdapStatesEnum.MODIFY_REQUEST_VALS_TAG, LdapStatesEnum.MODIFY_REQUEST_VALS_VALUE, null);
        this.transitions[LdapStatesEnum.MODIFY_REQUEST_VALS_VALUE][49] = new GrammarTransition(LdapStatesEnum.MODIFY_REQUEST_VALS_VALUE, LdapStatesEnum.MODIFY_REQUEST_ATTRIBUTE_VALUE_OR_MODIFICATION_TAG, new GrammarAction("Attribute vals"){

            public void action(IAsn1Container container) {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                if (tlv.getLength().getLength() == 0) {
                    log.debug("No vals for this attribute");
                }
                ldapMessageContainer.grammarEndAllowed(true);
                ldapMessageContainer.grammarPopAllowed(true);
                log.debug("Some vals are to be decoded");
            }
        });
        this.transitions[LdapStatesEnum.MODIFY_REQUEST_ATTRIBUTE_VALUE_TAG][48] = new GrammarTransition(LdapStatesEnum.MODIFY_REQUEST_VALS_VALUE, LdapStatesEnum.MODIFY_REQUEST_ATTRIBUTE_VALUE_OR_MODIFICATION_TAG, null);
        this.transitions[LdapStatesEnum.MODIFY_REQUEST_ATTRIBUTE_VALUE_TAG][4] = new GrammarTransition(LdapStatesEnum.MODIFY_REQUEST_ATTRIBUTE_VALUE_TAG, LdapStatesEnum.MODIFY_REQUEST_ATTRIBUTE_VALUE_VALUE, null);
        this.transitions[LdapStatesEnum.MODIFY_REQUEST_ATTRIBUTE_VALUE_OR_MODIFICATION_TAG][4] = new GrammarTransition(LdapStatesEnum.MODIFY_REQUEST_ATTRIBUTE_VALUE_OR_MODIFICATION_TAG, LdapStatesEnum.MODIFY_REQUEST_ATTRIBUTE_VALUE_VALUE, null);
        this.transitions[LdapStatesEnum.MODIFY_REQUEST_ATTRIBUTE_VALUE_VALUE][4] = new GrammarTransition(LdapStatesEnum.MODIFY_REQUEST_ATTRIBUTE_VALUE_VALUE, LdapStatesEnum.MODIFY_REQUEST_ATTRIBUTE_VALUE_OR_MODIFICATION_TAG, new GrammarAction("Store value"){

            public void action(IAsn1Container container) {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                ModifyRequest modifyRequest = ldapMessage.getModifyRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                byte[] value = StringTools.EMPTY_BYTES;
                if (tlv.getLength().getLength() == 0) {
                    modifyRequest.addAttributeValue("");
                } else {
                    value = tlv.getValue().getData();
                    if (ldapMessageContainer.isBinary(modifyRequest.getCurrentAttributeType())) {
                        modifyRequest.addAttributeValue(value);
                    } else {
                        modifyRequest.addAttributeValue(StringTools.utf8ToString(value));
                    }
                }
                ldapMessageContainer.grammarEndAllowed(true);
                ldapMessageContainer.grammarPopAllowed(true);
                log.debug("Value modified : {}", (Object)value);
            }
        });
    }

    public static IGrammar getInstance() {
        return instance;
    }
}

