/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.compare;

import javax.naming.InvalidNameException;
import javax.naming.NamingException;
import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.shared.asn1.ber.grammar.IGrammar;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.ldap.codec.LdapMessage;
import org.apache.directory.shared.ldap.codec.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.LdapStatesEnum;
import org.apache.directory.shared.ldap.codec.ResponseCarryingException;
import org.apache.directory.shared.ldap.codec.compare.CompareRequest;
import org.apache.directory.shared.ldap.codec.util.LdapString;
import org.apache.directory.shared.ldap.codec.util.LdapStringEncodingException;
import org.apache.directory.shared.ldap.exception.LdapInvalidAttributeIdentifierException;
import org.apache.directory.shared.ldap.message.CompareResponseImpl;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompareRequestGrammar
extends AbstractGrammar
implements IGrammar {
    private static final Logger log = LoggerFactory.getLogger((Class)CompareRequestGrammar.class);
    private static final boolean IS_DEBUG = log.isDebugEnabled();
    private static IGrammar instance = new CompareRequestGrammar();

    private CompareRequestGrammar() {
        this.name = CompareRequestGrammar.class.getName();
        this.statesEnum = LdapStatesEnum.getInstance();
        this.transitions = new GrammarTransition[LdapStatesEnum.LAST_COMPARE_REQUEST_STATE][256];
        this.transitions[LdapStatesEnum.COMPARE_REQUEST_TAG][110] = new GrammarTransition(LdapStatesEnum.COMPARE_REQUEST_TAG, LdapStatesEnum.COMPARE_REQUEST_VALUE, null);
        this.transitions[LdapStatesEnum.COMPARE_REQUEST_VALUE][110] = new GrammarTransition(LdapStatesEnum.COMPARE_REQUEST_VALUE, LdapStatesEnum.COMPARE_REQUEST_ENTRY_TAG, new GrammarAction("Init Compare Request"){

            public void action(IAsn1Container container) {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                ldapMessage.setProtocolOP(new CompareRequest());
            }
        });
        this.transitions[LdapStatesEnum.COMPARE_REQUEST_ENTRY_TAG][4] = new GrammarTransition(LdapStatesEnum.COMPARE_REQUEST_ENTRY_TAG, LdapStatesEnum.COMPARE_REQUEST_ENTRY_VALUE, null);
        this.transitions[LdapStatesEnum.COMPARE_REQUEST_ENTRY_VALUE][4] = new GrammarTransition(LdapStatesEnum.COMPARE_REQUEST_ENTRY_VALUE, LdapStatesEnum.COMPARE_REQUEST_AVA_TAG, new GrammarAction("Store entry"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                CompareRequest compareRequest = ldapMessage.getCompareRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                LdapDN entry = null;
                if (tlv.getLength().getLength() == 0) {
                    throw new DecoderException("The entry must not be null");
                }
                byte[] dnBytes = tlv.getValue().getData();
                try {
                    entry = new LdapDN(dnBytes);
                }
                catch (InvalidNameException ine) {
                    String msg = "Invalid DN given : " + StringTools.utf8ToString(dnBytes) + " (" + StringTools.dumpBytes(dnBytes) + ") is invalid";
                    log.error("{} : {}", (Object)msg, (Object)ine.getMessage());
                    CompareResponseImpl response = new CompareResponseImpl(ldapMessage.getMessageId());
                    throw new ResponseCarryingException(msg, response, ResultCodeEnum.INVALIDDNSYNTAX, LdapDN.EMPTY_LDAPDN, ine);
                }
                compareRequest.setEntry(entry);
                if (IS_DEBUG) {
                    log.debug("Comparing DN {}", (Object)entry);
                }
            }
        });
        this.transitions[LdapStatesEnum.COMPARE_REQUEST_AVA_TAG][48] = new GrammarTransition(LdapStatesEnum.COMPARE_REQUEST_AVA_TAG, LdapStatesEnum.COMPARE_REQUEST_AVA_VALUE, null);
        this.transitions[LdapStatesEnum.COMPARE_REQUEST_AVA_VALUE][48] = new GrammarTransition(LdapStatesEnum.COMPARE_REQUEST_AVA_VALUE, LdapStatesEnum.COMPARE_REQUEST_ATTRIBUTE_DESC_TAG, null);
        this.transitions[LdapStatesEnum.COMPARE_REQUEST_ATTRIBUTE_DESC_TAG][4] = new GrammarTransition(LdapStatesEnum.COMPARE_REQUEST_ATTRIBUTE_DESC_TAG, LdapStatesEnum.COMPARE_REQUEST_ATTRIBUTE_DESC_VALUE, null);
        this.transitions[LdapStatesEnum.COMPARE_REQUEST_ATTRIBUTE_DESC_VALUE][4] = new GrammarTransition(LdapStatesEnum.COMPARE_REQUEST_ATTRIBUTE_DESC_VALUE, LdapStatesEnum.COMPARE_REQUEST_ASSERTION_VALUE_TAG, new GrammarAction("Store attribute desc"){

            public void action(IAsn1Container container) throws DecoderException, NamingException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                CompareRequest compareRequest = ldapMessage.getCompareRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                if (tlv.getLength().getLength() == 0) {
                    String msg = "The attribute description must not be null";
                    log.error(msg);
                    CompareResponseImpl response = new CompareResponseImpl(ldapMessage.getMessageId());
                    throw new ResponseCarryingException(msg, response, ResultCodeEnum.INVALIDATTRIBUTESYNTAX, compareRequest.getEntry(), null);
                }
                try {
                    LdapString type = new LdapString(tlv.getValue().getData());
                    compareRequest.setAttributeDesc(type);
                }
                catch (LdapStringEncodingException lsee) {
                    log.error("The attribute description ({}) is invalid.", (Object)StringTools.dumpBytes(tlv.getValue().getData()));
                    throw new LdapInvalidAttributeIdentifierException("Invalid attribute type : " + lsee.getMessage());
                }
                if (IS_DEBUG) {
                    log.debug("Comparing attribute description {}", (Object)compareRequest.getAttributeDesc());
                }
            }
        });
        this.transitions[LdapStatesEnum.COMPARE_REQUEST_ASSERTION_VALUE_TAG][4] = new GrammarTransition(LdapStatesEnum.COMPARE_REQUEST_ASSERTION_VALUE_TAG, LdapStatesEnum.COMPARE_REQUEST_ASSERTION_VALUE_VALUE, null);
        this.transitions[LdapStatesEnum.COMPARE_REQUEST_ASSERTION_VALUE_VALUE][4] = new GrammarTransition(LdapStatesEnum.COMPARE_REQUEST_ASSERTION_VALUE_VALUE, -1, new GrammarAction("Store assertion value"){

            public void action(IAsn1Container container) {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                CompareRequest compareRequest = ldapMessage.getCompareRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                if (tlv.getLength().getLength() == 0) {
                    compareRequest.setAssertionValue("");
                } else if (ldapMessageContainer.isBinary(compareRequest.getAttributeDesc())) {
                    compareRequest.setAssertionValue(tlv.getValue().getData());
                    if (IS_DEBUG) {
                        log.debug("Comparing attribute value {}", (Object)StringTools.dumpBytes((byte[])compareRequest.getAssertionValue()));
                    }
                } else {
                    compareRequest.setAssertionValue(StringTools.utf8ToString(tlv.getValue().getData()));
                    if (log.isDebugEnabled()) {
                        log.debug("Comparing attribute value {}", compareRequest.getAssertionValue());
                    }
                }
                ldapMessageContainer.grammarEndAllowed(true);
                ldapMessageContainer.grammarPopAllowed(true);
            }
        });
    }

    public static IGrammar getInstance() {
        return instance;
    }
}

