/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.name;

import javax.naming.InvalidNameException;
import org.apache.directory.shared.ldap.name.Rdn;
import org.apache.directory.shared.ldap.util.DNUtils;
import org.apache.directory.shared.ldap.util.StringTools;

public class RdnParser {
    private static int parseOidValue(char[] chars, int pos) {
        if (!StringTools.isDigit(chars, pos)) {
            return -1;
        }
        ++pos;
        while (StringTools.isDigit(chars, pos)) {
            ++pos;
        }
        if (!StringTools.isCharASCII(chars, pos, '.')) {
            return pos;
        }
        do {
            if (!StringTools.isDigit(chars, ++pos)) {
                return -1;
            }
            ++pos;
            while (StringTools.isDigit(chars, pos)) {
                ++pos;
            }
        } while (StringTools.isCharASCII(chars, pos, '.'));
        return pos;
    }

    private static int parseOidPrefix(char[] chars, int pos) {
        if (StringTools.areEquals(chars, pos, DNUtils.OID_LOWER) == -1 && StringTools.areEquals(chars, pos, DNUtils.OID_UPPER) == -1) {
            return -1;
        }
        return pos += DNUtils.OID_LOWER.length;
    }

    private static int parseAttributeType(char[] chars, int pos) {
        if (StringTools.isAlphaASCII(chars, pos)) {
            int oldPos = pos;
            if ((pos = RdnParser.parseOidPrefix(chars, oldPos)) != -1) {
                return RdnParser.parseOidValue(chars, pos);
            }
            pos = oldPos + 1;
            while (StringTools.isAlphaDigitMinus(chars, pos)) {
                ++pos;
            }
            return pos;
        }
        return RdnParser.parseOidValue(chars, pos);
    }

    private static int parseAttributeValue(char[] chars, int pos) {
        if (StringTools.isCharASCII(chars, pos, '#')) {
            ++pos;
            if ((pos = DNUtils.parseHexString(chars, pos)) == -1) {
                return -1;
            }
            return StringTools.trimLeft(chars, pos);
        }
        if (StringTools.isCharASCII(chars, pos, '\"')) {
            ++pos;
            int nbBytes = 0;
            while (true) {
                if (StringTools.isCharASCII(chars, pos, '\\')) {
                    if (DNUtils.isPairChar(chars, ++pos)) {
                        ++pos;
                        continue;
                    }
                    return -1;
                }
                nbBytes = DNUtils.isQuoteChar(chars, pos);
                if (nbBytes == -1) break;
                pos += nbBytes;
            }
            if (StringTools.isCharASCII(chars, pos, '\"')) {
                return StringTools.trimLeft(chars, ++pos);
            }
            return -1;
        }
        while (true) {
            if (StringTools.isCharASCII(chars, pos, '\\')) {
                if (!DNUtils.isPairChar(chars, ++pos)) {
                    return -1;
                }
                ++pos;
                continue;
            }
            int nbChars = 0;
            nbChars = DNUtils.isStringChar(chars, pos);
            if (nbChars == -1) break;
            if (StringTools.isCharASCII(chars, pos, ' ')) {
                if (DNUtils.isStringChar(chars, pos = StringTools.trimLeft(chars, pos)) != -1 || StringTools.isCharASCII(chars, pos, '\\')) continue;
                return pos;
            }
            pos += nbChars;
        }
        return pos;
    }

    private static int parseNameComponents(char[] chars, int pos, Rdn rdn) throws InvalidNameException {
        int newPos = 0;
        String type = null;
        String value = null;
        while (true) {
            if (StringTools.isCharASCII(chars, pos = StringTools.trimLeft(chars, pos), '+')) {
                ++pos;
            } else {
                return pos;
            }
            pos = StringTools.trimLeft(chars, pos);
            newPos = RdnParser.parseAttributeType(chars, pos);
            if (newPos == -1) {
                return -1;
            }
            if (rdn != null) {
                type = new String(chars, pos, newPos - pos);
            }
            if (StringTools.isCharASCII(chars, pos = StringTools.trimLeft(chars, newPos), '=')) {
                ++pos;
            } else {
                return -1;
            }
            pos = StringTools.trimLeft(chars, pos);
            newPos = RdnParser.parseAttributeValue(chars, pos);
            if (newPos != -1 && rdn != null) {
                newPos = StringTools.trimRight(chars, newPos);
                value = new String(chars, pos, newPos - pos);
                rdn.addAttributeTypeAndValue(type, value);
            }
            pos = newPos;
        }
    }

    public static int unescapeValue(String value) throws IllegalArgumentException {
        int pos;
        char[] chars = value.toCharArray();
        if (StringTools.isCharASCII(chars, pos = 0, '#')) {
            ++pos;
            if ((pos = DNUtils.parseHexString(chars, pos)) == -1) {
                throw new IllegalArgumentException();
            }
            return StringTools.trimLeft(chars, pos);
        }
        if (StringTools.isCharASCII(chars, pos, '\"')) {
            ++pos;
            int nbBytes = 0;
            while (true) {
                if (StringTools.isCharASCII(chars, pos, '\\')) {
                    if (DNUtils.isPairChar(chars, ++pos)) {
                        ++pos;
                        continue;
                    }
                    return -1;
                }
                nbBytes = DNUtils.isQuoteChar(chars, pos);
                if (nbBytes == -1) break;
                pos += nbBytes;
            }
            if (StringTools.isCharASCII(chars, pos, '\"')) {
                return StringTools.trimLeft(chars, ++pos);
            }
            return -1;
        }
        while (true) {
            if (StringTools.isCharASCII(chars, pos, '\\')) {
                if (!DNUtils.isPairChar(chars, ++pos)) {
                    return -1;
                }
                ++pos;
                continue;
            }
            int nbChars = 0;
            nbChars = DNUtils.isStringChar(chars, pos);
            if (nbChars == -1) break;
            if (StringTools.isCharASCII(chars, pos, ' ')) {
                if (DNUtils.isStringChar(chars, pos = StringTools.trimLeft(chars, pos)) != -1 || StringTools.isCharASCII(chars, pos, '\\')) continue;
                return pos;
            }
            pos += nbChars;
        }
        return pos;
    }

    public static int parse(char[] chars, int pos, Rdn rdn) throws InvalidNameException {
        int newPos = 0;
        String type = null;
        String value = null;
        int start = pos;
        newPos = RdnParser.parseAttributeType(chars, pos = StringTools.trimLeft(chars, pos));
        if (newPos == -1) {
            return -1;
        }
        if (rdn != null) {
            type = new String(chars, pos, newPos - pos);
        }
        if (!StringTools.isCharASCII(chars, pos = StringTools.trimLeft(chars, newPos), '=')) {
            return -1;
        }
        ++pos;
        newPos = RdnParser.parseAttributeValue(chars, pos = StringTools.trimLeft(chars, pos));
        if (newPos == -1) {
            return -1;
        }
        if (rdn != null) {
            newPos = StringTools.trimRight(chars, newPos);
            value = new String(chars, pos, newPos - pos);
            rdn.addAttributeTypeAndValue(type, value);
        }
        int end = RdnParser.parseNameComponents(chars, newPos, rdn);
        rdn.setUpName(new String(chars, start, end - start));
        rdn.normalizeString();
        return end;
    }

    public static void parse(String string, Rdn rdn) throws InvalidNameException {
        RdnParser.parse(string.toCharArray(), 0, rdn);
        rdn.normalizeString();
    }
}

