/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.search;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.directory.shared.asn1.ber.tlv.Length;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.ldap.codec.search.Filter;
import org.apache.directory.shared.ldap.codec.util.LdapString;
import org.apache.directory.shared.ldap.util.StringTools;

public class ExtensibleMatchFilter
extends Filter {
    private transient int expectedMatchingRuleLength;
    private LdapString matchingRule;
    private LdapString type;
    private Object matchValue;
    private boolean dnAttributes = false;
    private transient int extensibleMatchLength;

    public boolean isDnAttributes() {
        return this.dnAttributes;
    }

    public void setDnAttributes(boolean dnAttributes) {
        this.dnAttributes = dnAttributes;
    }

    public LdapString getMatchingRule() {
        return this.matchingRule;
    }

    public void setMatchingRule(LdapString matchingRule) {
        this.matchingRule = matchingRule;
    }

    public Object getMatchValue() {
        return this.matchValue;
    }

    public void setMatchValue(Object matchValue) {
        this.matchValue = matchValue;
    }

    public LdapString getType() {
        return this.type;
    }

    public void setType(LdapString type) {
        this.type = type;
    }

    public int getExpectedMatchingRuleLength() {
        return this.expectedMatchingRuleLength;
    }

    public void setExpectedMatchingRuleLength(int expectedMatchingRuleLength) {
        this.expectedMatchingRuleLength = expectedMatchingRuleLength;
    }

    public int computeLength() {
        if (this.matchingRule != null) {
            this.extensibleMatchLength = 1 + Length.getNbBytes((int)this.matchingRule.getNbBytes()) + this.matchingRule.getNbBytes();
        }
        if (this.type != null) {
            this.extensibleMatchLength += 1 + Length.getNbBytes((int)this.type.getNbBytes()) + this.type.getNbBytes();
        }
        if (this.matchValue != null) {
            if (this.matchValue instanceof String) {
                int matchValueLength = StringTools.getBytesUtf8((String)this.matchValue).length;
                this.extensibleMatchLength += 1 + Length.getNbBytes((int)matchValueLength) + matchValueLength;
            } else {
                this.extensibleMatchLength += 1 + Length.getNbBytes((int)((byte[])this.matchValue).length) + ((byte[])this.matchValue).length;
            }
        }
        if (this.dnAttributes) {
            this.extensibleMatchLength += 3;
        }
        return 1 + Length.getNbBytes((int)this.extensibleMatchLength) + this.extensibleMatchLength;
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException("Cannot put a PDU in a null buffer !");
        }
        try {
            buffer.put((byte)-87);
            buffer.put(Length.getBytes((int)this.extensibleMatchLength));
            if (this.matchingRule == null && this.type == null) {
                throw new EncoderException("Cannot have a null matching rule and a null type");
            }
            if (this.matchingRule != null) {
                buffer.put((byte)-127);
                buffer.put(Length.getBytes((int)this.matchingRule.getNbBytes()));
                buffer.put(this.matchingRule.getBytes());
            }
            if (this.type != null) {
                buffer.put((byte)-126);
                buffer.put(Length.getBytes((int)this.type.getNbBytes()));
                buffer.put(this.type.getBytes());
            }
            if (this.matchValue != null) {
                buffer.put((byte)-125);
                if (this.matchValue instanceof String) {
                    byte[] matchValueBytes = StringTools.getBytesUtf8((String)this.matchValue);
                    buffer.put(Length.getBytes((int)matchValueBytes.length));
                    if (matchValueBytes.length != 0) {
                        buffer.put(matchValueBytes);
                    }
                } else {
                    buffer.put(Length.getBytes((int)((byte[])this.matchValue).length));
                    if (((byte[])this.matchValue).length != 0) {
                        buffer.put((byte[])this.matchValue);
                    }
                }
            }
            if (this.dnAttributes) {
                buffer.put((byte)-124);
                buffer.put((byte)1);
                buffer.put((byte)-1);
            }
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException("The PDU buffer size is too small !");
        }
        return buffer;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.type != null) {
            sb.append(this.type.toString());
        }
        if (this.dnAttributes) {
            sb.append(":dn");
        }
        if (this.matchingRule == null) {
            if (this.type == null) {
                return "Extended Filter wrong syntax";
            }
        } else {
            sb.append(':').append(this.matchingRule.toString());
        }
        sb.append(":=").append(this.matchValue.toString());
        return sb.toString();
    }
}

