/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.modifyDn;

import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NamingException;
import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.shared.asn1.ber.grammar.IGrammar;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.asn1.util.BooleanDecoder;
import org.apache.directory.shared.asn1.util.BooleanDecoderException;
import org.apache.directory.shared.ldap.codec.LdapMessage;
import org.apache.directory.shared.ldap.codec.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.LdapStatesEnum;
import org.apache.directory.shared.ldap.codec.modifyDn.ModifyDNRequest;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.name.Rdn;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModifyDNRequestGrammar
extends AbstractGrammar
implements IGrammar {
    private static final Logger log = LoggerFactory.getLogger((Class)ModifyDNRequestGrammar.class);
    private static IGrammar instance = new ModifyDNRequestGrammar();

    private ModifyDNRequestGrammar() {
        this.name = ModifyDNRequestGrammar.class.getName();
        this.statesEnum = LdapStatesEnum.getInstance();
        this.transitions = new GrammarTransition[LdapStatesEnum.LAST_MODIFY_DN_REQUEST_STATE][256];
        this.transitions[LdapStatesEnum.MODIFY_DN_REQUEST_TAG][108] = new GrammarTransition(LdapStatesEnum.MODIFY_DN_REQUEST_TAG, LdapStatesEnum.MODIFY_DN_REQUEST_VALUE, null);
        this.transitions[LdapStatesEnum.MODIFY_DN_REQUEST_VALUE][108] = new GrammarTransition(LdapStatesEnum.MODIFY_DN_REQUEST_VALUE, LdapStatesEnum.MODIFY_DN_REQUEST_ENTRY_TAG, new GrammarAction("Init Modify DN Request"){

            public void action(IAsn1Container container) {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                ldapMessage.setProtocolOP(new ModifyDNRequest());
            }
        });
        this.transitions[LdapStatesEnum.MODIFY_DN_REQUEST_ENTRY_TAG][4] = new GrammarTransition(LdapStatesEnum.MODIFY_DN_REQUEST_ENTRY_TAG, LdapStatesEnum.MODIFY_DN_REQUEST_ENTRY_VALUE, null);
        this.transitions[LdapStatesEnum.MODIFY_DN_REQUEST_ENTRY_VALUE][4] = new GrammarTransition(LdapStatesEnum.MODIFY_DN_REQUEST_ENTRY_VALUE, LdapStatesEnum.MODIFY_DN_REQUEST_NEW_RDN_TAG, new GrammarAction("Store entry"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                ModifyDNRequest modifyDNRequest = ldapMessage.getModifyDNRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                Name entry = null;
                if (tlv.getLength().getLength() == 0) {
                    throw new DecoderException("The entry must nut be null");
                }
                try {
                    entry = new LdapDN(tlv.getValue().getData());
                    entry = LdapDN.normalize(entry);
                }
                catch (InvalidNameException ine) {
                    String msg = "The DN to modify  (" + StringTools.dumpBytes(tlv.getValue().getData()) + ") is invalid";
                    log.error("{} : {}", (Object)msg, (Object)ine.getMessage());
                    throw new DecoderException(msg, (Throwable)ine);
                }
                catch (NamingException ne) {
                    String msg = "The DN to modify  (" + StringTools.dumpBytes(tlv.getValue().getData()) + ") is invalid";
                    log.error("{} : {}", (Object)msg, (Object)ne.getMessage());
                    throw new DecoderException(msg, (Throwable)ne);
                }
                modifyDNRequest.setEntry(entry);
                if (log.isDebugEnabled()) {
                    log.debug("Modifying DN {}", (Object)entry);
                }
            }
        });
        this.transitions[LdapStatesEnum.MODIFY_DN_REQUEST_NEW_RDN_TAG][4] = new GrammarTransition(LdapStatesEnum.MODIFY_DN_REQUEST_NEW_RDN_TAG, LdapStatesEnum.MODIFY_DN_REQUEST_NEW_RDN_VALUE, null);
        this.transitions[LdapStatesEnum.MODIFY_DN_REQUEST_NEW_RDN_VALUE][4] = new GrammarTransition(LdapStatesEnum.MODIFY_DN_REQUEST_NEW_RDN_VALUE, LdapStatesEnum.MODIFY_DN_REQUEST_DELETE_OLD_RDN_TAG, new GrammarAction("Store new RDN"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                ModifyDNRequest modifyDNRequest = ldapMessage.getModifyDNRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                Rdn newRdn = null;
                if (tlv.getLength().getLength() == 0) {
                    throw new DecoderException("The newrdn must nut be null");
                }
                try {
                    Name dn = new LdapDN(tlv.getValue().getData());
                    dn = LdapDN.normalize(dn);
                    newRdn = ((LdapDN)dn).getRdn(0);
                }
                catch (InvalidNameException ine) {
                    String msg = "The new RDN (" + StringTools.dumpBytes(tlv.getValue().getData()) + ") is invalid";
                    log.error("{} : {}", (Object)msg, (Object)ine.getMessage());
                    throw new DecoderException(msg, (Throwable)ine);
                }
                catch (NamingException ne) {
                    String msg = "The new RDN (" + StringTools.dumpBytes(tlv.getValue().getData()) + ") is invalid";
                    log.error("{} : {}", (Object)msg, (Object)ne.getMessage());
                    throw new DecoderException(msg, (Throwable)ne);
                }
                modifyDNRequest.setNewRDN(newRdn);
                if (log.isDebugEnabled()) {
                    log.debug("Modifying with new RDN {}", (Object)newRdn);
                }
            }
        });
        this.transitions[LdapStatesEnum.MODIFY_DN_REQUEST_DELETE_OLD_RDN_TAG][1] = new GrammarTransition(LdapStatesEnum.MODIFY_DN_REQUEST_DELETE_OLD_RDN_TAG, LdapStatesEnum.MODIFY_DN_REQUEST_DELETE_OLD_RDN_VALUE, null);
        this.transitions[LdapStatesEnum.MODIFY_DN_REQUEST_DELETE_OLD_RDN_VALUE][1] = new GrammarTransition(LdapStatesEnum.MODIFY_DN_REQUEST_DELETE_OLD_RDN_VALUE, LdapStatesEnum.MODIFY_DN_REQUEST_NEW_SUPERIOR_TAG, new GrammarAction("Store matching dnAttributes Value"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                ModifyDNRequest modifyDNRequest = ldapMessage.getModifyDNRequest();
                Value value = tlv.getValue();
                try {
                    modifyDNRequest.setDeleteOldRDN(BooleanDecoder.parse((Value)value));
                }
                catch (BooleanDecoderException bde) {
                    log.error("The oldRDN flag {} is invalid : {}. It should be 0 or 255", (Object)StringTools.dumpBytes(value.getData()), (Object)bde.getMessage());
                    throw new DecoderException(bde.getMessage());
                }
                ldapMessageContainer.grammarEndAllowed(true);
                ldapMessageContainer.grammarPopAllowed(true);
                if (log.isDebugEnabled()) {
                    if (modifyDNRequest.isDeleteOldRDN()) {
                        log.debug(" Old RDN attributes will be deleted");
                    } else {
                        log.debug(" Old RDN attributes will be retained");
                    }
                }
            }
        });
        this.transitions[LdapStatesEnum.MODIFY_DN_REQUEST_NEW_SUPERIOR_TAG][128] = new GrammarTransition(LdapStatesEnum.MODIFY_DN_REQUEST_NEW_SUPERIOR_TAG, LdapStatesEnum.MODIFY_DN_REQUEST_NEW_SUPERIOR_VALUE, null);
        this.transitions[LdapStatesEnum.MODIFY_DN_REQUEST_NEW_SUPERIOR_VALUE][128] = new GrammarTransition(LdapStatesEnum.MODIFY_DN_REQUEST_NEW_SUPERIOR_VALUE, -1, new GrammarAction("Store new superior"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                ModifyDNRequest modifyDNRequest = ldapMessage.getModifyDNRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                Name newSuperior = LdapDN.EMPTY_LDAPDN;
                if (tlv.getLength().getLength() == 0) {
                    if (modifyDNRequest.isDeleteOldRDN()) {
                        throw new DecoderException("The new superior must nut be null if the flag 'delete old DN' is set to true");
                    }
                    log.warn("The new superior is null, so we will change the entry");
                    modifyDNRequest.setNewSuperior(newSuperior);
                } else {
                    try {
                        newSuperior = new LdapDN(tlv.getValue().getData());
                        newSuperior = LdapDN.normalize(newSuperior);
                    }
                    catch (InvalidNameException ine) {
                        String msg = "The new superior DN (" + StringTools.dumpBytes(tlv.getValue().getData()) + ") is invalid";
                        log.error("{} : {}", (Object)msg, (Object)ine.getMessage());
                        throw new DecoderException(msg, (Throwable)ine);
                    }
                    catch (NamingException ne) {
                        String msg = "The new superior DN (" + StringTools.dumpBytes(tlv.getValue().getData()) + ") is invalid";
                        log.error("{} : {}", (Object)msg, (Object)ne.getMessage());
                        throw new DecoderException(msg, (Throwable)ne);
                    }
                    modifyDNRequest.setNewSuperior(newSuperior);
                }
                ldapMessageContainer.grammarEndAllowed(true);
                ldapMessageContainer.grammarPopAllowed(true);
                if (log.isDebugEnabled()) {
                    log.debug("New superior DN {}", (Object)newSuperior);
                }
            }
        });
    }

    public static IGrammar getInstance() {
        return instance;
    }
}

