/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.message.extended;

import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.message.ExtendedResponseImpl;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;

public class GracefulShutdownResponse
extends ExtendedResponseImpl {
    private static final long serialVersionUID = -3824715470944544189L;
    public static final String EXTENSION_OID = "1.3.6.1.4.1.18060.0.1.4";
    private static final byte[] EMPTY_RESPONSE = new byte[0];

    public GracefulShutdownResponse(int messageId, ResultCodeEnum rcode) {
        super(messageId, EXTENSION_OID);
        switch (rcode) {
            case SUCCESS: {
                break;
            }
            case OPERATIONS_ERROR: {
                break;
            }
            case INSUFFICIENT_ACCESS_RIGHTS: {
                break;
            }
            default: {
                throw new IllegalArgumentException(I18n.err((String)"ERR_04166", (Object[])new Object[]{ResultCodeEnum.SUCCESS, ResultCodeEnum.OPERATIONS_ERROR, ResultCodeEnum.INSUFFICIENT_ACCESS_RIGHTS}));
            }
        }
        super.getLdapResult().setMatchedDn(null);
        super.getLdapResult().setResultCode(rcode);
    }

    public GracefulShutdownResponse(int messageId) {
        super(messageId, EXTENSION_OID);
        super.getLdapResult().setMatchedDn(null);
        super.getLdapResult().setResultCode(ResultCodeEnum.SUCCESS);
    }

    public byte[] getResponse() {
        return EMPTY_RESPONSE;
    }

    public void setResponse(byte[] value) {
    }

    public String getResponseName() {
        return EXTENSION_OID;
    }

    public void setResponseName(String oid) {
        throw new UnsupportedOperationException(I18n.err((String)"ERR_04168", (Object[])new Object[]{EXTENSION_OID}));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        return obj instanceof GracefulShutdownResponse;
    }
}

