/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.directory.shared.asn1.AbstractAsn1Object;
import org.apache.directory.shared.asn1.Asn1Object;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.ldap.codec.ControlCodec;
import org.apache.directory.shared.ldap.codec.LdapResponseCodec;
import org.apache.directory.shared.ldap.codec.abandon.AbandonRequestCodec;
import org.apache.directory.shared.ldap.codec.add.AddRequestCodec;
import org.apache.directory.shared.ldap.codec.add.AddResponseCodec;
import org.apache.directory.shared.ldap.codec.bind.BindRequestCodec;
import org.apache.directory.shared.ldap.codec.bind.BindResponseCodec;
import org.apache.directory.shared.ldap.codec.compare.CompareRequestCodec;
import org.apache.directory.shared.ldap.codec.compare.CompareResponseCodec;
import org.apache.directory.shared.ldap.codec.del.DelRequestCodec;
import org.apache.directory.shared.ldap.codec.del.DelResponseCodec;
import org.apache.directory.shared.ldap.codec.extended.ExtendedRequestCodec;
import org.apache.directory.shared.ldap.codec.extended.ExtendedResponseCodec;
import org.apache.directory.shared.ldap.codec.intermediate.IntermediateResponseCodec;
import org.apache.directory.shared.ldap.codec.modify.ModifyRequestCodec;
import org.apache.directory.shared.ldap.codec.modify.ModifyResponseCodec;
import org.apache.directory.shared.ldap.codec.modifyDn.ModifyDNRequestCodec;
import org.apache.directory.shared.ldap.codec.modifyDn.ModifyDNResponseCodec;
import org.apache.directory.shared.ldap.codec.search.SearchRequestCodec;
import org.apache.directory.shared.ldap.codec.search.SearchResultDoneCodec;
import org.apache.directory.shared.ldap.codec.search.SearchResultEntryCodec;
import org.apache.directory.shared.ldap.codec.search.SearchResultReferenceCodec;
import org.apache.directory.shared.ldap.codec.unbind.UnBindRequestCodec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdapMessageCodec
extends AbstractAsn1Object {
    private int messageId;
    private Asn1Object protocolOp;
    private List<ControlCodec> controls;
    private ControlCodec currentControl;
    private int ldapMessageLength;
    private int controlsLength;
    private int controlsSequenceLength;

    public ControlCodec getControls(int i) {
        if (this.controls != null) {
            return this.controls.get(i);
        }
        return null;
    }

    public List<ControlCodec> getControls() {
        return this.controls;
    }

    public ControlCodec getCurrentControl() {
        return this.currentControl;
    }

    public void addControl(ControlCodec control) {
        this.currentControl = control;
        if (this.controls == null) {
            this.controls = new ArrayList<ControlCodec>();
        }
        this.controls.add(control);
    }

    public void addControls(List<ControlCodec> controls) {
        if (this.controls == null) {
            this.controls = controls;
        } else if (controls != null) {
            this.controls.addAll(controls);
        }
    }

    public void initControls() {
        this.controls = new ArrayList<ControlCodec>();
    }

    public int getMessageId() {
        return this.messageId;
    }

    public void setMessageId(int messageId) {
        this.messageId = messageId;
    }

    public int getMessageType() {
        return ((LdapMessageCodec)this.protocolOp).getMessageType();
    }

    public String getMessageTypeName() {
        switch (((LdapMessageCodec)this.protocolOp).getMessageType()) {
            case 0: {
                return "ABANDON_REQUEST";
            }
            case 1: {
                return "ADD_REQUEST";
            }
            case 2: {
                return "ADD_RESPONSE";
            }
            case 3: {
                return "BIND_REQUEST";
            }
            case 4: {
                return "BIND_RESPONSE";
            }
            case 5: {
                return "COMPARE_REQUEST";
            }
            case 6: {
                return "COMPARE_RESPONSE";
            }
            case 7: {
                return "DEL_REQUEST";
            }
            case 8: {
                return "DEL_RESPONSE";
            }
            case 9: {
                return "EXTENDED_REQUEST";
            }
            case 10: {
                return "EXTENDED_RESPONSE";
            }
            case 20: {
                return "INTERMEDIATE_RESPONSE";
            }
            case 11: {
                return "MODIFYDN_REQUEST";
            }
            case 12: {
                return "MODIFYDN_RESPONSE";
            }
            case 13: {
                return "MODIFY_REQUEST";
            }
            case 14: {
                return "MODIFY_RESPONSE";
            }
            case 15: {
                return "SEARCH_REQUEST";
            }
            case 16: {
                return "SEARCH_RESULT_DONE";
            }
            case 17: {
                return "SEARCH_RESULT_ENTRY";
            }
            case 18: {
                return "SEARCH_RESULT_REFERENCE";
            }
            case 19: {
                return "UNBIND_REQUEST";
            }
        }
        return "UNKNOWN";
    }

    public LdapResponseCodec getLdapResponse() {
        return (LdapResponseCodec)this.protocolOp;
    }

    public AbandonRequestCodec getAbandonRequest() {
        return (AbandonRequestCodec)this.protocolOp;
    }

    public AddRequestCodec getAddRequest() {
        return (AddRequestCodec)this.protocolOp;
    }

    public AddResponseCodec getAddResponse() {
        return (AddResponseCodec)this.protocolOp;
    }

    public BindRequestCodec getBindRequest() {
        return (BindRequestCodec)this.protocolOp;
    }

    public BindResponseCodec getBindResponse() {
        return (BindResponseCodec)this.protocolOp;
    }

    public CompareRequestCodec getCompareRequest() {
        return (CompareRequestCodec)this.protocolOp;
    }

    public CompareResponseCodec getCompareResponse() {
        return (CompareResponseCodec)this.protocolOp;
    }

    public DelRequestCodec getDelRequest() {
        return (DelRequestCodec)this.protocolOp;
    }

    public DelResponseCodec getDelResponse() {
        return (DelResponseCodec)this.protocolOp;
    }

    public ExtendedRequestCodec getExtendedRequest() {
        return (ExtendedRequestCodec)this.protocolOp;
    }

    public ExtendedResponseCodec getExtendedResponse() {
        return (ExtendedResponseCodec)this.protocolOp;
    }

    public IntermediateResponseCodec getIntermediateResponse() {
        return (IntermediateResponseCodec)this.protocolOp;
    }

    public ModifyDNRequestCodec getModifyDNRequest() {
        return (ModifyDNRequestCodec)this.protocolOp;
    }

    public ModifyDNResponseCodec getModifyDNResponse() {
        return (ModifyDNResponseCodec)this.protocolOp;
    }

    public ModifyRequestCodec getModifyRequest() {
        return (ModifyRequestCodec)this.protocolOp;
    }

    public ModifyResponseCodec getModifyResponse() {
        return (ModifyResponseCodec)this.protocolOp;
    }

    public SearchRequestCodec getSearchRequest() {
        return (SearchRequestCodec)this.protocolOp;
    }

    public SearchResultDoneCodec getSearchResultDone() {
        return (SearchResultDoneCodec)this.protocolOp;
    }

    public SearchResultEntryCodec getSearchResultEntry() {
        return (SearchResultEntryCodec)this.protocolOp;
    }

    public SearchResultReferenceCodec getSearchResultReference() {
        return (SearchResultReferenceCodec)this.protocolOp;
    }

    public UnBindRequestCodec getUnBindRequest() {
        return (UnBindRequestCodec)this.protocolOp;
    }

    public void setProtocolOP(Asn1Object protocolOp) {
        this.protocolOp = protocolOp;
    }

    public int computeLength() {
        this.ldapMessageLength = 2 + Value.getNbBytes((int)this.messageId);
        int protocolOpLength = this.protocolOp.computeLength();
        this.ldapMessageLength += protocolOpLength;
        if (this.controls != null) {
            this.controlsSequenceLength = 0;
            for (ControlCodec control : this.controls) {
                this.controlsSequenceLength += control.computeLength();
            }
            this.controlsLength = this.controlsSequenceLength;
            this.ldapMessageLength += 1 + TLV.getNbBytes((int)this.controlsSequenceLength) + this.controlsSequenceLength;
        }
        return 1 + this.ldapMessageLength + TLV.getNbBytes((int)this.ldapMessageLength);
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        ByteBuffer bb = ByteBuffer.allocate(this.computeLength());
        try {
            bb.put((byte)48);
            bb.put(TLV.getBytes((int)this.ldapMessageLength));
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException("The PDU buffer size is too small !");
        }
        Value.encode((ByteBuffer)bb, (int)this.messageId);
        this.protocolOp.encode(bb);
        if (this.controls != null) {
            bb.put((byte)-96);
            bb.put(TLV.getBytes((int)this.controlsLength));
            for (ControlCodec control : this.controls) {
                control.encode(bb);
            }
        }
        return bb;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("LdapMessage\n");
        sb.append("    message Id : ").append(this.messageId).append('\n');
        sb.append(this.protocolOp);
        if (this.controls != null) {
            for (ControlCodec control : this.controls) {
                sb.append((Object)control);
            }
        }
        return sb.toString();
    }
}

