/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.name;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.naming.InvalidNameException;
import org.apache.commons.collections.map.MultiValueMap;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.entry.client.ClientStringValue;
import org.apache.directory.shared.ldap.name.AttributeTypeAndValue;
import org.apache.directory.shared.ldap.name.RdnParser;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Rdn
implements Cloneable,
Comparable,
Externalizable,
Iterable<AttributeTypeAndValue> {
    protected static final Logger LOG = LoggerFactory.getLogger(Rdn.class);
    private static final long serialVersionUID = 1L;
    private String upName = null;
    private String normName = null;
    private int start;
    private int length;
    private Set<AttributeTypeAndValue> atavs = null;
    private Map<String, AttributeTypeAndValue> atavTypes = new MultiValueMap();
    private String atavType = null;
    protected AttributeTypeAndValue atav = null;
    private int nbAtavs = 0;
    public static final int UNDEFINED = Integer.MAX_VALUE;
    public static final int SUPERIOR = 1;
    public static final int INFERIOR = -1;
    public static final int EQUAL = 0;

    public Rdn() {
        this.upName = "";
        this.normName = "";
    }

    public Rdn(String rdn) throws InvalidNameException {
        this.start = 0;
        if (StringTools.isNotEmpty(rdn)) {
            RdnParser.parse(rdn, this);
            this.normalize();
            this.upName = rdn;
            this.length = rdn.length();
        } else {
            this.upName = "";
            this.normName = "";
            this.length = 0;
        }
    }

    public Rdn(String upType, String normType, String upValue, String normValue) throws InvalidNameException {
        this.addAttributeTypeAndValue(upType, normType, new ClientStringValue(upValue), new ClientStringValue(normValue));
        this.upName = upType + '=' + upValue;
        this.start = 0;
        this.length = this.upName.length();
        this.normalize();
    }

    Rdn(int start, int length, String upName, String normName) {
        this.start = 0;
        this.length = length;
        this.upName = upName;
        this.normName = normName;
    }

    public Rdn(Rdn rdn) {
        this.nbAtavs = rdn.getNbAtavs();
        this.normName = rdn.normName;
        this.upName = rdn.getUpName();
        this.start = rdn.start;
        this.length = rdn.length;
        switch (rdn.getNbAtavs()) {
            case 0: {
                return;
            }
            case 1: {
                this.atav = (AttributeTypeAndValue)rdn.atav.clone();
                return;
            }
        }
        this.atavs = new TreeSet<AttributeTypeAndValue>();
        this.atavTypes = new MultiValueMap();
        for (AttributeTypeAndValue currentAtav : rdn.atavs) {
            this.atavs.add((AttributeTypeAndValue)currentAtav.clone());
            this.atavTypes.put(currentAtav.getNormType(), currentAtav);
        }
    }

    void normalize() {
        switch (this.nbAtavs) {
            case 0: {
                this.normName = "";
                break;
            }
            case 1: {
                if (!this.atav.getNormValue().isBinary()) {
                    this.normName = this.atav.getNormalizedValue();
                    break;
                }
                this.normName = this.atav.getNormType() + "=#" + StringTools.dumpHexPairs(this.atav.getNormValue().getBytes());
                break;
            }
            default: {
                StringBuffer sb = new StringBuffer();
                boolean isFirst = true;
                for (AttributeTypeAndValue ata : this.atavs) {
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        sb.append('+');
                    }
                    sb.append(ata.normalize());
                }
                this.normName = sb.toString();
            }
        }
    }

    void addAttributeTypeAndValue(String upType, String type, Value<?> upValue, Value<?> value) throws InvalidNameException {
        String normalizedType = StringTools.lowerCaseAscii(type);
        Value<?> normalizedValue = value;
        switch (this.nbAtavs) {
            case 0: {
                this.atav = new AttributeTypeAndValue(upType, type, upValue, normalizedValue);
                this.nbAtavs = 1;
                this.atavType = normalizedType;
                return;
            }
            case 1: {
                this.atavs = new TreeSet<AttributeTypeAndValue>();
                this.atavs.add(this.atav);
                this.atavTypes = new MultiValueMap();
                this.atavTypes.put(this.atavType, this.atav);
                this.atav = null;
            }
        }
        AttributeTypeAndValue newAtav = new AttributeTypeAndValue(upType, type, upValue, normalizedValue);
        this.atavs.add(newAtav);
        this.atavTypes.put(normalizedType, newAtav);
        ++this.nbAtavs;
    }

    void addAttributeTypeAndValue(AttributeTypeAndValue value) {
        String normalizedType = value.getNormType();
        switch (this.nbAtavs) {
            case 0: {
                this.atav = value;
                this.nbAtavs = 1;
                this.atavType = normalizedType;
                return;
            }
            case 1: {
                this.atavs = new TreeSet<AttributeTypeAndValue>();
                this.atavs.add(this.atav);
                this.atavTypes = new MultiValueMap();
                this.atavTypes.put(this.atavType, this.atav);
                this.atav = null;
            }
        }
        this.atavs.add(value);
        this.atavTypes.put(normalizedType, value);
        ++this.nbAtavs;
    }

    public void clear() {
        this.atav = null;
        this.atavs = null;
        this.atavType = null;
        this.atavTypes.clear();
        this.nbAtavs = 0;
        this.normName = "";
        this.upName = "";
        this.start = -1;
        this.length = 0;
    }

    public Object getValue(String type) throws InvalidNameException {
        String normalizedType = StringTools.lowerCaseAscii(StringTools.trim(type));
        switch (this.nbAtavs) {
            case 0: {
                return "";
            }
            case 1: {
                if (StringTools.equals(this.atav.getNormType(), normalizedType)) {
                    return this.atav.getNormValue().get();
                }
                return "";
            }
        }
        if (this.atavTypes.containsKey(normalizedType)) {
            AttributeTypeAndValue obj = this.atavTypes.get(normalizedType);
            if (obj instanceof AttributeTypeAndValue) {
                return obj.getNormValue();
            }
            if (obj instanceof List) {
                StringBuffer sb = new StringBuffer();
                boolean isFirst = true;
                List atavList = (List)((Object)obj);
                for (AttributeTypeAndValue elem : atavList) {
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        sb.append(',');
                    }
                    sb.append(elem.getNormValue());
                }
                return sb.toString();
            }
            throw new InvalidNameException("Bad object stored in the RDN");
        }
        return "";
    }

    public int getStart() {
        return this.start;
    }

    public int getLength() {
        return this.length;
    }

    public AttributeTypeAndValue getAttributeTypeAndValue(String type) {
        String normalizedType = StringTools.lowerCaseAscii(StringTools.trim(type));
        switch (this.nbAtavs) {
            case 0: {
                return null;
            }
            case 1: {
                if (this.atav.getNormType().equals(normalizedType)) {
                    return this.atav;
                }
                return null;
            }
        }
        if (this.atavTypes.containsKey(normalizedType)) {
            return this.atavTypes.get(normalizedType);
        }
        return null;
    }

    @Override
    public Iterator<AttributeTypeAndValue> iterator() {
        if (this.nbAtavs == 1 || this.nbAtavs == 0) {
            return new Iterator<AttributeTypeAndValue>(){
                private boolean hasMoreElement;
                {
                    this.hasMoreElement = Rdn.this.nbAtavs == 1;
                }

                @Override
                public boolean hasNext() {
                    return this.hasMoreElement;
                }

                @Override
                public AttributeTypeAndValue next() {
                    AttributeTypeAndValue obj = Rdn.this.atav;
                    this.hasMoreElement = false;
                    return obj;
                }

                @Override
                public void remove() {
                }
            };
        }
        return this.atavs.iterator();
    }

    public Object clone() {
        try {
            Rdn rdn = (Rdn)super.clone();
            switch (rdn.getNbAtavs()) {
                case 0: {
                    break;
                }
                case 1: {
                    rdn.atav = (AttributeTypeAndValue)this.atav.clone();
                    rdn.atavTypes = this.atavTypes;
                    break;
                }
                default: {
                    rdn.atavTypes = new MultiValueMap();
                    rdn.atavs = new TreeSet<AttributeTypeAndValue>();
                    for (AttributeTypeAndValue currentAtav : this.atavs) {
                        rdn.atavs.add((AttributeTypeAndValue)currentAtav.clone());
                        rdn.atavTypes.put(currentAtav.getNormType(), currentAtav);
                    }
                }
            }
            return rdn;
        }
        catch (CloneNotSupportedException cnse) {
            throw new Error("Assertion failure");
        }
    }

    public int compareTo(Object object) {
        if (object == null) {
            return 1;
        }
        if (object instanceof Rdn) {
            Rdn rdn = (Rdn)object;
            if (rdn.nbAtavs != this.nbAtavs) {
                return this.nbAtavs - rdn.nbAtavs;
            }
            switch (this.nbAtavs) {
                case 0: {
                    return 0;
                }
                case 1: {
                    return this.atav.compareTo(rdn.atav);
                }
            }
            Iterator<AttributeTypeAndValue> localIterator = this.atavs.iterator();
            Iterator<AttributeTypeAndValue> paramIterator = rdn.atavs.iterator();
            while (localIterator.hasNext() || paramIterator.hasNext()) {
                AttributeTypeAndValue paramAtav;
                if (!localIterator.hasNext()) {
                    return 1;
                }
                if (!paramIterator.hasNext()) {
                    return -1;
                }
                AttributeTypeAndValue localAtav = localIterator.next();
                int result = localAtav.compareTo(paramAtav = paramIterator.next());
                if (result == 0) continue;
                return result;
            }
            return 0;
        }
        return Integer.MAX_VALUE;
    }

    public String toString() {
        return this.normName == null ? "" : this.normName;
    }

    public String getUpName() {
        return this.upName;
    }

    public String getNormName() {
        return this.normName == null ? "" : this.normName;
    }

    public void setUpName(String upName) {
        this.upName = upName;
    }

    public int getNbAtavs() {
        return this.nbAtavs;
    }

    public AttributeTypeAndValue getAtav() {
        switch (this.nbAtavs) {
            case 0: {
                return null;
            }
            case 1: {
                return this.atav;
            }
        }
        return (AttributeTypeAndValue)((TreeSet)this.atavs).first();
    }

    public String getUpType() {
        switch (this.nbAtavs) {
            case 0: {
                return null;
            }
            case 1: {
                return this.atav.getUpType();
            }
        }
        return ((AttributeTypeAndValue)((TreeSet)this.atavs).first()).getUpType();
    }

    public String getNormType() {
        switch (this.nbAtavs) {
            case 0: {
                return null;
            }
            case 1: {
                return this.atav.getNormType();
            }
        }
        return ((AttributeTypeAndValue)((TreeSet)this.atavs).first()).getNormType();
    }

    public Object getValue() {
        switch (this.nbAtavs) {
            case 0: {
                return null;
            }
            case 1: {
                return this.atav.getNormValue().get();
            }
        }
        return ((AttributeTypeAndValue)((TreeSet)this.atavs).first()).getNormValue().get();
    }

    public String getUpValue() {
        switch (this.nbAtavs) {
            case 0: {
                return null;
            }
            case 1: {
                return this.atav.getUpValue().getString();
            }
        }
        return ((AttributeTypeAndValue)((TreeSet)this.atavs).first()).getUpValue().getString();
    }

    public String getNormValue() {
        switch (this.nbAtavs) {
            case 0: {
                return null;
            }
            case 1: {
                return this.atav.getNormValue().getString();
            }
        }
        return ((AttributeTypeAndValue)((TreeSet)this.atavs).first()).getNormalizedValue();
    }

    public boolean equals(Object rdn) {
        if (this == rdn) {
            return true;
        }
        if (!(rdn instanceof Rdn)) {
            return false;
        }
        return this.compareTo(rdn) == 0;
    }

    public int size() {
        return this.nbAtavs;
    }

    public static Object unescapeValue(String value) {
        if (StringTools.isEmpty(value)) {
            return "";
        }
        char[] chars = value.toCharArray();
        if (chars[0] == '#') {
            if (chars.length == 1) {
                return StringTools.EMPTY_BYTES;
            }
            if (chars.length % 2 != 1) {
                throw new IllegalArgumentException("This value is not in hex form, we have an odd number of hex chars");
            }
            byte[] hexValue = new byte[(chars.length - 1) / 2];
            int pos = 0;
            for (int i = 1; i < chars.length; i += 2) {
                if (!StringTools.isHex(chars, i) || !StringTools.isHex(chars, i + 1)) {
                    throw new IllegalArgumentException("This value is not in hex form");
                }
                hexValue[pos++] = StringTools.getHexValue(chars[i], chars[i + 1]);
            }
            return hexValue;
        }
        boolean escaped = false;
        boolean isHex = false;
        int pair = -1;
        int pos = 0;
        byte[] bytes = new byte[chars.length * 6];
        block10: for (int i = 0; i < chars.length; ++i) {
            if (escaped) {
                escaped = false;
                switch (chars[i]) {
                    case ' ': 
                    case '\"': 
                    case '#': 
                    case '+': 
                    case ',': 
                    case ';': 
                    case '<': 
                    case '=': 
                    case '>': 
                    case '\\': {
                        bytes[pos++] = (byte)chars[i];
                        break;
                    }
                    default: {
                        if (!StringTools.isHex(chars, i)) continue block10;
                        isHex = true;
                        pair = (byte)(StringTools.getHexValue(chars[i]) << 4);
                        break;
                    }
                }
                continue;
            }
            if (isHex) {
                if (!StringTools.isHex(chars, i)) continue;
                pair = (byte)(pair + StringTools.getHexValue(chars[i]));
                bytes[pos++] = pair;
                continue;
            }
            switch (chars[i]) {
                case '\\': {
                    escaped = true;
                    continue block10;
                }
                case '\"': 
                case '#': 
                case '+': 
                case ',': 
                case ';': 
                case '<': 
                case '>': {
                    if (i != 0) {
                        bytes[pos++] = 35;
                        continue block10;
                    }
                }
                case '=': {
                    throw new IllegalArgumentException("Unescaped special characters are not allowed");
                }
                case ' ': {
                    if (i == 0 || i == chars.length - 1) {
                        throw new IllegalArgumentException("Unescaped special characters are not allowed");
                    }
                    bytes[pos++] = 32;
                    continue block10;
                }
                default: {
                    if (chars[i] >= '\u0000' && chars[i] < '\u0080') {
                        bytes[pos++] = (byte)chars[i];
                        continue block10;
                    }
                    byte[] result = StringTools.charToBytes(chars[i]);
                    System.arraycopy(result, 0, bytes, pos, result.length);
                    pos += result.length;
                }
            }
        }
        return StringTools.utf8ToString(bytes, pos);
    }

    public static String escapeValue(String value) {
        if (StringTools.isEmpty(value)) {
            return "";
        }
        char[] chars = value.toCharArray();
        char[] newChars = new char[chars.length * 3];
        int pos = 0;
        block8: for (int i = 0; i < chars.length; ++i) {
            switch (chars[i]) {
                case ' ': {
                    if (i > 0 && i < chars.length - 1) {
                        newChars[pos++] = chars[i];
                        continue block8;
                    }
                    newChars[pos++] = 92;
                    newChars[pos++] = chars[i];
                    continue block8;
                }
                case '#': {
                    if (i != 0) {
                        newChars[pos++] = chars[i];
                        continue block8;
                    }
                    newChars[pos++] = 92;
                    newChars[pos++] = chars[i];
                    continue block8;
                }
                case '\"': 
                case '+': 
                case ',': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '\\': {
                    newChars[pos++] = 92;
                    newChars[pos++] = chars[i];
                    continue block8;
                }
                case '\u007f': {
                    newChars[pos++] = 92;
                    newChars[pos++] = 55;
                    newChars[pos++] = 70;
                    continue block8;
                }
                case '\u0000': 
                case '\u0001': 
                case '\u0002': 
                case '\u0003': 
                case '\u0004': 
                case '\u0005': 
                case '\u0006': 
                case '\u0007': 
                case '\b': 
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case '\u000e': 
                case '\u000f': {
                    newChars[pos++] = 92;
                    newChars[pos++] = 48;
                    newChars[pos++] = StringTools.dumpHex((byte)(chars[i] & 0xF));
                    continue block8;
                }
                case '\u0010': 
                case '\u0011': 
                case '\u0012': 
                case '\u0013': 
                case '\u0014': 
                case '\u0015': 
                case '\u0016': 
                case '\u0017': 
                case '\u0018': 
                case '\u0019': 
                case '\u001a': 
                case '\u001b': 
                case '\u001c': 
                case '\u001d': 
                case '\u001e': 
                case '\u001f': {
                    newChars[pos++] = 92;
                    newChars[pos++] = 49;
                    newChars[pos++] = StringTools.dumpHex((byte)(chars[i] & 0xF));
                    continue block8;
                }
                default: {
                    newChars[pos++] = chars[i];
                }
            }
        }
        return new String(newChars, 0, pos);
    }

    public static String escapeValue(byte[] attrValue) {
        if (StringTools.isEmpty(attrValue)) {
            return "";
        }
        String value = StringTools.utf8ToString(attrValue);
        return Rdn.escapeValue(value);
    }

    public int hashCode() {
        int result = 37;
        switch (this.nbAtavs) {
            case 0: {
                break;
            }
            case 1: {
                result = result * 17 + this.atav.hashCode();
                break;
            }
            default: {
                for (AttributeTypeAndValue ata : this.atavs) {
                    result = result * 17 + ata.hashCode();
                }
            }
        }
        return result;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.nbAtavs);
        out.writeUTF(this.upName);
        if (this.upName.equals(this.normName)) {
            out.writeUTF("");
        } else {
            out.writeUTF(this.normName);
        }
        out.writeInt(this.start);
        out.writeInt(this.length);
        switch (this.nbAtavs) {
            case 0: {
                break;
            }
            case 1: {
                out.writeObject(this.atav);
                break;
            }
            default: {
                for (AttributeTypeAndValue value : this.atavs) {
                    out.writeObject(value);
                }
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.nbAtavs = in.readInt();
        this.upName = in.readUTF();
        this.normName = in.readUTF();
        if (StringTools.isEmpty(this.normName)) {
            this.normName = this.upName;
        }
        this.start = in.readInt();
        this.length = in.readInt();
        switch (this.nbAtavs) {
            case 0: {
                this.atav = null;
                break;
            }
            case 1: {
                this.atav = (AttributeTypeAndValue)in.readObject();
                this.atavType = this.atav.getNormType();
                break;
            }
            default: {
                this.atavs = new TreeSet<AttributeTypeAndValue>();
                this.atavTypes = new MultiValueMap();
                for (int i = 0; i < this.nbAtavs; ++i) {
                    AttributeTypeAndValue value = (AttributeTypeAndValue)in.readObject();
                    this.atavs.add(value);
                    this.atavTypes.put(value.getNormType(), value);
                }
                this.atav = null;
                this.atavType = null;
            }
        }
    }
}

