/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.message.control.replication;

import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.ldap.codec.controls.replication.syncRequestValue.SyncRequestValueControlCodec;
import org.apache.directory.shared.ldap.message.control.AbstractMutableControlImpl;
import org.apache.directory.shared.ldap.message.control.replication.SynchronizationModeEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncRequestValueControl
extends AbstractMutableControlImpl {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(SyncRequestValueControl.class);
    public static final String CONTROL_OID = "1.3.6.1.4.1.4203.1.9.1.1";
    private SynchronizationModeEnum mode;
    private byte[] cookie;
    private boolean reloadHint;

    public SynchronizationModeEnum getMode() {
        return this.mode;
    }

    public void setMode(SynchronizationModeEnum mode) {
        this.mode = mode;
    }

    public byte[] getCookie() {
        return this.cookie;
    }

    public void setCookie(byte[] cookie) {
        this.cookie = cookie;
    }

    public boolean isReloadHint() {
        return this.reloadHint;
    }

    public void setReloadHint(boolean reloadHint) {
        this.reloadHint = reloadHint;
    }

    public String getID() {
        return CONTROL_OID;
    }

    public byte[] getEncodedValue() {
        SyncRequestValueControlCodec syncRequestValueCtlCodec = new SyncRequestValueControlCodec();
        syncRequestValueCtlCodec.setMode(this.mode);
        syncRequestValueCtlCodec.setCookie(this.cookie);
        syncRequestValueCtlCodec.setReloadHint(this.reloadHint);
        try {
            return syncRequestValueCtlCodec.encode(null).array();
        }
        catch (EncoderException e) {
            LOG.error("Failed to encode syncRequestValue control", (Throwable)e);
            throw new IllegalStateException("Failed to encode control with encoder.", e);
        }
    }
}

