/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.schema.syntax;

import org.apache.directory.shared.ldap.schema.syntax.AbstractSyntaxChecker;
import org.apache.directory.shared.ldap.util.StringTools;

public class ObjectClassTypeSyntaxChecker
extends AbstractSyntaxChecker {
    private static final String SC_OID = "1.3.6.1.4.1.18060.0.4.0.0.1";

    public ObjectClassTypeSyntaxChecker() {
        super(SC_OID);
    }

    protected ObjectClassTypeSyntaxChecker(String oid) {
        super(oid);
    }

    public boolean isValidSyntax(Object value) {
        String strValue = null;
        if (value == null) {
            return false;
        }
        strValue = value instanceof String ? (String)value : (value instanceof byte[] ? StringTools.utf8ToString((byte[])value) : value.toString());
        if (strValue.length() < 8 || strValue.length() > 10) {
            return false;
        }
        char ch = strValue.charAt(0);
        switch (ch) {
            case 'A': {
                return "AUXILIARY".equals(strValue) || "ABSTRACT".equals(strValue);
            }
            case 'S': {
                return "STRUCTURAL".equals(strValue);
            }
        }
        return false;
    }
}

