/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.entry.client;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.naming.NamingException;
import org.apache.directory.shared.ldap.NotImplementedException;
import org.apache.directory.shared.ldap.entry.AbstractValue;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.schema.Normalizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientStringValue
extends AbstractValue<String> {
    public static final long serialVersionUID = 2L;
    private static final Logger LOG = LoggerFactory.getLogger(ClientStringValue.class);

    public ClientStringValue() {
        this.normalized = false;
        this.valid = null;
    }

    public ClientStringValue(String wrapped) {
        this.wrapped = wrapped;
        this.normalized = false;
        this.valid = null;
    }

    @Override
    public String get() {
        return (String)this.wrapped;
    }

    @Override
    public String getCopy() {
        return (String)this.wrapped;
    }

    @Override
    public final void set(String wrapped) {
        if (wrapped != null && wrapped.equals(this.get())) {
            return;
        }
        this.normalizedValue = null;
        this.normalized = false;
        this.valid = null;
        this.wrapped = wrapped;
    }

    @Override
    public String getNormalizedValue() {
        if (this.isNull()) {
            return null;
        }
        if (this.normalizedValue == null) {
            return (String)this.wrapped;
        }
        return (String)this.normalizedValue;
    }

    @Override
    public String getNormalizedValueCopy() {
        return this.getNormalizedValue();
    }

    @Override
    public final void normalize(Normalizer normalizer) throws NamingException {
        if (normalizer != null) {
            this.normalizedValue = (String)normalizer.normalize(this.wrapped);
            this.normalized = true;
        }
    }

    @Override
    public int compareTo(Value<String> value) {
        if (this.isNull()) {
            if (value == null || value.isNull()) {
                return 0;
            }
            return -1;
        }
        if (value == null || value.isNull()) {
            return 1;
        }
        if (value instanceof ClientStringValue) {
            ClientStringValue stringValue = (ClientStringValue)value;
            return this.getNormalizedValue().compareTo(stringValue.getNormalizedValue());
        }
        String message = "Cannot compare " + this.toString() + " with the unknown value " + value.getClass();
        LOG.error(message);
        throw new NotImplementedException(message);
    }

    @Override
    public ClientStringValue clone() {
        return (ClientStringValue)super.clone();
    }

    public int hashCode() {
        if (this.isNull()) {
            return 0;
        }
        return this.getNormalizedValue().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ClientStringValue)) {
            return false;
        }
        ClientStringValue other = (ClientStringValue)obj;
        if (this.isNull()) {
            return other.isNull();
        }
        return this.getNormalizedValue().equals(other.getNormalizedValue());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
    }

    public String toString() {
        return "'" + (String)this.wrapped + "'";
    }
}

