/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mitosis.store.derby;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import javax.naming.Name;
import javax.naming.ldap.LdapName;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.directory.mitosis.common.CSN;
import org.apache.directory.mitosis.common.CSNVector;
import org.apache.directory.mitosis.common.DefaultCSN;
import org.apache.directory.mitosis.configuration.ReplicationConfiguration;
import org.apache.directory.mitosis.operation.Operation;
import org.apache.directory.mitosis.operation.OperationCodec;
import org.apache.directory.mitosis.store.ReplicationLogIterator;
import org.apache.directory.mitosis.store.ReplicationStore;
import org.apache.directory.mitosis.store.ReplicationStoreException;
import org.apache.directory.mitosis.store.derby.DerbyReplicationLogIterator;
import org.apache.directory.mitosis.store.derby.SQLUtil;
import org.apache.directory.server.core.DirectoryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DerbyReplicationStore
implements ReplicationStore {
    private static final Logger LOG = LoggerFactory.getLogger(DerbyReplicationStore.class);
    private static final String DEFAULT_TABLE_PREFIX = "REPLICATION_";
    private static final String KEY_REPLICA_ID = "replicaId";
    private static final String DRIVER_NAME = "org.apache.derby.jdbc.EmbeddedDriver";
    private static final String DB_URI_PREFIX = "jdbc:derby:";
    private String dbURI;
    private BasicDataSource dataSource;
    private String replicaId;
    private String tablePrefix = "REPLICATION_";
    private String metadataTableName;
    private String uuidTableName;
    private String logTableName;
    private Set<String> knownReplicaIds;
    private final Object knownReplicaIdsLock = new Object();
    private final OperationCodec operationCodec = new OperationCodec();

    public String getTablePrefix() {
        return this.tablePrefix;
    }

    public void setTablePrefix(String tablePrefix) {
        if (tablePrefix == null) {
            tablePrefix = DEFAULT_TABLE_PREFIX;
        }
        if ((tablePrefix = tablePrefix.trim()).length() == 0) {
            tablePrefix = DEFAULT_TABLE_PREFIX;
        }
        this.tablePrefix = tablePrefix;
    }

    @Override
    public void open(DirectoryService serviceCfg, ReplicationConfiguration cfg) {
        this.replicaId = cfg.getReplicaId();
        this.dbURI = DB_URI_PREFIX + serviceCfg.getWorkingDirectory().getPath() + File.separator + "replication";
        try {
            Class.forName(DRIVER_NAME);
            Connection con = DriverManager.getConnection(this.dbURI + ";create=true");
            con.close();
        }
        catch (Exception e) {
            throw new ReplicationStoreException("Failed to initialize Derby database.", e);
        }
        BasicDataSource dataSource = new BasicDataSource();
        dataSource.setDriverClassName(DRIVER_NAME);
        dataSource.setUrl(this.dbURI);
        dataSource.setUsername("sa");
        dataSource.setPassword("");
        this.dataSource = dataSource;
        this.metadataTableName = this.tablePrefix + "METADATA";
        this.uuidTableName = this.tablePrefix + "UUID";
        this.logTableName = this.tablePrefix + "LOG";
        this.initSchema();
        this.loadMetadata();
    }

    private void initSchema() {
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            con = this.dataSource.getConnection();
            con.setAutoCommit(true);
            stmt = con.createStatement();
            try {
                rs = stmt.executeQuery("SELECT M_KEY FROM " + this.metadataTableName + " WHERE M_KEY IS NULL");
                rs.close();
                rs = null;
            }
            catch (SQLException e) {
                stmt.executeUpdate("CREATE TABLE " + this.metadataTableName + " (" + "    M_KEY VARCHAR(30) NOT NULL PRIMARY KEY," + "    M_VALUE VARCHAR(100) NOT NULL )");
            }
            try {
                rs = stmt.executeQuery("SELECT UUID FROM " + this.uuidTableName + " WHERE UUID IS NULL");
                rs.close();
                rs = null;
            }
            catch (SQLException e) {
                stmt.executeUpdate("CREATE TABLE " + this.uuidTableName + " (" + "    UUID CHAR(36) NOT NULL PRIMARY KEY," + "    DN CLOB NOT NULL" + ")");
            }
            try {
                rs = stmt.executeQuery("SELECT CSN_REPLICA_ID FROM " + this.logTableName + " WHERE CSN_REPLICA_ID IS NULL");
                rs.close();
                rs = null;
            }
            catch (SQLException e) {
                stmt.executeUpdate("CREATE TABLE " + this.logTableName + " (" + "    CSN_REPLICA_ID VARCHAR(16) NOT NULL," + "    CSN_TIMESTAMP BIGINT NOT NULL," + "    CSN_OP_SEQ INTEGER NOT NULL," + "    OPERATION BLOB NOT NULL," + "CONSTRAINT " + this.logTableName + "_PK PRIMARY KEY (" + "    CSN_REPLICA_ID," + "    CSN_TIMESTAMP," + "    CSN_OP_SEQ)" + ")");
            }
        }
        catch (SQLException e) {
            try {
                throw new ReplicationStoreException("Failed to initialize DB schema.", e);
            }
            catch (Throwable throwable) {
                SQLUtil.cleanup(con, stmt, rs);
                throw throwable;
            }
        }
        SQLUtil.cleanup(con, stmt, rs);
    }

    private void loadMetadata() {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = this.dataSource.getConnection();
            con.setAutoCommit(true);
            con.setTransactionIsolation(4);
            con.setReadOnly(true);
            ps = con.prepareStatement("SELECT M_VALUE FROM " + this.metadataTableName + " WHERE M_KEY=?");
            ps.setString(1, KEY_REPLICA_ID);
            rs = ps.executeQuery();
            if (rs.next()) {
                String actualReplicaId = rs.getString(1);
                if (!this.replicaId.equalsIgnoreCase(actualReplicaId)) {
                    throw new ReplicationStoreException("Replica ID mismatches: " + actualReplicaId + " (expected: " + this.replicaId + ")");
                }
            } else {
                rs.close();
                rs = null;
                ps.close();
                ps = null;
                con.setReadOnly(false);
                ps = con.prepareStatement("INSERT INTO " + this.metadataTableName + " (M_KEY, M_VALUE) VALUES (?,?)");
                ps.setString(1, KEY_REPLICA_ID);
                ps.setString(2, this.replicaId);
                ps.executeUpdate();
            }
            if (rs != null) {
                rs.close();
                rs = null;
            }
            ps.close();
            ps = null;
            ps = con.prepareStatement("SELECT DISTINCT CSN_REPLICA_ID FROM " + this.logTableName);
            rs = ps.executeQuery();
            this.knownReplicaIds = new HashSet<String>();
            while (rs.next()) {
                this.knownReplicaIds.add(rs.getString(1));
            }
        }
        catch (Exception e) {
            try {
                if (e instanceof ReplicationStoreException) {
                    throw (ReplicationStoreException)e;
                }
                throw new ReplicationStoreException(e);
            }
            catch (Throwable throwable) {
                SQLUtil.cleanup(con, ps, rs);
                throw throwable;
            }
        }
        SQLUtil.cleanup(con, ps, rs);
    }

    @Override
    public void close() {
        try {
            this.dataSource.close();
        }
        catch (SQLException e) {
            LOG.warn("Failed to close the dataSource.", (Throwable)e);
        }
        this.dataSource = null;
        this.replicaId = null;
        try {
            DriverManager.getConnection(this.dbURI + ";shutdown=true");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public String getReplicaId() {
        return this.replicaId;
    }

    @Override
    public Set<String> getKnownReplicaIds() {
        return new HashSet<String>(this.knownReplicaIds);
    }

    @Override
    public Name getDN(UUID uuid) {
        Name name;
        ResultSet rs;
        PreparedStatement ps;
        Connection con;
        block5: {
            con = null;
            ps = null;
            rs = null;
            con = this.dataSource.getConnection();
            con.setTransactionIsolation(2);
            con.setReadOnly(true);
            ps = con.prepareStatement("SELECT DN FROM " + this.uuidTableName + " WHERE UUID=?");
            ps.setString(1, uuid.toString());
            rs = ps.executeQuery();
            if (!rs.next()) break block5;
            LdapName ldapName = new LdapName(rs.getString(1));
            SQLUtil.cleanup(con, ps, rs);
            return ldapName;
        }
        try {
            name = null;
        }
        catch (Exception e) {
            try {
                throw new ReplicationStoreException(e);
            }
            catch (Throwable throwable) {
                SQLUtil.cleanup(con, ps, rs);
                throw throwable;
            }
        }
        SQLUtil.cleanup(con, ps, rs);
        return name;
    }

    @Override
    public boolean putUUID(UUID uuid, Name dn) {
        boolean bl;
        ResultSet rs;
        PreparedStatement ps;
        Connection con;
        String uuidString;
        block7: {
            uuidString = uuid.toString();
            con = null;
            ps = null;
            rs = null;
            con = this.dataSource.getConnection();
            con.setAutoCommit(false);
            con.setTransactionIsolation(4);
            con.setReadOnly(true);
            ps = con.prepareStatement("SELECT UUID FROM " + this.uuidTableName + " WHERE UUID=?");
            ps.setString(1, uuidString);
            rs = ps.executeQuery();
            if (!rs.next()) break block7;
            boolean bl2 = false;
            SQLUtil.cleanup(con, ps, rs);
            return bl2;
        }
        try {
            rs.close();
            rs = null;
            con.setReadOnly(false);
            ps = con.prepareStatement("INSERT INTO " + this.uuidTableName + " (UUID, DN) VALUES(?,?)");
            ps.setString(1, uuidString);
            ps.setString(2, dn.toString());
            int updateCnt = ps.executeUpdate();
            con.commit();
            bl = updateCnt == 1;
        }
        catch (Exception e) {
            try {
                try {
                    con.rollback();
                }
                catch (SQLException e1) {
                    LOG.error("Failed to rollback transaction.", (Throwable)e);
                }
                throw new ReplicationStoreException(e);
            }
            catch (Throwable throwable) {
                SQLUtil.cleanup(con, ps, rs);
                throw throwable;
            }
        }
        SQLUtil.cleanup(con, ps, rs);
        return bl;
    }

    @Override
    public boolean removeUUID(UUID uuid) {
        boolean bl;
        String uuidString = uuid.toString();
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = this.dataSource.getConnection();
            con.setAutoCommit(true);
            con.setTransactionIsolation(1);
            con.setReadOnly(false);
            ps = con.prepareStatement("DELETE FROM " + this.uuidTableName + " WHERE UUID=?");
            ps.setString(1, uuidString);
            bl = ps.executeUpdate() == 1;
        }
        catch (Exception e) {
            try {
                throw new ReplicationStoreException(e);
            }
            catch (Throwable throwable) {
                SQLUtil.cleanup(con, ps, null);
                throw throwable;
            }
        }
        SQLUtil.cleanup(con, ps, null);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putLog(Operation op) {
        CSN csn = op.getCSN();
        byte[] encodedOp = this.operationCodec.encode(op);
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = this.dataSource.getConnection();
            con.setAutoCommit(true);
            con.setTransactionIsolation(1);
            con.setReadOnly(false);
            ps = con.prepareStatement("INSERT INTO " + this.logTableName + " (CSN_REPLICA_ID, CSN_TIMESTAMP, CSN_OP_SEQ, OPERATION) VALUES(?,?,?,?)");
            ps.setString(1, csn.getReplicaId());
            ps.setLong(2, csn.getTimestamp());
            ps.setInt(3, csn.getOperationSequence());
            ps.setBytes(4, encodedOp);
            if (ps.executeUpdate() != 1) {
                throw new ReplicationStoreException("Failed to insert a row.");
            }
        }
        catch (Exception e) {
            try {
                if (e instanceof ReplicationStoreException) {
                    throw (ReplicationStoreException)e;
                }
                throw new ReplicationStoreException(e);
            }
            catch (Throwable throwable) {
                SQLUtil.cleanup(con, ps, null);
                throw throwable;
            }
        }
        SQLUtil.cleanup(con, ps, null);
        if (!this.knownReplicaIds.contains(csn.getReplicaId())) {
            Object object = this.knownReplicaIdsLock;
            synchronized (object) {
                HashSet<String> newKnownReplicaIds = new HashSet<String>(this.knownReplicaIds);
                newKnownReplicaIds.add(csn.getReplicaId());
                this.knownReplicaIds = newKnownReplicaIds;
            }
        }
    }

    @Override
    public ReplicationLogIterator getLogs(CSNVector updateVector, boolean inclusive) {
        updateVector = this.getNormalizedUpdateVector(updateVector);
        StringBuffer buf = new StringBuffer("SELECT CSN_REPLICA_ID, CSN_TIMESTAMP, CSN_OP_SEQ, OPERATION FROM " + this.logTableName + " ");
        if (updateVector.size() > 0) {
            buf.append("WHERE ");
            int i = updateVector.size();
            while (true) {
                buf.append("( CSN_REPLICA_ID = ? AND (CSN_TIMESTAMP = ? AND CSN_OP_SEQ >" + (inclusive ? "=" : "") + " ? OR CSN_TIMESTAMP > ?) ) ");
                if (--i == 0) break;
                buf.append("OR ");
            }
        }
        buf.append("ORDER BY CSN_TIMESTAMP ASC, CSN_OP_SEQ ASC");
        String query = buf.toString();
        try {
            Connection con = this.dataSource.getConnection();
            con.setAutoCommit(true);
            con.setTransactionIsolation(1);
            con.setReadOnly(true);
            PreparedStatement ps = con.prepareStatement(query);
            int paramIdx = 1;
            for (String replicaId : updateVector.getReplicaIds()) {
                CSN csn = updateVector.getCSN(replicaId);
                ps.setString(paramIdx++, replicaId);
                ps.setLong(paramIdx++, csn.getTimestamp());
                ps.setInt(paramIdx++, csn.getOperationSequence());
                ps.setLong(paramIdx++, csn.getTimestamp());
            }
            ResultSet rs = ps.executeQuery();
            return new DerbyReplicationLogIterator(this.operationCodec, con, ps, rs);
        }
        catch (Exception e) {
            throw new ReplicationStoreException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CSNVector getNormalizedUpdateVector(CSNVector updateVector) {
        CSNVector newUV = new CSNVector();
        Set<String> set = this.knownReplicaIds;
        synchronized (set) {
            for (String knownReplicaId : this.knownReplicaIds) {
                newUV.setCSN(new DefaultCSN(0L, knownReplicaId, 0));
            }
        }
        newUV.setAllCSN(updateVector);
        return newUV;
    }

    @Override
    public ReplicationLogIterator getLogs(CSN fromCSN, boolean inclusive) {
        try {
            Connection con = this.dataSource.getConnection();
            con.setAutoCommit(true);
            con.setTransactionIsolation(1);
            con.setReadOnly(true);
            PreparedStatement ps = con.prepareStatement("SELECT CSN_REPLICA_ID, CSN_TIMESTAMP, CSN_OP_SEQ, OPERATION FROM " + this.logTableName + " " + "WHERE CSN_REPLICA_ID = ? AND (CSN_TIMESTAMP = ? AND CSN_OP_SEQ >" + (inclusive ? "=" : "") + " ? OR CSN_TIMESTAMP > ?) " + "ORDER BY CSN_TIMESTAMP ASC, CSN_OP_SEQ ASC");
            ps.setString(1, fromCSN.getReplicaId());
            ps.setLong(2, fromCSN.getTimestamp());
            ps.setInt(3, fromCSN.getOperationSequence());
            ps.setLong(4, fromCSN.getTimestamp());
            ResultSet rs = ps.executeQuery();
            return new DerbyReplicationLogIterator(this.operationCodec, con, ps, rs);
        }
        catch (Exception e) {
            throw new ReplicationStoreException(e);
        }
    }

    @Override
    public int removeLogs(CSN toCSN, boolean inclusive) {
        int n;
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = this.dataSource.getConnection();
            con.setAutoCommit(true);
            con.setTransactionIsolation(1);
            con.setReadOnly(false);
            ps = con.prepareStatement("DELETE FROM " + this.logTableName + " WHERE " + "CSN_REPLICA_ID = ? AND (CSN_TIMESTAMP = ? AND CSN_OP_SEQ <" + (inclusive ? "=" : "") + " ? OR CSN_TIMESTAMP < ?)");
            ps.setString(1, toCSN.getReplicaId());
            ps.setLong(2, toCSN.getTimestamp());
            ps.setInt(3, toCSN.getOperationSequence());
            ps.setLong(4, toCSN.getTimestamp());
            n = ps.executeUpdate();
        }
        catch (Exception e) {
            try {
                throw new ReplicationStoreException(e);
            }
            catch (Throwable throwable) {
                SQLUtil.cleanup(con, ps, null);
                throw throwable;
            }
        }
        SQLUtil.cleanup(con, ps, null);
        return n;
    }

    @Override
    public int getLogSize() {
        int n;
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            con = this.dataSource.getConnection();
            con.setTransactionIsolation(2);
            con.setReadOnly(true);
            stmt = con.createStatement();
            rs = stmt.executeQuery("SELECT COUNT(*) FROM " + this.logTableName);
            rs.next();
            n = rs.getInt(1);
        }
        catch (Exception e) {
            try {
                throw new ReplicationStoreException(e);
            }
            catch (Throwable throwable) {
                SQLUtil.cleanup(con, stmt, rs);
                throw throwable;
            }
        }
        SQLUtil.cleanup(con, stmt, rs);
        return n;
    }

    @Override
    public int getLogSize(String replicaId) {
        int n;
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = this.dataSource.getConnection();
            con.setTransactionIsolation(2);
            con.setReadOnly(true);
            ps = con.prepareStatement("SELECT COUNT(*) FROM " + this.logTableName + " WHERE CSN_REPLICA_ID=?");
            ps.setString(1, replicaId);
            rs = ps.executeQuery();
            rs.next();
            n = rs.getInt(1);
        }
        catch (Exception e) {
            try {
                throw new ReplicationStoreException(e);
            }
            catch (Throwable throwable) {
                SQLUtil.cleanup(con, ps, rs);
                throw throwable;
            }
        }
        SQLUtil.cleanup(con, ps, rs);
        return n;
    }

    @Override
    public CSNVector getUpdateVector() {
        return this.getVector(false);
    }

    @Override
    public CSNVector getPurgeVector() {
        return this.getVector(true);
    }

    private CSNVector getVector(boolean min) {
        CSNVector i$;
        String ORDER = min ? "ASC" : "DESC";
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        CSNVector result = new CSNVector();
        try {
            con = this.dataSource.getConnection();
            con.setTransactionIsolation(2);
            con.setReadOnly(true);
            ps = con.prepareStatement("SELECT CSN_TIMESTAMP, CSN_OP_SEQ FROM " + this.logTableName + " WHERE CSN_REPLICA_ID=? ORDER BY CSN_TIMESTAMP " + ORDER + ", CSN_OP_SEQ " + ORDER);
            for (String replicaId : this.knownReplicaIds) {
                ps.setString(1, replicaId);
                rs = ps.executeQuery();
                if (rs.next()) {
                    result.setCSN(new DefaultCSN(rs.getLong(1), replicaId, rs.getInt(2)));
                }
                rs.close();
                rs = null;
                ps.clearParameters();
            }
            i$ = result;
        }
        catch (Exception e) {
            try {
                throw new ReplicationStoreException(e);
            }
            catch (Throwable throwable) {
                SQLUtil.cleanup(con, ps, rs);
                throw throwable;
            }
        }
        SQLUtil.cleanup(con, ps, rs);
        return i$;
    }
}

