/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mitosis.service;

import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.directory.mitosis.common.Replica;
import org.apache.directory.mitosis.configuration.ReplicationConfiguration;
import org.apache.directory.mitosis.service.ReplicationContext;
import org.apache.directory.mitosis.service.ReplicationInterceptor;
import org.apache.directory.mitosis.service.protocol.handler.ReplicationClientContextHandler;
import org.apache.directory.mitosis.service.protocol.handler.ReplicationClientProtocolHandler;
import org.apache.directory.mitosis.service.protocol.handler.ReplicationContextHandler;
import org.apache.directory.mitosis.service.protocol.handler.ReplicationProtocolHandler;
import org.apache.directory.mitosis.service.protocol.message.BaseMessage;
import org.apache.directory.server.core.DirectoryService;
import org.apache.mina.common.IoSession;
import org.apache.mina.util.SessionLog;

public class DefaultReplicationContext
implements ReplicationContext {
    private static final Timer EXPIRATION_TIMER = new Timer("ReplicationMessageExpirer");
    private final ReplicationInterceptor interceptor;
    private final ReplicationConfiguration configuration;
    private final DirectoryService directoryService;
    private final IoSession session;
    private final Map<Integer, ExpirationTask> expirableMessages = new HashMap<Integer, ExpirationTask>();
    private int nextSequence;
    private Replica peer;
    private ReplicationContext.State state = ReplicationContext.State.INIT;

    public DefaultReplicationContext(ReplicationInterceptor interceptor, DirectoryService directoryService, ReplicationConfiguration configuration, IoSession session) {
        this.interceptor = interceptor;
        this.configuration = configuration;
        this.directoryService = directoryService;
        this.session = session;
    }

    public ReplicationInterceptor getService() {
        return this.interceptor;
    }

    public ReplicationConfiguration getConfiguration() {
        return this.configuration;
    }

    public DirectoryService getDirectoryService() {
        return this.directoryService;
    }

    public IoSession getSession() {
        return this.session;
    }

    public int getNextSequence() {
        return this.nextSequence++;
    }

    public Replica getPeer() {
        return this.peer;
    }

    public void setPeer(Replica peer) {
        assert (peer != null);
        this.peer = peer;
    }

    public ReplicationContext.State getState() {
        return this.state;
    }

    public void setState(ReplicationContext.State state) {
        this.state = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleExpiration(Object message) {
        BaseMessage bm = (BaseMessage)message;
        ExpirationTask task = new ExpirationTask(bm);
        Map<Integer, ExpirationTask> map = this.expirableMessages;
        synchronized (map) {
            this.expirableMessages.put(bm.getSequence(), task);
        }
        EXPIRATION_TIMER.schedule((TimerTask)task, (long)this.configuration.getResponseTimeout() * 1000L);
    }

    public Object cancelExpiration(int sequence) {
        ExpirationTask task = this.removeTask(sequence);
        if (task == null) {
            return null;
        }
        task.cancel();
        return task.message;
    }

    public boolean replicate() {
        ReplicationProtocolHandler handler = (ReplicationProtocolHandler)this.session.getHandler();
        if (!(handler instanceof ReplicationClientProtocolHandler)) {
            throw new UnsupportedOperationException("Only clients can begin replication.");
        }
        ReplicationContextHandler contextHandler = handler.getContextHandler();
        return ((ReplicationClientContextHandler)contextHandler).beginReplication(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAllExpirations() {
        Map<Integer, ExpirationTask> map = this.expirableMessages;
        synchronized (map) {
            for (ExpirationTask expirationTask : this.expirableMessages.values()) {
                expirationTask.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getScheduledExpirations() {
        Map<Integer, ExpirationTask> map = this.expirableMessages;
        synchronized (map) {
            return this.expirableMessages.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExpirationTask removeTask(int sequence) {
        ExpirationTask task;
        Map<Integer, ExpirationTask> map = this.expirableMessages;
        synchronized (map) {
            task = this.expirableMessages.remove(sequence);
        }
        return task;
    }

    private class ExpirationTask
    extends TimerTask {
        private final BaseMessage message;

        private ExpirationTask(Object message) {
            this.message = (BaseMessage)message;
        }

        public void run() {
            if (DefaultReplicationContext.this.removeTask(this.message.getSequence()) == this) {
                SessionLog.warn((IoSession)DefaultReplicationContext.this.getSession(), (String)("No response within " + DefaultReplicationContext.this.configuration.getResponseTimeout() + " second(s) for message #" + this.message.getSequence()));
                DefaultReplicationContext.this.getSession().close();
            }
        }
    }
}

