/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mitosis.configuration;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.apache.directory.mitosis.common.CSNFactory;
import org.apache.directory.mitosis.common.DefaultCSNFactory;
import org.apache.directory.mitosis.common.Replica;
import org.apache.directory.mitosis.configuration.ReplicationConfigurationException;
import org.apache.directory.mitosis.store.ReplicationStore;
import org.apache.directory.mitosis.store.derby.DerbyReplicationStore;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplicationConfiguration {
    public static final int DEFAULT_LOG_MAX_AGE = 7;
    public static final int DEFAULT_REPLICATION_INTERVAL = 5;
    public static final int DEFAULT_RESPONSE_TIMEOUT = 60;
    public static final int DEFAULT_SERVER_PORT = 7846;
    private static Logger log = LoggerFactory.getLogger(ReplicationConfiguration.class);
    private String replicaId;
    private int serverPort = 7846;
    private int responseTimeout = 60;
    private int replicationInterval = 5;
    private final Set<Replica> peerReplicas = new HashSet<Replica>();
    private CSNFactory csnFactory = new DefaultCSNFactory();
    private ReplicationStore store = new DerbyReplicationStore();
    private int logMaxAge = 7;

    public int getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    public int getResponseTimeout() {
        return this.responseTimeout;
    }

    public void setResponseTimeout(int responseTimeout) {
        this.responseTimeout = responseTimeout;
    }

    public int getReplicationInterval() {
        return this.replicationInterval;
    }

    public void setReplicationInterval(int replicationInterval) {
        if (replicationInterval < 0) {
            replicationInterval = 0;
        }
        this.replicationInterval = replicationInterval;
    }

    public CSNFactory getCsnFactory() {
        return this.csnFactory;
    }

    public void setCsnFactory(CSNFactory csnFactory) {
        this.csnFactory = csnFactory;
    }

    public void addPeerReplica(Replica peer) {
        assert (peer != null);
        this.peerReplicas.add(peer);
    }

    public void removePeerReplica(Replica peer) {
        assert (peer != null);
        this.peerReplicas.remove(peer);
    }

    public void removeAllPeerReplicas() {
        this.peerReplicas.clear();
    }

    public Set<Replica> getPeerReplicas() {
        HashSet<Replica> result = new HashSet<Replica>();
        result.addAll(this.peerReplicas);
        return result;
    }

    public void setPeerReplicas(Set<Object> replicas) {
        assert (replicas != null);
        HashSet<Replica> normalizedReplicas = new HashSet<Replica>();
        for (Object replica : replicas) {
            if (replica instanceof Replica) {
                normalizedReplicas.add((Replica)replica);
                continue;
            }
            normalizedReplicas.add(new Replica(replica.toString()));
        }
        this.peerReplicas.clear();
        this.peerReplicas.addAll(normalizedReplicas);
    }

    public String getReplicaId() {
        return this.replicaId;
    }

    public void setReplicaId(String replicaId) {
        assert (replicaId != null);
        this.replicaId = replicaId;
    }

    public ReplicationStore getStore() {
        return this.store;
    }

    public void setStore(ReplicationStore store) {
        this.store = store;
    }

    public int getLogMaxAge() {
        return this.logMaxAge;
    }

    public void setLogMaxAge(int logMaxAge) {
        if (logMaxAge <= 0) {
            throw new ReplicationConfigurationException("logMaxAge: " + logMaxAge);
        }
        this.logMaxAge = logMaxAge;
    }

    public void validate() throws ReplicationConfigurationException {
        if (this.replicaId == null) {
            log.error("The replicaId is missing");
            throw new ReplicationConfigurationException("Replica ID is not specified.");
        }
        if (this.serverPort < 0 || this.serverPort > 65535) {
            log.error("The replica port is not between 0 and 65535");
            throw new ReplicationConfigurationException("Server port is invalid: " + this.serverPort);
        }
        if (this.responseTimeout <= 0) {
            log.error("The replica responsetimeout is negative");
            throw new ReplicationConfigurationException("Invalid response timeout: " + this.responseTimeout);
        }
        if (this.csnFactory == null) {
            log.error("The CSN factory has not been declared");
            throw new ReplicationConfigurationException("CSN factory is not specified.");
        }
        if (this.store == null) {
            log.error("The store has not been declared");
            throw new ReplicationConfigurationException("Replication store is not specified.");
        }
        if (this.peerReplicas.size() == 0) {
            log.error("The replicas peer list is empty");
            throw new ReplicationConfigurationException("No peer replicas");
        }
        TreeSet<String> ids = new TreeSet<String>();
        HashMap<String, Integer> servers = new HashMap<String, Integer>();
        ids.add(this.replicaId);
        servers.put("localhost", this.serverPort);
        servers.put("127.0.0.1", this.serverPort);
        try {
            servers.put(StringTools.lowerCase((String)InetAddress.getByName("127.0.0.1").getHostName()), this.serverPort);
        }
        catch (UnknownHostException uhe) {
            throw new ReplicationConfigurationException("Unknown host name");
        }
        for (Replica peer : this.peerReplicas) {
            int peerPort;
            if (ids.contains(peer.getId())) {
                log.error("Peer replica ID '{}' has already been declared.", (Object)peer.getId());
                throw new ReplicationConfigurationException("Peer replica ID '" + peer.getId() + "' has already been declared.");
            }
            String replicaServer = StringTools.lowerCase((String)peer.getAddress().getHostName());
            int replicaPort = peer.getAddress().getPort();
            if (servers.containsKey(replicaServer) && replicaPort == (peerPort = ((Integer)servers.get(replicaServer)).intValue())) {
                log.error("The replica in the peer list has already been declared on the server {} with the port {}", (Object)replicaServer, (Object)peerPort);
                throw new ReplicationConfigurationException("Replication store is not specified.");
            }
            servers.put(replicaServer, replicaPort);
        }
    }
}

