/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mitosis.common;

import java.net.InetSocketAddress;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Replica {
    private static Logger log = LoggerFactory.getLogger(Replica.class);
    private static final boolean IS_DEBUG = log.isDebugEnabled();
    private final String id;
    private final InetSocketAddress address;

    public Replica(String replica) {
        if (StringTools.isEmpty((String)replica)) {
            log.error("Null or empty replica are not allowed");
            throw new IllegalArgumentException("Null or empty Replica ");
        }
        int atPos = (replica = replica.trim()).indexOf(64);
        if (atPos <= 0) {
            log.error("The ReplicaId '@' element is missing in {}", (Object)replica);
            throw new IllegalArgumentException("Replica ID not found: " + replica);
        }
        int colonPos = replica.indexOf(58, atPos);
        if (colonPos < 0) {
            log.error("Replica port not found in {}", (Object)replica);
            throw new IllegalArgumentException("Port number not found in replica : " + replica);
        }
        this.id = replica.substring(0, atPos);
        String server = replica.substring(atPos + 1, colonPos);
        int port = -1;
        try {
            port = Integer.parseInt(replica.substring(colonPos + 1));
        }
        catch (NumberFormatException nfe) {
            log.error("The port value should be a value between 1 and 65535, port  : {}", (Object)new Integer(port));
            throw new IllegalArgumentException("Bad port number : " + port);
        }
        try {
            this.address = new InetSocketAddress(server, port);
        }
        catch (IllegalArgumentException iae) {
            log.error("The server address/name is invalid ({}) in replica {}", (Object)server, (Object)replica);
            throw new IllegalArgumentException("The server address/name is invalid in replica " + replica + ", error : " + iae.getMessage());
        }
        if (IS_DEBUG) {
            log.debug("Created a replica {} on server {}", (Object)this.id, (Object)(server + ':' + port));
        }
    }

    public Replica(String id, InetSocketAddress address) {
        assert (id != null);
        assert (address != null);
        this.id = id;
        this.address = address;
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public String getId() {
        return this.id;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Replica) {
            return this.id.equals(((Replica)o).id);
        }
        return false;
    }

    public String toString() {
        return this.getId().toString() + '@' + this.getAddress().getAddress().getHostAddress() + ':' + this.getAddress().getPort();
    }
}

