/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.client.api;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.directory.api.ldap.codec.api.BinaryAttributeDetector;
import org.apache.directory.api.ldap.codec.api.SchemaBinaryAttributeDetector;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.ldap.client.api.DefaultPoolableLdapConnectionFactory;
import org.apache.directory.ldap.client.api.LdapConnection;
import org.apache.directory.ldap.client.api.LdapConnectionConfig;
import org.apache.directory.ldap.client.api.LdapConnectionPool;
import org.apache.directory.ldap.client.api.LdapNetworkConnection;
import org.apache.directory.server.ldap.LdapServer;

public final class LdapApiIntegrationUtils {
    private static final String DEFAULT_HOST = "localhost";
    private static final String DEFAULT_ADMIN = "uid=admin,ou=system";
    private static final String DEFAULT_PASSWORD = "secret";
    private static final Map<Integer, LdapConnectionPool> POOLS = new HashMap<Integer, LdapConnectionPool>();

    private LdapApiIntegrationUtils() {
    }

    public static LdapNetworkConnection createAdminConnection(LdapServer ldapServer) throws LdapException, IOException {
        LdapNetworkConnection conn = new LdapNetworkConnection(InetAddress.getLocalHost().getHostName(), ldapServer.getPort());
        conn.bind(DEFAULT_ADMIN, DEFAULT_PASSWORD);
        return conn;
    }

    public static void closeConnection(LdapNetworkConnection conn) throws LdapException, IOException {
        if (conn != null) {
            conn.unBind();
            conn.close();
        }
    }

    public static LdapConnection getPooledAdminConnection(LdapServer ldapServer) throws Exception {
        LdapConnection ldapConnection = LdapApiIntegrationUtils.getAdminPool(ldapServer).getConnection();
        ldapConnection.setBinaryAttributeDetector((BinaryAttributeDetector)new SchemaBinaryAttributeDetector(ldapServer.getDirectoryService().getSchemaManager()));
        return ldapConnection;
    }

    public static void releasePooledAdminConnection(LdapConnection conn, LdapServer ldapServer) throws Exception {
        LdapApiIntegrationUtils.getAdminPool(ldapServer).releaseConnection(conn);
    }

    private static LdapConnectionPool getAdminPool(LdapServer ldapServer) {
        int port = ldapServer.getPort();
        if (!POOLS.containsKey(port)) {
            LdapConnectionConfig config = new LdapConnectionConfig();
            try {
                config.setLdapHost(InetAddress.getLocalHost().getHostName());
            }
            catch (UnknownHostException uhe) {
                config.setLdapHost(DEFAULT_HOST);
            }
            config.setLdapPort(port);
            config.setName(DEFAULT_ADMIN);
            config.setCredentials(DEFAULT_PASSWORD);
            DefaultPoolableLdapConnectionFactory factory = new DefaultPoolableLdapConnectionFactory(config);
            LdapConnectionPool pool = new LdapConnectionPool((PoolableObjectFactory)factory);
            pool.setTestOnBorrow(true);
            POOLS.put(port, pool);
        }
        return POOLS.get(port);
    }

    public static LdapConnection getAnonymousNetworkConnection(String host, int port) throws Exception {
        LdapNetworkConnection connection = new LdapNetworkConnection(host, port);
        connection.bind();
        return connection;
    }

    public static LdapConnection getAnonymousNetworkConnection(LdapServer ldapServer) throws Exception {
        LdapNetworkConnection connection = new LdapNetworkConnection(InetAddress.getLocalHost().getHostName(), ldapServer.getPort());
        connection.setTimeOut(0L);
        connection.bind();
        return connection;
    }
}

