/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree.gui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import javax.swing.tree.TreeNode;
import org.apache.directory.server.core.partition.impl.btree.AbstractBTreePartition;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.search.Evaluator;
import org.apache.directory.server.xdbm.search.SearchEngine;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.filter.ExprNode;
import org.apache.directory.shared.ldap.model.name.Dn;

public class EntryNode
implements TreeNode {
    private final AbstractBTreePartition partition;
    private final EntryNode parent;
    private final Entry entry;
    private final ArrayList<TreeNode> children;
    private final String id;

    public EntryNode(String id, EntryNode parent, AbstractBTreePartition partition, Entry entry, Map<String, EntryNode> map) {
        this(id, parent, partition, entry, map, null, null);
    }

    public EntryNode(String id, EntryNode parent, AbstractBTreePartition db, Entry entry, Map<String, EntryNode> map, ExprNode exprNode, SearchEngine engine) {
        this.partition = db;
        this.id = id;
        this.entry = entry;
        this.children = new ArrayList();
        this.parent = parent == null ? this : parent;
        try {
            ArrayList<IndexEntry> recordForwards = new ArrayList<IndexEntry>();
            Object childList = null;
            while (childList.next()) {
                IndexEntry old = (IndexEntry)childList.get();
                IndexEntry newRec = new IndexEntry();
                newRec.copy(old);
                recordForwards.add(newRec);
            }
            childList.close();
            for (IndexEntry rec : recordForwards) {
                EntryNode child;
                Entry newEntry;
                if (engine != null && exprNode != null) {
                    if (db.getChildCount((String)rec.getId()) == 0) {
                        Evaluator evaluator = engine.evaluator(exprNode);
                        if (!evaluator.evaluate(rec)) continue;
                        Entry newEntry2 = db.lookup((String)rec.getId());
                        EntryNode child2 = new EntryNode((String)rec.getId(), this, db, newEntry2, map, exprNode, engine);
                        this.children.add(child2);
                        continue;
                    }
                    newEntry = db.lookup((String)rec.getId());
                    child = new EntryNode((String)rec.getId(), this, db, newEntry, map, exprNode, engine);
                    this.children.add(child);
                    continue;
                }
                newEntry = db.lookup((String)rec.getId());
                child = new EntryNode((String)rec.getId(), this, db, newEntry, map);
                this.children.add(child);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        map.put(id, this);
    }

    public Enumeration<TreeNode> children() {
        return Collections.enumeration(this.children);
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        return this.children.get(childIndex);
    }

    @Override
    public int getChildCount() {
        return this.children.size();
    }

    @Override
    public int getIndex(TreeNode child) {
        return this.children.indexOf(child);
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    @Override
    public boolean isLeaf() {
        return this.children.size() <= 0;
    }

    public String getEntryDn() throws Exception {
        return this.partition.getEntryDn(this.id).getNormName();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        try {
            Dn dn = this.partition.getEntryDn(this.id);
            buf.append("(").append(this.id).append(") ");
            buf.append(dn.getRdn());
        }
        catch (Exception e) {
            buf.append("ERROR: " + e.getLocalizedMessage());
        }
        if (this.children.size() > 0) {
            buf.append(" [").append(this.children.size()).append("]");
        }
        return buf.toString();
    }

    public Entry getLdapEntry() {
        return this.entry;
    }

    public String getEntryId() {
        return this.id;
    }
}

