/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.ForwardIndexEntry;
import org.apache.directory.server.xdbm.Index;
import org.apache.directory.server.xdbm.IndexCursor;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.shared.ldap.NotImplementedException;
import org.apache.directory.shared.ldap.util.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexDialog<K, O, ID>
extends JDialog {
    private static final Logger LOG = LoggerFactory.getLogger(IndexDialog.class);
    private static final long serialVersionUID = 3689917253680445238L;
    public static final String DEFAULT_CURSOR = "Default";
    public static final String EQUALITY_CURSOR = "Equality";
    public static final String GREATER_CURSOR = "Greater";
    public static final String LESS_CURSOR = "Less";
    public static final String REGEX_CURSOR = "Regex";
    private Panel mainPnl = new Panel();
    private JTabbedPane tabbedPane = new JTabbedPane();
    private JPanel listPnl = new JPanel();
    private JPanel cursorPnl = new JPanel();
    private JPanel resultsPnl = new JPanel();
    private JScrollPane jScrollPane2 = new JScrollPane();
    private JTable resultsTbl = new JTable();
    private JPanel buttonPnl = new JPanel();
    private JButton doneBut = new JButton();
    private JLabel jLabel1 = new JLabel();
    private JTextField keyText = new JTextField();
    private JLabel jLabel2 = new JLabel();
    private JButton scanBut = new JButton();
    private Index<K, O, ID> index = null;
    private String selectedCursorType = "Default";

    public IndexDialog(Frame parent, boolean modal, Index<K, O, ID> index) {
        super(parent, modal);
        this.index = index;
        this.initGUI();
    }

    public IndexDialog(Index<K, O, ID> index) {
        this.index = index;
        this.initGUI();
    }

    private void initGUI() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                IndexDialog.this.closeDialog();
            }
        });
        this.pack();
        this.setTitle("Index On Attribute '" + this.index.getAttribute().getName() + "'");
        this.setBounds(new Rectangle(0, 0, 512, 471));
        this.getContentPane().add((Component)this.mainPnl, "Center");
        this.mainPnl.setLayout(new BorderLayout());
        this.mainPnl.add((Component)this.tabbedPane, "Center");
        this.tabbedPane.add((Component)this.listPnl, "Listing");
        this.listPnl.setLayout(new GridBagLayout());
        RadioButtonListener radioListener = new RadioButtonListener();
        JRadioButton radioDefault = new JRadioButton(DEFAULT_CURSOR);
        radioDefault.setActionCommand(DEFAULT_CURSOR);
        radioDefault.setSelected(true);
        radioDefault.addActionListener(radioListener);
        JRadioButton radioEquality = new JRadioButton(EQUALITY_CURSOR);
        radioEquality.setActionCommand(EQUALITY_CURSOR);
        radioEquality.addActionListener(radioListener);
        JRadioButton radioGreater = new JRadioButton(GREATER_CURSOR);
        radioGreater.setActionCommand(GREATER_CURSOR);
        radioGreater.addActionListener(radioListener);
        JRadioButton radioLess = new JRadioButton(LESS_CURSOR);
        radioLess.setActionCommand(LESS_CURSOR);
        radioLess.addActionListener(radioListener);
        JRadioButton radioRegex = new JRadioButton(REGEX_CURSOR);
        radioRegex.setActionCommand(REGEX_CURSOR);
        radioRegex.addActionListener(radioListener);
        ButtonGroup group = new ButtonGroup();
        group.add(radioDefault);
        group.add(radioEquality);
        group.add(radioGreater);
        group.add(radioLess);
        group.add(radioRegex);
        JPanel radioPanel = new JPanel();
        radioPanel.setLayout(new BoxLayout(radioPanel, 0));
        radioPanel.add(radioDefault);
        radioPanel.add(radioEquality);
        radioPanel.add(radioGreater);
        radioPanel.add(radioLess);
        radioPanel.add(radioRegex);
        this.listPnl.add((Component)this.cursorPnl, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.15, 11, 1, new Insets(15, 0, 30, 0), 0, 0));
        this.listPnl.add((Component)this.resultsPnl, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.8, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.listPnl.add((Component)this.buttonPnl, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.05, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.cursorPnl.setLayout(new GridBagLayout());
        this.cursorPnl.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(153, 153, 153), 1), "Display Cursor Constraints", 4, 2, new Font("SansSerif", 0, 14), new Color(60, 60, 60)));
        this.cursorPnl.add((Component)this.jLabel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 0, 10), 0, 0));
        this.cursorPnl.add((Component)this.keyText, new GridBagConstraints(1, 1, 1, 1, 0.4, 0.0, 17, 1, new Insets(5, 5, 5, 236), 0, 0));
        this.cursorPnl.add((Component)this.jLabel2, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 0, 10), 0, 0));
        this.cursorPnl.add((Component)radioPanel, new GridBagConstraints(1, 0, 1, 1, 0.4, 0.0, 17, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.resultsPnl.setLayout(new BorderLayout());
        this.resultsPnl.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(153, 153, 153), 1), "Scan Results", 4, 2, new Font("SansSerif", 0, 14), new Color(60, 60, 60)));
        this.resultsPnl.add((Component)this.jScrollPane2, "Center");
        this.jScrollPane2.getViewport().add(this.resultsTbl);
        this.buttonPnl.setLayout(new FlowLayout(1, 15, 5));
        this.buttonPnl.add(this.doneBut);
        this.buttonPnl.add(this.scanBut);
        this.doneBut.setText("Done");
        this.doneBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                IndexDialog.this.closeDialog();
            }
        });
        this.jLabel1.setText("Key Constraint:");
        this.keyText.setText("");
        this.keyText.setMinimumSize(new Dimension(130, 20));
        this.keyText.setPreferredSize(new Dimension(130, 20));
        this.keyText.setMaximumSize(new Dimension(130, 20));
        this.keyText.setFont(new Font("SansSerif", 0, 14));
        this.keyText.setSize(new Dimension(130, 20));
        this.jLabel2.setText("Cursor Type:");
        this.scanBut.setText("Scan");
        this.scanBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                IndexDialog.this.doScan(IndexDialog.this.keyText.getText(), IndexDialog.this.selectedCursorType);
            }
        });
        this.doScan(null, DEFAULT_CURSOR);
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    public boolean doScan(K key, String scanType) {
        if (key == null && !scanType.equals(DEFAULT_CURSOR)) {
            JOptionPane.showMessageDialog(null, "Cannot use a " + scanType + " scan type with a null key constraint.", "Missing Key Constraint", 0);
            return false;
        }
        Object[] cols = new Object[]{"Keys ( Attribute Value )", "Values ( Entry Id )"};
        DefaultTableModel model = new DefaultTableModel(cols, 0);
        int count = 0;
        try {
            if (scanType.equals(EQUALITY_CURSOR)) {
                IndexCursor list = this.index.forwardCursor(key);
                list.beforeFirst();
                while (list.next()) {
                    IndexEntry rec = (IndexEntry)list.get();
                    Object[] row = new Object[]{rec.getValue(), rec.getId()};
                    model.addRow(row);
                    ++count;
                }
            } else if (scanType.equals(GREATER_CURSOR)) {
                IndexCursor list = this.index.forwardCursor();
                ForwardIndexEntry entry = new ForwardIndexEntry();
                entry.setValue(key);
                list.before((Object)entry);
                while (list.next()) {
                    IndexEntry rec = (IndexEntry)list.get();
                    Object[] row = new Object[]{rec.getValue(), rec.getId()};
                    model.addRow(row);
                    ++count;
                }
            } else if (scanType.equals(LESS_CURSOR)) {
                IndexCursor list = this.index.forwardCursor();
                ForwardIndexEntry entry = new ForwardIndexEntry();
                entry.setValue(key);
                list.after((Object)entry);
                while (list.previous()) {
                    IndexEntry rec = (IndexEntry)list.get();
                    Object[] row = new Object[]{rec.getValue(), rec.getId()};
                    model.addRow(row);
                    ++count;
                }
            } else {
                if (scanType.equals(REGEX_CURSOR)) {
                    throw new NotImplementedException();
                }
                IndexCursor list = this.index.forwardCursor();
                while (list.next()) {
                    IndexEntry rec = (IndexEntry)list.get();
                    Object[] row = new Object[]{rec.getValue(), rec.getId()};
                    model.addRow(row);
                    ++count;
                }
            }
            this.resultsTbl.setModel(model);
            this.resultsPnl.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(153, 153, 153), 1), "Scan Results: " + count, 4, 2, new Font("SansSerif", 0, 14), new Color(60, 60, 60)));
            if (this.isVisible()) {
                this.validate();
            }
        }
        catch (Exception e) {
            String msg = ExceptionUtils.getStackTrace((Throwable)e);
            if (msg.length() > 1024) {
                msg = msg.substring(0, 1024) + "\n. . . TRUNCATED . . .";
            }
            msg = I18n.err((String)I18n.ERR_183, (Object[])new Object[]{this.index.getAttribute(), scanType, key, msg});
            LOG.error(msg, (Throwable)e);
            JTextArea area = new JTextArea();
            area.setText(msg);
            JOptionPane.showMessageDialog(null, area, "Index Scan Error", 0);
            return false;
        }
        return true;
    }

    public static void show(Index index) {
        IndexDialog dialog = new IndexDialog(index);
        dialog.setVisible(true);
    }

    class RadioButtonListener
    implements ActionListener {
        RadioButtonListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().equals(IndexDialog.DEFAULT_CURSOR)) {
                IndexDialog.this.selectedCursorType = IndexDialog.DEFAULT_CURSOR;
            } else if (e.getActionCommand().equals(IndexDialog.EQUALITY_CURSOR)) {
                IndexDialog.this.selectedCursorType = IndexDialog.EQUALITY_CURSOR;
            } else if (e.getActionCommand().equals(IndexDialog.GREATER_CURSOR)) {
                IndexDialog.this.selectedCursorType = IndexDialog.GREATER_CURSOR;
            } else if (e.getActionCommand().equals(IndexDialog.LESS_CURSOR)) {
                IndexDialog.this.selectedCursorType = IndexDialog.LESS_CURSOR;
            } else if (e.getActionCommand().equals(IndexDialog.REGEX_CURSOR)) {
                IndexDialog.this.selectedCursorType = IndexDialog.REGEX_CURSOR;
            }
        }
    }
}

