/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search.impl;

import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.Store;
import org.apache.directory.server.xdbm.search.Evaluator;
import org.apache.directory.shared.ldap.filter.ScopeNode;
import org.apache.directory.shared.ldap.filter.SearchScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubtreeScopeEvaluator<E, ID>
implements Evaluator<ScopeNode, E, ID> {
    private final ScopeNode node;
    private final ID baseId;
    private final boolean baseIsContextEntry;
    private final boolean dereferencing;
    private final Store<E, ID> db;
    private ID contextEntryId;

    public SubtreeScopeEvaluator(Store<E, ID> db, ScopeNode node) throws Exception {
        this.db = db;
        this.node = node;
        if (node.getScope() != SearchScope.SUBTREE) {
            throw new IllegalStateException(I18n.err((String)I18n.ERR_727, (Object[])new Object[0]));
        }
        this.baseId = db.getEntryId(node.getBaseDn());
        this.baseIsContextEntry = this.getContextEntryId() == this.baseId;
        this.dereferencing = node.getDerefAliases().isDerefInSearching() || node.getDerefAliases().isDerefAlways();
    }

    private ID getContextEntryId() throws Exception {
        if (this.contextEntryId == null) {
            try {
                this.contextEntryId = this.db.getEntryId(this.db.getSuffix().getNormName());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.contextEntryId == null) {
            return (ID)this.db.getDefaultId();
        }
        return this.contextEntryId;
    }

    public boolean evaluate(IndexEntry<?, E, ID> candidate) throws Exception {
        if (this.baseIsContextEntry || this.baseId.equals(candidate.getId())) {
            return true;
        }
        boolean isDescendant = this.db.getSubLevelIndex().forward(this.baseId, candidate.getId());
        if (!this.isDereferencing()) {
            return isDescendant;
        }
        if (null != this.db.getAliasIndex().reverseLookup(candidate.getId())) {
            return false;
        }
        if (isDescendant) {
            return true;
        }
        return this.db.getSubAliasIndex().forward(this.baseId, candidate.getId());
    }

    public boolean evaluateId(ID id) throws Exception {
        boolean isDescendant = this.db.getSubLevelIndex().forward(this.baseId, id);
        if (!this.isDereferencing()) {
            return isDescendant;
        }
        if (null != this.db.getAliasIndex().reverseLookup(id)) {
            return false;
        }
        if (isDescendant) {
            return true;
        }
        return this.db.getSubAliasIndex().forward(this.baseId, id);
    }

    public boolean evaluateEntry(E candidate) throws Exception {
        throw new UnsupportedOperationException(I18n.err((String)I18n.ERR_721, (Object[])new Object[0]));
    }

    public ScopeNode getExpression() {
        return this.node;
    }

    public ID getBaseId() {
        return this.baseId;
    }

    public boolean isDereferencing() {
        return this.dereferencing;
    }
}

