/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search.impl;

import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.AbstractIndexCursor;
import org.apache.directory.server.xdbm.Index;
import org.apache.directory.server.xdbm.IndexCursor;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.Store;
import org.apache.directory.server.xdbm.search.impl.EqualityEvaluator;
import org.apache.directory.shared.ldap.cursor.InvalidCursorPositionException;
import org.apache.directory.shared.ldap.entry.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EqualityCursor<V, ID>
extends AbstractIndexCursor<V, ServerEntry, ID> {
    private static final String UNSUPPORTED_MSG = I18n.err((String)I18n.ERR_714, (Object[])new Object[0]);
    private final EqualityEvaluator equalityEvaluator;
    private final IndexCursor<V, ServerEntry, ID> userIdxCursor;
    private final IndexCursor<String, ServerEntry, ID> ndnIdxCursor;
    private boolean available = false;

    public EqualityCursor(Store<ServerEntry, ID> db, EqualityEvaluator<V, ID> equalityEvaluator) throws Exception {
        this.equalityEvaluator = equalityEvaluator;
        String attribute = equalityEvaluator.getExpression().getAttribute();
        Value value = equalityEvaluator.getExpression().getValue();
        if (db.hasIndexOn(attribute)) {
            Index userIndex = db.getIndex(attribute);
            this.userIdxCursor = userIndex.forwardCursor(value.get());
            this.ndnIdxCursor = null;
        } else {
            this.ndnIdxCursor = db.getNdnIndex().forwardCursor();
            this.userIdxCursor = null;
        }
    }

    public boolean available() {
        if (this.userIdxCursor != null) {
            return this.userIdxCursor.available();
        }
        return this.available;
    }

    public void beforeValue(ID id, V value) throws Exception {
        this.checkNotClosed("beforeValue()");
        if (this.userIdxCursor == null) {
            throw new UnsupportedOperationException(UNSUPPORTED_MSG);
        }
        this.userIdxCursor.beforeValue(id, value);
    }

    public void before(IndexEntry<V, ServerEntry, ID> element) throws Exception {
        this.checkNotClosed("before()");
        if (this.userIdxCursor == null) {
            throw new UnsupportedOperationException(UNSUPPORTED_MSG);
        }
        this.userIdxCursor.before(element);
    }

    public void afterValue(ID id, V key) throws Exception {
        this.checkNotClosed("afterValue()");
        if (this.userIdxCursor == null) {
            throw new UnsupportedOperationException(UNSUPPORTED_MSG);
        }
        this.userIdxCursor.afterValue(id, key);
    }

    public void after(IndexEntry<V, ServerEntry, ID> element) throws Exception {
        this.checkNotClosed("after()");
        if (this.userIdxCursor == null) {
            throw new UnsupportedOperationException(UNSUPPORTED_MSG);
        }
        this.userIdxCursor.after(element);
    }

    public void beforeFirst() throws Exception {
        this.checkNotClosed("beforeFirst()");
        if (this.userIdxCursor != null) {
            this.userIdxCursor.beforeFirst();
        } else {
            this.ndnIdxCursor.beforeFirst();
            this.available = false;
        }
    }

    public void afterLast() throws Exception {
        this.checkNotClosed("afterLast()");
        if (this.userIdxCursor != null) {
            this.userIdxCursor.afterLast();
        } else {
            this.ndnIdxCursor.afterLast();
            this.available = false;
        }
    }

    public boolean first() throws Exception {
        this.beforeFirst();
        return this.next();
    }

    public boolean last() throws Exception {
        this.afterLast();
        return this.previous();
    }

    public boolean previous() throws Exception {
        if (this.userIdxCursor != null) {
            return this.userIdxCursor.previous();
        }
        while (this.ndnIdxCursor.previous()) {
            this.checkNotClosed("previous()");
            IndexEntry candidate = (IndexEntry)this.ndnIdxCursor.get();
            if (!this.equalityEvaluator.evaluate(candidate)) continue;
            this.available = true;
            return true;
        }
        this.available = false;
        return false;
    }

    public boolean next() throws Exception {
        if (this.userIdxCursor != null) {
            return this.userIdxCursor.next();
        }
        while (this.ndnIdxCursor.next()) {
            this.checkNotClosed("next()");
            IndexEntry candidate = (IndexEntry)this.ndnIdxCursor.get();
            if (!this.equalityEvaluator.evaluate(candidate)) continue;
            this.available = true;
            return true;
        }
        this.available = false;
        return false;
    }

    public IndexEntry<V, ServerEntry, ID> get() throws Exception {
        this.checkNotClosed("get()");
        if (this.userIdxCursor != null) {
            return (IndexEntry)this.userIdxCursor.get();
        }
        if (this.available) {
            return (IndexEntry)this.ndnIdxCursor.get();
        }
        throw new InvalidCursorPositionException(I18n.err((String)I18n.ERR_708, (Object[])new Object[0]));
    }

    public boolean isElementReused() {
        if (this.userIdxCursor != null) {
            return this.userIdxCursor.isElementReused();
        }
        return this.ndnIdxCursor.isElementReused();
    }

    public void close() throws Exception {
        super.close();
        if (this.userIdxCursor != null) {
            this.userIdxCursor.close();
        } else {
            this.ndnIdxCursor.close();
        }
    }
}

