/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.AbstractIndexCursor;
import org.apache.directory.server.xdbm.IndexCursor;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.search.Evaluator;
import org.apache.directory.shared.ldap.cursor.InvalidCursorPositionException;
import org.apache.directory.shared.ldap.filter.ExprNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AndCursor<V, ID>
extends AbstractIndexCursor<V, ServerEntry, ID> {
    private static final String UNSUPPORTED_MSG = I18n.err((String)I18n.ERR_707, (Object[])new Object[0]);
    private final IndexCursor<V, ServerEntry, ID> wrapped;
    private final List<Evaluator<? extends ExprNode, ServerEntry, ID>> evaluators;
    private boolean available = false;

    public AndCursor(IndexCursor<V, ServerEntry, ID> wrapped, List<Evaluator<? extends ExprNode, ServerEntry, ID>> evaluators) {
        this.wrapped = wrapped;
        this.evaluators = this.optimize(evaluators);
    }

    public boolean available() {
        return this.available;
    }

    public void beforeValue(ID id, V value) {
        throw new UnsupportedOperationException(UNSUPPORTED_MSG);
    }

    public void afterValue(ID id, V value) {
        throw new UnsupportedOperationException(UNSUPPORTED_MSG);
    }

    public void before(IndexEntry<V, ServerEntry, ID> element) throws Exception {
        throw new UnsupportedOperationException(UNSUPPORTED_MSG);
    }

    public void after(IndexEntry<V, ServerEntry, ID> element) throws Exception {
        throw new UnsupportedOperationException(UNSUPPORTED_MSG);
    }

    public void beforeFirst() throws Exception {
        this.checkNotClosed("beforeFirst()");
        this.wrapped.beforeFirst();
        this.available = false;
    }

    public void afterLast() throws Exception {
        this.checkNotClosed("afterLast()");
        this.wrapped.afterLast();
        this.available = false;
    }

    public boolean first() throws Exception {
        this.beforeFirst();
        return this.next();
    }

    public boolean last() throws Exception {
        this.afterLast();
        return this.previous();
    }

    public boolean previous() throws Exception {
        while (this.wrapped.previous()) {
            this.checkNotClosed("previous()");
            IndexEntry candidate = (IndexEntry)this.wrapped.get();
            if (!this.matches(candidate)) continue;
            this.available = true;
            return true;
        }
        this.available = false;
        return false;
    }

    public boolean next() throws Exception {
        while (this.wrapped.next()) {
            this.checkNotClosed("next()");
            IndexEntry candidate = (IndexEntry)this.wrapped.get();
            if (!this.matches(candidate)) continue;
            this.available = true;
            return true;
        }
        this.available = false;
        return false;
    }

    public IndexEntry<V, ServerEntry, ID> get() throws Exception {
        this.checkNotClosed("get()");
        if (this.available) {
            return (IndexEntry)this.wrapped.get();
        }
        throw new InvalidCursorPositionException(I18n.err((String)I18n.ERR_708, (Object[])new Object[0]));
    }

    public boolean isElementReused() {
        return this.wrapped.isElementReused();
    }

    public void close() throws Exception {
        super.close();
        this.wrapped.close();
    }

    private List<Evaluator<? extends ExprNode, ServerEntry, ID>> optimize(List<Evaluator<? extends ExprNode, ServerEntry, ID>> unoptimized) {
        ArrayList<Evaluator<ExprNode, ServerEntry, ID>> optimized = new ArrayList<Evaluator<ExprNode, ServerEntry, ID>>(unoptimized.size());
        optimized.addAll(unoptimized);
        Collections.sort(optimized, new Comparator<Evaluator<?, ServerEntry, ID>>(){

            @Override
            public int compare(Evaluator<?, ServerEntry, ID> e1, Evaluator<?, ServerEntry, ID> e2) {
                long scanCount2;
                long scanCount1 = (Long)e1.getExpression().get((Object)"count");
                if (scanCount1 == (scanCount2 = ((Long)e2.getExpression().get((Object)"count")).longValue())) {
                    return 0;
                }
                if (scanCount1 < scanCount2) {
                    return -1;
                }
                return 1;
            }
        });
        return optimized;
    }

    private boolean matches(IndexEntry<?, ServerEntry, ID> indexEntry) throws Exception {
        for (Evaluator<? extends ExprNode, ServerEntry, ID> evaluator : this.evaluators) {
            if (evaluator.evaluate(indexEntry)) continue;
            return false;
        }
        return true;
    }
}

