/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search.cursor;

import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.AbstractIndexCursor;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.ParentIdAndRdn;
import org.apache.directory.server.xdbm.Store;
import org.apache.directory.shared.ldap.model.cursor.Cursor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChildrenCursor
extends AbstractIndexCursor<String> {
    private static final Logger LOG_CURSOR = LoggerFactory.getLogger((String)"CURSOR");
    private static final boolean IS_DEBUG = LOG_CURSOR.isDebugEnabled();
    private static final String UNSUPPORTED_MSG = I18n.err((I18n)I18n.ERR_719, (Object[])new Object[0]);
    private final Cursor<IndexEntry<ParentIdAndRdn, String>> cursor;
    private String parentId;
    private IndexEntry<String, String> prefetched;

    public ChildrenCursor(Store db, String parentId, Cursor<IndexEntry<ParentIdAndRdn, String>> cursor) throws Exception {
        this.parentId = parentId;
        this.cursor = cursor;
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Creating ChildrenCursor {}", (Object)this);
        }
    }

    @Override
    protected String getUnsupportedMessage() {
        return UNSUPPORTED_MSG;
    }

    public void beforeFirst() throws Exception {
        this.checkNotClosed("beforeFirst()");
        this.setAvailable(false);
    }

    public void afterLast() throws Exception {
        throw new UnsupportedOperationException(this.getUnsupportedMessage());
    }

    public boolean first() throws Exception {
        this.beforeFirst();
        return this.next();
    }

    public boolean last() throws Exception {
        throw new UnsupportedOperationException(this.getUnsupportedMessage());
    }

    public boolean previous() throws Exception {
        IndexEntry entry;
        this.checkNotClosed("next()");
        boolean hasPrevious = this.cursor.previous();
        if (hasPrevious && ((ParentIdAndRdn)(entry = (IndexEntry)this.cursor.get()).getTuple().getKey()).getParentId().equals(this.parentId)) {
            this.prefetched = entry;
            return true;
        }
        return false;
    }

    public boolean next() throws Exception {
        this.checkNotClosed("next()");
        boolean hasNext = this.cursor.next();
        if (hasNext) {
            IndexEntry cursorEntry = (IndexEntry)this.cursor.get();
            IndexEntry<String, String> entry = new IndexEntry<String, String>();
            entry.setId((String)cursorEntry.getId());
            entry.setKey(((ParentIdAndRdn)cursorEntry.getTuple().getKey()).getParentId());
            if (((String)entry.getKey()).equals(this.parentId)) {
                this.prefetched = entry;
                return true;
            }
        }
        return false;
    }

    public IndexEntry<String, String> get() throws Exception {
        this.checkNotClosed("get()");
        return this.prefetched;
    }

    public void close() throws Exception {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Closing ChildrenCursor {}", (Object)this);
        }
        this.cursor.close();
        super.close();
    }

    public void close(Exception cause) throws Exception {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Closing ChildrenCursor {}", (Object)this);
        }
        this.cursor.close(cause);
        super.close(cause);
    }

    public String toString(String tabs) {
        StringBuilder sb = new StringBuilder();
        sb.append(tabs).append("ChildrenCursor (");
        if (this.available()) {
            sb.append("available)");
        } else {
            sb.append("absent)");
        }
        sb.append("#parent<").append(this.parentId).append("> :\n");
        sb.append(this.cursor.toString(tabs + "  "));
        return sb.toString();
    }

    public String toString() {
        return this.toString("");
    }
}

