/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree;

import org.apache.directory.server.core.partition.impl.btree.AbstractBTreePartition;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.search.Evaluator;
import org.apache.directory.server.xdbm.search.PartitionSearchResult;
import org.apache.directory.shared.ldap.model.cursor.AbstractCursor;
import org.apache.directory.shared.ldap.model.cursor.ClosureMonitor;
import org.apache.directory.shared.ldap.model.cursor.Cursor;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.filter.ExprNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntryCursorAdaptor
extends AbstractCursor<Entry> {
    private static final Logger LOG_CURSOR = LoggerFactory.getLogger((String)"CURSOR");
    private static final boolean IS_DEBUG = LOG_CURSOR.isDebugEnabled();
    private final AbstractBTreePartition db;
    private final Cursor<IndexEntry<String, String>> indexCursor;
    private final Evaluator<? extends ExprNode> evaluator;

    public EntryCursorAdaptor(AbstractBTreePartition db, PartitionSearchResult searchResult) {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Creating EntryCursorAdaptor {}", (Object)this);
        }
        this.db = db;
        this.indexCursor = searchResult.getResultSet();
        this.evaluator = searchResult.getEvaluator();
    }

    public void after(Entry element) throws Exception {
        throw new UnsupportedOperationException();
    }

    public void afterLast() throws Exception {
        this.indexCursor.afterLast();
    }

    public boolean available() {
        return this.indexCursor.available();
    }

    public void before(Entry element) throws Exception {
        throw new UnsupportedOperationException();
    }

    public void beforeFirst() throws Exception {
        this.indexCursor.beforeFirst();
    }

    public final void setClosureMonitor(ClosureMonitor monitor) {
        this.indexCursor.setClosureMonitor(monitor);
    }

    public void close() throws Exception {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Closing EntryCursorAdaptor {}", (Object)this);
        }
        this.indexCursor.close();
    }

    public void close(Exception cause) throws Exception {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Closing EntryCursorAdaptor {}", (Object)this);
        }
        this.indexCursor.close(cause);
    }

    public boolean first() throws Exception {
        return this.indexCursor.first();
    }

    public Entry get() throws Exception {
        IndexEntry indexEntry = (IndexEntry)this.indexCursor.get();
        if (this.evaluator.evaluate(indexEntry)) {
            return indexEntry.getEntry();
        }
        return null;
    }

    public boolean isClosed() throws Exception {
        return this.indexCursor.isClosed();
    }

    public boolean last() throws Exception {
        return this.indexCursor.last();
    }

    public boolean next() throws Exception {
        return this.indexCursor.next();
    }

    public boolean previous() throws Exception {
        return this.indexCursor.previous();
    }
}

