/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search.impl;

import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.AbstractIndexCursor;
import org.apache.directory.server.xdbm.IndexCursor;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.Store;
import org.apache.directory.server.xdbm.search.impl.PresenceEvaluator;
import org.apache.directory.shared.ldap.model.cursor.InvalidCursorPositionException;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.schema.AttributeType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PresenceCursor<ID extends Comparable<ID>>
extends AbstractIndexCursor<String, Entry, ID> {
    private static final Logger LOG_CURSOR = LoggerFactory.getLogger((String)"CURSOR");
    private static final String UNSUPPORTED_MSG = I18n.err((I18n)I18n.ERR_724, (Object[])new Object[0]);
    private final IndexCursor<String, Entry, ID> uuidCursor;
    private final IndexCursor<String, Entry, ID> presenceCursor;
    private final PresenceEvaluator<ID> presenceEvaluator;
    private IndexEntry<String, ID> prefetched;

    public PresenceCursor(Store<Entry, ID> store, PresenceEvaluator<ID> presenceEvaluator) throws Exception {
        LOG_CURSOR.debug("Creating PresenceCursor {}", (Object)this);
        this.presenceEvaluator = presenceEvaluator;
        AttributeType type = presenceEvaluator.getAttributeType();
        if (store.hasUserIndexOn(type)) {
            this.presenceCursor = store.getPresenceIndex().forwardCursor(type.getOid());
            this.uuidCursor = null;
        } else {
            this.presenceCursor = null;
            this.uuidCursor = store.getEntryUuidIndex().forwardCursor();
        }
    }

    @Override
    protected String getUnsupportedMessage() {
        return UNSUPPORTED_MSG;
    }

    @Override
    public boolean available() {
        if (this.presenceCursor != null) {
            return this.presenceCursor.available();
        }
        return super.available();
    }

    @Override
    public void beforeValue(ID id, String value) throws Exception {
        this.checkNotClosed("beforeValue()");
        if (this.presenceCursor != null) {
            this.presenceCursor.beforeValue(id, value);
            return;
        }
        super.beforeValue(id, value);
    }

    @Override
    public void before(IndexEntry<String, ID> element) throws Exception {
        this.checkNotClosed("before()");
        if (this.presenceCursor != null) {
            this.presenceCursor.before(element);
            return;
        }
        super.before(element);
    }

    @Override
    public void afterValue(ID id, String value) throws Exception {
        this.checkNotClosed("afterValue()");
        if (this.presenceCursor != null) {
            this.presenceCursor.afterValue(id, value);
            return;
        }
        super.afterValue(id, value);
    }

    @Override
    public void after(IndexEntry<String, ID> element) throws Exception {
        this.checkNotClosed("after()");
        if (this.presenceCursor != null) {
            this.presenceCursor.after(element);
            return;
        }
        super.after(element);
    }

    public void beforeFirst() throws Exception {
        this.checkNotClosed("beforeFirst()");
        if (this.presenceCursor != null) {
            this.presenceCursor.beforeFirst();
            return;
        }
        this.uuidCursor.beforeFirst();
        this.setAvailable(false);
    }

    public void afterLast() throws Exception {
        this.checkNotClosed("afterLast()");
        if (this.presenceCursor != null) {
            this.presenceCursor.afterLast();
            return;
        }
        this.uuidCursor.afterLast();
        this.setAvailable(false);
    }

    public boolean first() throws Exception {
        this.checkNotClosed("first()");
        if (this.presenceCursor != null) {
            return this.presenceCursor.first();
        }
        this.beforeFirst();
        return this.next();
    }

    public boolean last() throws Exception {
        this.checkNotClosed("last()");
        if (this.presenceCursor != null) {
            return this.presenceCursor.last();
        }
        this.afterLast();
        return this.previous();
    }

    public boolean previous() throws Exception {
        this.checkNotClosed("previous()");
        if (this.presenceCursor != null) {
            return this.presenceCursor.previous();
        }
        while (this.uuidCursor.previous()) {
            this.checkNotClosed("previous()");
            IndexEntry candidate = (IndexEntry)this.uuidCursor.get();
            if (!this.presenceEvaluator.evaluate(candidate)) continue;
            return this.setAvailable(true);
        }
        return this.setAvailable(false);
    }

    public boolean next() throws Exception {
        this.checkNotClosed("next()");
        if (this.presenceCursor != null) {
            return this.presenceCursor.next();
        }
        while (this.uuidCursor.next()) {
            this.checkNotClosed("next()");
            IndexEntry candidate = (IndexEntry)this.uuidCursor.get();
            if (!this.presenceEvaluator.evaluate(candidate)) continue;
            this.prefetched = candidate;
            return this.setAvailable(true);
        }
        return this.setAvailable(false);
    }

    public IndexEntry<String, ID> get() throws Exception {
        this.checkNotClosed("get()");
        if (this.presenceCursor != null) {
            if (this.presenceCursor.available()) {
                return (IndexEntry)this.presenceCursor.get();
            }
            throw new InvalidCursorPositionException(I18n.err((I18n)I18n.ERR_708, (Object[])new Object[0]));
        }
        if (this.available()) {
            if (this.prefetched == null) {
                this.prefetched = (IndexEntry)this.uuidCursor.get();
            }
            this.prefetched.setKey(this.presenceEvaluator.getAttributeType().getOid());
            return this.prefetched;
        }
        throw new InvalidCursorPositionException(I18n.err((I18n)I18n.ERR_708, (Object[])new Object[0]));
    }

    public void close() throws Exception {
        LOG_CURSOR.debug("Closing PresenceCursor {}", (Object)this);
        super.close();
        if (this.presenceCursor != null) {
            this.presenceCursor.close();
        } else {
            this.uuidCursor.close();
        }
    }

    public void close(Exception cause) throws Exception {
        LOG_CURSOR.debug("Closing PresenceCursor {}", (Object)this);
        super.close(cause);
        if (this.presenceCursor != null) {
            this.presenceCursor.close(cause);
        } else {
            this.uuidCursor.close(cause);
        }
    }
}

