/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm;

import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.AbstractIndexCursor;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.shared.ldap.model.cursor.InvalidCursorPositionException;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingletonIndexCursor<V, ID>
extends AbstractIndexCursor<V, Entry, ID> {
    private static final Logger LOG_CURSOR = LoggerFactory.getLogger((String)"CURSOR");
    private boolean beforeFirst = true;
    private boolean afterLast;
    private boolean onSingleton;
    private final IndexEntry<V, ID> singleton;

    public SingletonIndexCursor(IndexEntry<V, ID> singleton) {
        LOG_CURSOR.debug("Creating SingletonIndexCursor {}", (Object)this);
        this.singleton = singleton;
    }

    @Override
    protected String getUnsupportedMessage() {
        return "Unsupported operation";
    }

    @Override
    public boolean available() {
        return this.onSingleton;
    }

    public void beforeFirst() throws Exception {
        this.checkNotClosed("()");
        this.beforeFirst = true;
        this.afterLast = false;
        this.onSingleton = false;
    }

    public void afterLast() throws Exception {
        this.checkNotClosed("()");
        this.beforeFirst = false;
        this.afterLast = true;
        this.onSingleton = false;
    }

    public boolean first() throws Exception {
        this.checkNotClosed("()");
        this.beforeFirst = false;
        this.onSingleton = true;
        this.afterLast = false;
        return true;
    }

    public boolean last() throws Exception {
        this.checkNotClosed("()");
        this.beforeFirst = false;
        this.onSingleton = true;
        this.afterLast = false;
        return true;
    }

    public boolean isFirst() throws Exception {
        this.checkNotClosed("()");
        return this.onSingleton;
    }

    public boolean isLast() throws Exception {
        this.checkNotClosed("()");
        return this.onSingleton;
    }

    public boolean isAfterLast() throws Exception {
        this.checkNotClosed("()");
        return this.afterLast;
    }

    public boolean isBeforeFirst() throws Exception {
        this.checkNotClosed("()");
        return this.beforeFirst;
    }

    public boolean previous() throws Exception {
        this.checkNotClosed("()");
        if (this.beforeFirst) {
            return false;
        }
        if (this.afterLast) {
            this.beforeFirst = false;
            this.onSingleton = true;
            this.afterLast = false;
            return true;
        }
        this.beforeFirst = true;
        this.onSingleton = false;
        this.afterLast = false;
        return false;
    }

    public boolean next() throws Exception {
        this.checkNotClosed("()");
        if (this.beforeFirst) {
            this.beforeFirst = false;
            this.onSingleton = true;
            this.afterLast = false;
            return true;
        }
        if (this.afterLast) {
            return false;
        }
        this.beforeFirst = false;
        this.onSingleton = false;
        this.afterLast = true;
        return false;
    }

    public IndexEntry<V, ID> get() throws Exception {
        this.checkNotClosed("()");
        if (this.onSingleton) {
            return this.singleton;
        }
        if (this.beforeFirst) {
            throw new InvalidCursorPositionException(I18n.err((I18n)I18n.ERR_705, (Object[])new Object[0]));
        }
        throw new InvalidCursorPositionException(I18n.err((I18n)I18n.ERR_706, (Object[])new Object[0]));
    }

    public void close() throws Exception {
        LOG_CURSOR.debug("Closing SingletonIndexCursor {}", (Object)this);
        super.close();
    }

    public void close(Exception cause) throws Exception {
        LOG_CURSOR.debug("Closing SingletonIndexCursor {}", (Object)this);
        super.close(cause);
    }
}

