/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree;

import java.util.Iterator;
import org.apache.directory.server.core.partition.impl.btree.AbstractBTreePartition;
import org.apache.directory.server.xdbm.IndexCursor;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.model.cursor.ClosureMonitor;
import org.apache.directory.shared.ldap.model.cursor.Cursor;
import org.apache.directory.shared.ldap.model.cursor.CursorIterator;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntryCursorAdaptor<ID extends Comparable<ID>>
implements Cursor<Entry> {
    private static final Logger LOG_CURSOR = LoggerFactory.getLogger((String)"CURSOR");
    private final AbstractBTreePartition<ID> db;
    private final IndexCursor<ID, Entry, ID> indexCursor;

    public EntryCursorAdaptor(AbstractBTreePartition<ID> db, IndexCursor<ID, Entry, ID> indexCursor) {
        LOG_CURSOR.debug("Creating EntryCursorAdaptor {}", (Object)this);
        this.db = db;
        this.indexCursor = indexCursor;
    }

    public void after(Entry element) throws Exception {
        throw new UnsupportedOperationException();
    }

    public void afterLast() throws Exception {
        this.indexCursor.afterLast();
    }

    public boolean available() {
        return this.indexCursor.available();
    }

    public void before(Entry element) throws Exception {
        throw new UnsupportedOperationException();
    }

    public void beforeFirst() throws Exception {
        this.indexCursor.beforeFirst();
    }

    public final void setClosureMonitor(ClosureMonitor monitor) {
        this.indexCursor.setClosureMonitor(monitor);
    }

    public void close() throws Exception {
        LOG_CURSOR.debug("Closing EntryCursorAdaptor {}", (Object)this);
        this.indexCursor.close();
    }

    public void close(Exception cause) throws Exception {
        LOG_CURSOR.debug("Closing EntryCursorAdaptor {}", (Object)this);
        this.indexCursor.close(cause);
    }

    public boolean first() throws Exception {
        return this.indexCursor.first();
    }

    public Entry get() throws Exception {
        IndexEntry indexEntry = (IndexEntry)this.indexCursor.get();
        if (indexEntry.getEntry() == null) {
            indexEntry.setEntry(this.db.lookup((Comparable)indexEntry.getId()));
        }
        return indexEntry.getEntry();
    }

    public boolean isClosed() throws Exception {
        return this.indexCursor.isClosed();
    }

    public boolean last() throws Exception {
        return this.indexCursor.last();
    }

    public boolean next() throws Exception {
        return this.indexCursor.next();
    }

    public boolean previous() throws Exception {
        return this.indexCursor.previous();
    }

    public Iterator<Entry> iterator() {
        return new CursorIterator((Cursor)this);
    }

    public boolean isAfterLast() throws Exception {
        throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_02014_UNSUPPORTED_OPERATION, (Object[])new Object[]{this.getClass().getName().concat(".").concat("isAfterLast()")}));
    }

    public boolean isBeforeFirst() throws Exception {
        throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_02014_UNSUPPORTED_OPERATION, (Object[])new Object[]{this.getClass().getName().concat(".").concat("isBeforeFirst()")}));
    }

    public boolean isFirst() throws Exception {
        throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_02014_UNSUPPORTED_OPERATION, (Object[])new Object[]{this.getClass().getName().concat(".").concat("isFirst()")}));
    }

    public boolean isLast() throws Exception {
        throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_02014_UNSUPPORTED_OPERATION, (Object[])new Object[]{this.getClass().getName().concat(".").concat("isLast()")}));
    }
}

