/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.naming.directory.SearchControls;
import org.apache.directory.server.core.api.entry.ClonedServerEntry;
import org.apache.directory.server.core.api.filtering.BaseEntryFilteringCursor;
import org.apache.directory.server.core.api.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.api.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.api.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.api.interceptor.context.HasEntryOperationContext;
import org.apache.directory.server.core.api.interceptor.context.ListOperationContext;
import org.apache.directory.server.core.api.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.api.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.api.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.api.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.api.interceptor.context.SearchingOperationContext;
import org.apache.directory.server.core.api.interceptor.context.UnbindOperationContext;
import org.apache.directory.server.core.api.partition.AbstractPartition;
import org.apache.directory.server.core.partition.impl.btree.EntryCursorAdaptor;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.GenericIndex;
import org.apache.directory.server.xdbm.Index;
import org.apache.directory.server.xdbm.IndexCursor;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.IndexNotFoundException;
import org.apache.directory.server.xdbm.MasterTable;
import org.apache.directory.server.xdbm.ParentIdAndRdn;
import org.apache.directory.server.xdbm.Store;
import org.apache.directory.server.xdbm.search.Optimizer;
import org.apache.directory.server.xdbm.search.SearchEngine;
import org.apache.directory.shared.ldap.model.entry.Attribute;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.entry.Modification;
import org.apache.directory.shared.ldap.model.entry.Value;
import org.apache.directory.shared.ldap.model.exception.LdapAliasDereferencingException;
import org.apache.directory.shared.ldap.model.exception.LdapAliasException;
import org.apache.directory.shared.ldap.model.exception.LdapContextNotEmptyException;
import org.apache.directory.shared.ldap.model.exception.LdapEntryAlreadyExistsException;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.exception.LdapNoSuchObjectException;
import org.apache.directory.shared.ldap.model.exception.LdapOperationErrorException;
import org.apache.directory.shared.ldap.model.exception.LdapSchemaViolationException;
import org.apache.directory.shared.ldap.model.exception.LdapUnwillingToPerformException;
import org.apache.directory.shared.ldap.model.filter.ExprNode;
import org.apache.directory.shared.ldap.model.message.AliasDerefMode;
import org.apache.directory.shared.ldap.model.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.model.name.Ava;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.name.Rdn;
import org.apache.directory.shared.ldap.model.schema.AttributeType;
import org.apache.directory.shared.ldap.model.schema.MatchingRule;
import org.apache.directory.shared.ldap.model.schema.SchemaManager;
import org.apache.directory.shared.ldap.model.schema.UsageEnum;
import org.apache.directory.shared.util.Strings;
import org.apache.directory.shared.util.exception.MultiException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBTreePartition<ID extends Comparable<ID>>
extends AbstractPartition
implements Store<Entry, ID> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractBTreePartition.class);
    protected SearchEngine<Entry, ID> searchEngine;
    protected Optimizer optimizer;
    protected boolean optimizerEnabled = true;
    public static final int DEFAULT_CACHE_SIZE = 10000;
    protected int cacheSize = -1;
    protected AtomicBoolean isSyncOnWrite = new AtomicBoolean(true);
    private volatile ID suffixId;
    protected URI partitionPath;
    private Set<Index<?, Entry, ID>> indexedAttributes;
    protected MasterTable<ID, Entry> master;
    protected Map<String, Index<?, Entry, ID>> userIndices = new HashMap();
    protected Map<String, Index<?, Entry, ID>> systemIndices = new HashMap();
    protected Index<ParentIdAndRdn<ID>, Entry, ID> rdnIdx;
    protected Index<String, Entry, ID> objectClassIdx;
    protected Index<ID, Entry, ID> oneLevelIdx;
    protected Index<ID, Entry, ID> subLevelIdx;
    protected Index<String, Entry, ID> presenceIdx;
    protected Index<String, Entry, ID> entryUuidIdx;
    protected Index<String, Entry, ID> entryCsnIdx;
    protected Index<String, Entry, ID> aliasIdx;
    protected Index<ID, Entry, ID> subAliasIdx;
    protected Index<ID, Entry, ID> oneAliasIdx;
    protected AttributeType OBJECT_CLASS_AT;
    protected AttributeType ENTRY_CSN_AT;
    protected AttributeType ENTRY_UUID_AT;
    protected AttributeType ALIASED_OBJECT_NAME_AT;

    protected AbstractBTreePartition(SchemaManager schemaManager) {
        this.schemaManager = schemaManager;
        this.indexedAttributes = new HashSet();
        this.OBJECT_CLASS_AT = schemaManager.getAttributeType("objectClass");
        this.ALIASED_OBJECT_NAME_AT = schemaManager.getAttributeType("aliasedObjectName");
        this.ENTRY_CSN_AT = schemaManager.getAttributeType("entryCSN");
        this.ENTRY_UUID_AT = schemaManager.getAttributeType("entryUUID");
    }

    @Override
    public int getCacheSize() {
        return this.cacheSize;
    }

    @Override
    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    public boolean isOptimizerEnabled() {
        return this.optimizerEnabled;
    }

    public void setOptimizerEnabled(boolean optimizerEnabled) {
        this.optimizerEnabled = optimizerEnabled;
    }

    @Override
    public void setPartitionPath(URI partitionPath) {
        this.checkInitialized("partitionPath");
        this.partitionPath = partitionPath;
    }

    @Override
    public boolean isSyncOnWrite() {
        return this.isSyncOnWrite.get();
    }

    @Override
    public void setSyncOnWrite(boolean isSyncOnWrite) {
        this.checkInitialized("syncOnWrite");
        this.isSyncOnWrite.set(isSyncOnWrite);
    }

    protected void setupSystemIndices() throws Exception {
        GenericIndex index;
        if (this.getPresenceIndex() == null) {
            index = new GenericIndex("1.3.6.1.4.1.18060.0.4.1.2.3");
            index.setWkDirPath(this.partitionPath);
            this.addIndex(index);
        }
        if (this.getOneLevelIndex() == null) {
            index = new GenericIndex("1.3.6.1.4.1.18060.0.4.1.2.4");
            index.setWkDirPath(this.partitionPath);
            this.addIndex(index);
        }
        if (this.getSubLevelIndex() == null) {
            index = new GenericIndex("1.3.6.1.4.1.18060.0.4.1.2.43");
            index.setWkDirPath(this.partitionPath);
            this.addIndex(index);
        }
        if (this.getRdnIndex() == null) {
            index = new GenericIndex("1.3.6.1.4.1.18060.0.4.1.2.50");
            index.setWkDirPath(this.partitionPath);
            this.addIndex(index);
        }
        if (this.getAliasIndex() == null) {
            index = new GenericIndex("1.3.6.1.4.1.18060.0.4.1.2.7");
            index.setWkDirPath(this.partitionPath);
            this.addIndex(index);
        }
        if (this.getOneAliasIndex() == null) {
            index = new GenericIndex("1.3.6.1.4.1.18060.0.4.1.2.5");
            index.setWkDirPath(this.partitionPath);
            this.addIndex(index);
        }
        if (this.getSubAliasIndex() == null) {
            index = new GenericIndex("1.3.6.1.4.1.18060.0.4.1.2.6");
            index.setWkDirPath(this.partitionPath);
            this.addIndex(index);
        }
        if (this.getObjectClassIndex() == null) {
            index = new GenericIndex("2.5.4.0");
            index.setWkDirPath(this.partitionPath);
            this.addIndex(index);
        }
        if (this.getEntryUuidIndex() == null) {
            index = new GenericIndex("1.3.6.1.1.16.4");
            index.setWkDirPath(this.partitionPath);
            this.addIndex(index);
        }
        if (this.getEntryCsnIndex() == null) {
            index = new GenericIndex("1.3.6.1.4.1.4203.666.1.7");
            index.setWkDirPath(this.partitionPath);
            this.addIndex(index);
        }
        for (String oid : this.systemIndices.keySet()) {
            Index<?, Entry, ID> index2 = this.systemIndices.get(oid);
            index2 = this.convertAndInit(index2);
            this.systemIndices.put(oid, index2);
        }
        this.rdnIdx = this.systemIndices.get("1.3.6.1.4.1.18060.0.4.1.2.50");
        this.presenceIdx = this.systemIndices.get("1.3.6.1.4.1.18060.0.4.1.2.3");
        this.oneLevelIdx = this.systemIndices.get("1.3.6.1.4.1.18060.0.4.1.2.4");
        this.subLevelIdx = this.systemIndices.get("1.3.6.1.4.1.18060.0.4.1.2.43");
        this.aliasIdx = this.systemIndices.get("1.3.6.1.4.1.18060.0.4.1.2.7");
        this.oneAliasIdx = this.systemIndices.get("1.3.6.1.4.1.18060.0.4.1.2.5");
        this.subAliasIdx = this.systemIndices.get("1.3.6.1.4.1.18060.0.4.1.2.6");
        this.objectClassIdx = this.systemIndices.get("2.5.4.0");
        this.entryUuidIdx = this.systemIndices.get("1.3.6.1.1.16.4");
        this.entryCsnIdx = this.systemIndices.get("1.3.6.1.4.1.4203.666.1.7");
    }

    protected void setupUserIndices() throws Exception {
        HashMap tmp = new HashMap();
        for (String oid : this.userIndices.keySet()) {
            AttributeType attributeType = this.schemaManager.lookupAttributeTypeRegistry(oid);
            MatchingRule mr = attributeType.getEquality();
            if (mr != null) {
                Index<?, Entry, ID> index = this.userIndices.get(oid);
                index = this.convertAndInit(index);
                tmp.put(oid, index);
                continue;
            }
            LOG.error(I18n.err((I18n)I18n.ERR_4, (Object[])new Object[]{attributeType.getName()}));
        }
        this.userIndices = tmp;
    }

    public SearchEngine<Entry, ID> getSearchEngine() {
        return this.searchEngine;
    }

    @Override
    public abstract ID getDefaultId();

    @Override
    public abstract ID getRootId();

    protected abstract Index<?, Entry, ID> convertAndInit(Index<?, Entry, ID> var1) throws Exception;

    @Override
    public URI getPartitionPath() {
        return this.partitionPath;
    }

    protected void doDestroy() throws LdapException, Exception {
        LOG.debug("destroy() called on store for {}", (Object)this.suffixDn);
        if (!this.initialized) {
            return;
        }
        this.initialized = false;
        MultiException errors = new MultiException(I18n.err((I18n)I18n.ERR_577, (Object[])new Object[0]));
        for (Index<?, Entry, ID> index : this.userIndices.values()) {
            try {
                index.close();
                LOG.debug("Closed {} user index for {} partition.", (Object)index.getAttributeId(), (Object)this.suffixDn);
            }
            catch (Throwable t) {
                LOG.error(I18n.err((I18n)I18n.ERR_124, (Object[])new Object[0]), t);
                errors.addThrowable(t);
            }
        }
        for (Index<?, Entry, ID> index : this.systemIndices.values()) {
            try {
                index.close();
                LOG.debug("Closed {} system index for {} partition.", (Object)index.getAttributeId(), (Object)this.suffixDn);
            }
            catch (Throwable t) {
                LOG.error(I18n.err((I18n)I18n.ERR_124, (Object[])new Object[0]), t);
                errors.addThrowable(t);
            }
        }
        try {
            this.master.close();
            LOG.debug(I18n.err((I18n)I18n.ERR_125, (Object[])new Object[]{this.suffixDn}));
        }
        catch (Throwable t) {
            LOG.error(I18n.err((I18n)I18n.ERR_126, (Object[])new Object[0]), t);
            errors.addThrowable(t);
        }
        if (errors.size() > 0) {
            throw errors;
        }
    }

    protected void doInit() throws Exception {
        this.setupSystemIndices();
        this.setupUserIndices();
    }

    public void add(AddOperationContext addContext) throws LdapException {
        try {
            Entry entry = ((ClonedServerEntry)addContext.getEntry()).getClonedEntry();
            Dn entryDn = entry.getDn();
            if (this.getEntryId(entryDn) != null) {
                LdapEntryAlreadyExistsException ne = new LdapEntryAlreadyExistsException(I18n.err((I18n)I18n.ERR_250_ENTRY_ALREADY_EXISTS, (Object[])new Object[]{entryDn.getName()}));
                throw ne;
            }
            Object parentId = null;
            Dn parentDn = null;
            ParentIdAndRdn<Object> key = null;
            if (entryDn.equals((Object)this.suffixDn)) {
                parentId = this.getRootId();
                key = new ParentIdAndRdn<Object>(parentId, this.suffixDn.getRdns());
            } else {
                parentDn = entryDn.getParent();
                parentId = this.getEntryId(parentDn);
                key = new ParentIdAndRdn<Object>(parentId, entryDn.getRdn());
            }
            if (parentId == null) {
                throw new LdapNoSuchObjectException(I18n.err((I18n)I18n.ERR_216_ID_FOR_PARENT_NOT_FOUND, (Object[])new Object[]{parentDn}));
            }
            Comparable id = (Comparable)this.master.getNextId(entry);
            this.rdnIdx.add(key, id);
            Attribute objectClass = entry.get(this.OBJECT_CLASS_AT);
            if (objectClass == null) {
                String msg = I18n.err((I18n)I18n.ERR_217, (Object[])new Object[]{entryDn.getName(), entry});
                ResultCodeEnum rc = ResultCodeEnum.OBJECT_CLASS_VIOLATION;
                LdapSchemaViolationException e = new LdapSchemaViolationException(rc, msg);
                throw e;
            }
            for (Value value : objectClass) {
                this.objectClassIdx.add(value.getString(), id);
            }
            if (objectClass.contains(new String[]{"alias"})) {
                Attribute aliasAttr = entry.get(this.ALIASED_OBJECT_NAME_AT);
                this.addAliasIndices(id, entryDn, aliasAttr.getString());
            }
            this.oneLevelIdx.add((Comparable)parentId, id);
            Object tempId = parentId;
            while (tempId != null && !tempId.equals(this.getRootId()) && !tempId.equals(this.getSuffixId())) {
                this.subLevelIdx.add((Comparable)tempId, id);
                tempId = this.getParentId(tempId);
            }
            this.subLevelIdx.add(id, id);
            Attribute entryCsn = entry.get(this.ENTRY_CSN_AT);
            if (entryCsn == null) {
                String msg = I18n.err((I18n)I18n.ERR_219, (Object[])new Object[]{entryDn.getName(), entry});
                throw new LdapSchemaViolationException(ResultCodeEnum.OBJECT_CLASS_VIOLATION, msg);
            }
            this.entryCsnIdx.add(entryCsn.getString(), id);
            Attribute entryUuid = entry.get(this.ENTRY_UUID_AT);
            if (entryUuid == null) {
                String msg = I18n.err((I18n)I18n.ERR_220, (Object[])new Object[]{entryDn.getName(), entry});
                throw new LdapSchemaViolationException(ResultCodeEnum.OBJECT_CLASS_VIOLATION, msg);
            }
            this.entryUuidIdx.add(entryUuid.getString(), id);
            for (Attribute attribute : entry) {
                AttributeType attributeType = attribute.getAttributeType();
                String attributeOid = attributeType.getOid();
                if (!this.hasUserIndexOn(attributeType)) continue;
                Index<?, Entry, Comparable> idx = this.getUserIndex(attributeType);
                for (Value value : attribute) {
                    idx.add(value.getValue(), id);
                }
                this.presenceIdx.add(attributeOid, id);
            }
            entry.put("entryParentId", new String[]{parentId.toString()});
            this.master.put(id, entry);
            if (this.isSyncOnWrite.get()) {
                this.sync();
            }
        }
        catch (LdapException le) {
            throw le;
        }
        catch (Exception e) {
            throw new LdapException((Throwable)e);
        }
    }

    @Override
    public void delete(DeleteOperationContext deleteContext) throws LdapException {
        Dn dn = deleteContext.getDn();
        ID id = this.getEntryId(dn);
        if (id == null) {
            throw new LdapNoSuchObjectException(I18n.err((I18n)I18n.ERR_699, (Object[])new Object[]{dn}));
        }
        if (this.getChildCount(id) > 0) {
            LdapContextNotEmptyException cnee = new LdapContextNotEmptyException(I18n.err((I18n)I18n.ERR_700, (Object[])new Object[]{dn}));
            throw cnee;
        }
        this.delete(id);
    }

    @Override
    public void delete(ID id) throws LdapException {
        try {
            Entry entry = (Entry)this.master.get(id);
            if (entry == null) {
                throw new LdapNoSuchObjectException("Cannot find an entry for ID " + id);
            }
            Attribute objectClass = entry.get(this.OBJECT_CLASS_AT);
            if (objectClass.contains(new String[]{"alias"})) {
                this.dropAliasIndices(id);
            }
            for (Value value : objectClass) {
                this.objectClassIdx.drop(value.getString(), id);
            }
            this.rdnIdx.drop(id);
            this.oneLevelIdx.drop(id);
            this.subLevelIdx.drop(id);
            this.entryCsnIdx.drop(id);
            this.entryUuidIdx.drop(id);
            for (Attribute attribute : entry) {
                AttributeType attributeType = attribute.getAttributeType();
                String attributeOid = attributeType.getOid();
                if (!this.hasUserIndexOn(attributeType)) continue;
                Index<?, Entry, ID> index = this.getUserIndex(attributeType);
                for (Value value : attribute) {
                    index.drop(value.getValue(), id);
                }
                this.presenceIdx.drop(attributeOid, id);
            }
            this.master.remove(id);
            if (id.equals(this.getDefaultId())) {
                this.master.resetCounter();
            }
            if (this.isSyncOnWrite.get()) {
                this.sync();
            }
        }
        catch (Exception e) {
            throw new LdapOperationErrorException(e.getMessage(), (Throwable)e);
        }
    }

    public EntryFilteringCursor list(ListOperationContext listContext) throws LdapException {
        return new BaseEntryFilteringCursor(new EntryCursorAdaptor<ID>(this, this.list(this.getEntryId(listContext.getDn()))), (SearchingOperationContext)listContext);
    }

    @Override
    public final IndexCursor<ID, Entry, ID> list(ID id) throws LdapException {
        try {
            IndexCursor<ID, Entry, ID> cursor = this.oneLevelIdx.forwardCursor(id);
            cursor.beforeValue(id, null);
            return cursor;
        }
        catch (Exception e) {
            throw new LdapOperationErrorException(e.getMessage(), (Throwable)e);
        }
    }

    public EntryFilteringCursor search(SearchOperationContext searchContext) throws LdapException {
        try {
            SearchControls searchCtls = searchContext.getSearchControls();
            Dn dn = searchContext.getDn();
            AliasDerefMode derefMode = searchContext.getAliasDerefMode();
            ExprNode filter = searchContext.getFilter();
            IndexCursor<ID, Entry, ID> underlying = this.searchEngine.cursor(dn, derefMode, filter, searchCtls);
            return new BaseEntryFilteringCursor(new EntryCursorAdaptor<ID>(this, underlying), (SearchingOperationContext)searchContext);
        }
        catch (LdapException le) {
            throw le;
        }
        catch (Exception e) {
            throw new LdapOperationErrorException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Entry lookup(LookupOperationContext lookupContext) throws LdapException {
        ID id = this.getEntryId(lookupContext.getDn());
        if (id == null) {
            return null;
        }
        Entry entry = this.lookup(id);
        if (lookupContext.hasNoAttribute() && (lookupContext.getAttrsId() == null || lookupContext.getAttrsId().size() == 0)) {
            entry.clear();
            return entry;
        }
        if (lookupContext.hasAllUser()) {
            if (lookupContext.hasAllOperational()) {
                return entry;
            }
            for (Attribute attribute : ((ClonedServerEntry)entry).getOriginalEntry().getAttributes()) {
                AttributeType attributeType = attribute.getAttributeType();
                String oid = attributeType.getOid();
                if (attributeType.getUsage() == UsageEnum.USER_APPLICATIONS || lookupContext.getAttrsId().contains(oid)) continue;
                entry.removeAttributes(new AttributeType[]{attributeType});
            }
        } else if (lookupContext.hasAllOperational()) {
            for (Attribute attribute : ((ClonedServerEntry)entry).getOriginalEntry().getAttributes()) {
                AttributeType attributeType = attribute.getAttributeType();
                if (attributeType.getUsage() != UsageEnum.USER_APPLICATIONS) continue;
                entry.removeAttributes(new AttributeType[]{attributeType});
            }
        } else if (lookupContext.getAttrsId().size() == 0) {
            for (Attribute attribute : ((ClonedServerEntry)entry).getOriginalEntry().getAttributes()) {
                AttributeType attributeType = attribute.getAttributeType();
                if (attributeType.getUsage() == UsageEnum.USER_APPLICATIONS) continue;
                entry.removeAttributes(new AttributeType[]{attributeType});
            }
        } else {
            for (Attribute attribute : ((ClonedServerEntry)entry).getOriginalEntry().getAttributes()) {
                AttributeType attributeType = attribute.getAttributeType();
                String oid = attributeType.getOid();
                if (lookupContext.getAttrsId().contains(oid)) continue;
                entry.removeAttributes(new AttributeType[]{attributeType});
            }
        }
        return entry;
    }

    @Override
    public Entry lookup(ID id) throws LdapException {
        try {
            Entry entry = (Entry)this.master.get(id);
            if (entry != null) {
                Dn dn = this.buildEntryDn(id);
                entry.setDn(dn);
                return new ClonedServerEntry(entry);
            }
            return null;
        }
        catch (Exception e) {
            throw new LdapOperationErrorException(e.getMessage(), (Throwable)e);
        }
    }

    public void modify(ModifyOperationContext modifyContext) throws LdapException {
        try {
            Entry modifiedEntry = this.modify(modifyContext.getDn(), modifyContext.getModItems().toArray(new Modification[0]));
            modifyContext.setAlteredEntry(modifiedEntry);
        }
        catch (Exception e) {
            throw new LdapOperationErrorException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public final synchronized Entry modify(Dn dn, Modification ... mods) throws Exception {
        ID id = this.getEntryId(dn);
        Entry entry = (Entry)this.master.get(id);
        block5: for (Modification mod : mods) {
            Attribute attrMods = mod.getAttribute();
            switch (mod.getOperation()) {
                case ADD_ATTRIBUTE: {
                    this.modifyAdd(id, entry, attrMods);
                    continue block5;
                }
                case REMOVE_ATTRIBUTE: {
                    this.modifyRemove(id, entry, attrMods);
                    continue block5;
                }
                case REPLACE_ATTRIBUTE: {
                    this.modifyReplace(id, entry, attrMods);
                    continue block5;
                }
                default: {
                    throw new LdapException(I18n.err((I18n)I18n.ERR_221, (Object[])new Object[0]));
                }
            }
        }
        this.updateCsnIndex(entry, id);
        this.master.put(id, entry);
        if (this.isSyncOnWrite.get()) {
            this.sync();
        }
        return entry;
    }

    private void modifyAdd(ID id, Entry entry, Attribute mods) throws Exception {
        if (entry instanceof ClonedServerEntry) {
            throw new Exception(I18n.err((I18n)I18n.ERR_215, (Object[])new Object[0]));
        }
        String modsOid = this.schemaManager.getAttributeTypeRegistry().getOidByName(mods.getId());
        AttributeType attributeType = mods.getAttributeType();
        if (modsOid.equals("2.5.4.0")) {
            for (Value value : mods) {
                this.objectClassIdx.add(value.getString(), id);
            }
        } else if (this.hasUserIndexOn(attributeType)) {
            Index<?, Entry, ID> index = this.getUserIndex(attributeType);
            for (Value value : mods) {
                index.add(value.getValue(), id);
            }
            if (!this.presenceIdx.forward(modsOid, id)) {
                this.presenceIdx.add(modsOid, id);
            }
        }
        for (Value value : mods) {
            entry.add(mods.getAttributeType(), new Value[]{value});
        }
        if (modsOid.equals("2.5.4.1")) {
            Dn ndn = this.getEntryDn(id);
            this.addAliasIndices(id, ndn, mods.getString());
        }
    }

    private void modifyReplace(ID id, Entry entry, Attribute mods) throws Exception {
        if (entry instanceof ClonedServerEntry) {
            throw new Exception(I18n.err((I18n)I18n.ERR_215, (Object[])new Object[0]));
        }
        String modsOid = this.schemaManager.getAttributeTypeRegistry().getOidByName(mods.getId());
        AttributeType attributeType = mods.getAttributeType();
        if (attributeType.equals((Object)this.OBJECT_CLASS_AT)) {
            if (this.objectClassIdx.reverse(id)) {
                this.objectClassIdx.drop(id);
            }
            for (Value value : mods) {
                this.objectClassIdx.add(value.getString(), id);
            }
        } else if (this.hasUserIndexOn(attributeType)) {
            Index<?, Entry, ID> index = this.getUserIndex(attributeType);
            if (index.reverse(id)) {
                index.drop(id);
            }
            for (Value value : mods) {
                index.add(value.getValue(), id);
            }
            if (null == index.reverseLookup(id)) {
                this.presenceIdx.drop(modsOid, id);
            }
        }
        String aliasAttributeOid = this.schemaManager.getAttributeTypeRegistry().getOidByName("aliasedObjectName");
        if (mods.getAttributeType().equals((Object)this.ALIASED_OBJECT_NAME_AT)) {
            this.dropAliasIndices(id);
        }
        if (mods.size() > 0) {
            entry.put(new Attribute[]{mods});
        } else {
            entry.remove(new Attribute[]{mods});
        }
        if (modsOid.equals(aliasAttributeOid) && mods.size() > 0) {
            Dn entryDn = this.getEntryDn(id);
            this.addAliasIndices(id, entryDn, mods.getString());
        }
    }

    private void modifyRemove(ID id, Entry entry, Attribute mods) throws Exception {
        if (entry instanceof ClonedServerEntry) {
            throw new Exception(I18n.err((I18n)I18n.ERR_215, (Object[])new Object[0]));
        }
        String modsOid = this.schemaManager.getAttributeTypeRegistry().getOidByName(mods.getId());
        AttributeType attributeType = mods.getAttributeType();
        if (attributeType.equals((Object)this.OBJECT_CLASS_AT)) {
            if (mods.size() == 0) {
                this.objectClassIdx.drop(id);
            } else {
                for (Value value : mods) {
                    this.objectClassIdx.drop(value.getString(), id);
                }
            }
        } else if (this.hasUserIndexOn(attributeType)) {
            Index<?, Entry, ID> index = this.getUserIndex(attributeType);
            if (mods.size() == 0) {
                index.drop(id);
            } else {
                for (Value value : mods) {
                    index.drop(value.getValue(), id);
                }
            }
            if (null == index.reverseLookup(id)) {
                this.presenceIdx.drop(modsOid, id);
            }
        }
        AttributeType attrType = this.schemaManager.lookupAttributeTypeRegistry(modsOid);
        if (mods.size() == 0) {
            entry.removeAttributes(new AttributeType[]{mods.getAttributeType()});
        } else {
            Attribute entryAttr = entry.get(mods.getAttributeType());
            for (Value value : mods) {
                entryAttr.remove(new Value[]{value});
            }
            if (entryAttr.size() == 0) {
                entry.removeAttributes(new String[]{entryAttr.getId()});
            }
        }
        if (mods.getAttributeType().equals((Object)this.ALIASED_OBJECT_NAME_AT)) {
            this.dropAliasIndices(id);
        }
    }

    public void move(MoveOperationContext moveContext) throws LdapException {
        if (moveContext.getNewSuperior().isDescendantOf(moveContext.getDn())) {
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, "cannot place an entry below itself");
        }
        try {
            Dn oldDn = moveContext.getDn();
            Dn newSuperior = moveContext.getNewSuperior();
            Dn newDn = moveContext.getNewDn();
            Entry modifiedEntry = moveContext.getModifiedEntry();
            this.move(oldDn, newSuperior, newDn, modifiedEntry);
        }
        catch (Exception e) {
            throw new LdapOperationErrorException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public final synchronized void move(Dn oldDn, Dn newSuperiorDn, Dn newDn, Entry modifiedEntry) throws Exception {
        ID newParentId = this.getEntryId(newSuperiorDn);
        if (newParentId == null) {
            LdapEntryAlreadyExistsException ne = new LdapEntryAlreadyExistsException(I18n.err((I18n)I18n.ERR_256_NO_SUCH_OBJECT, (Object[])new Object[]{newSuperiorDn.getName()}));
            throw ne;
        }
        ID newId = this.getEntryId(newDn);
        if (newId != null) {
            LdapEntryAlreadyExistsException ne = new LdapEntryAlreadyExistsException(I18n.err((I18n)I18n.ERR_250_ENTRY_ALREADY_EXISTS, (Object[])new Object[]{newSuperiorDn.getName()}));
            throw ne;
        }
        ID entryId = this.getEntryId(oldDn);
        ID oldParentId = this.getParentId(entryId);
        this.dropMovedAliasIndices(oldDn);
        this.oneLevelIdx.drop(oldParentId, entryId);
        this.oneLevelIdx.add(newParentId, entryId);
        this.updateSubLevelIndex(entryId, oldParentId, newParentId);
        this.rdnIdx.drop(entryId);
        ParentIdAndRdn<ID> key = new ParentIdAndRdn<ID>(newParentId, oldDn.getRdn());
        this.rdnIdx.add(key, entryId);
        String aliasTarget = this.aliasIdx.reverseLookup(entryId);
        if (null != aliasTarget) {
            this.addAliasIndices(entryId, this.buildEntryDn(entryId), aliasTarget);
        }
        if (modifiedEntry == null) {
            modifiedEntry = this.lookup(entryId);
        }
        modifiedEntry.put("entryParentId", new String[]{newParentId.toString()});
        this.master.put(entryId, modifiedEntry);
        if (this.isSyncOnWrite.get()) {
            this.sync();
        }
    }

    public void moveAndRename(MoveAndRenameOperationContext moveAndRenameContext) throws LdapException {
        if (moveAndRenameContext.getNewSuperiorDn().isDescendantOf(moveAndRenameContext.getDn())) {
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, "cannot place an entry below itself");
        }
        try {
            Dn oldDn = moveAndRenameContext.getDn();
            Dn newSuperiorDn = moveAndRenameContext.getNewSuperiorDn();
            Rdn newRdn = moveAndRenameContext.getNewRdn();
            boolean deleteOldRdn = moveAndRenameContext.getDeleteOldRdn();
            Entry modifiedEntry = moveAndRenameContext.getModifiedEntry();
            this.moveAndRename(oldDn, newSuperiorDn, newRdn, modifiedEntry, deleteOldRdn);
        }
        catch (LdapException le) {
            throw le;
        }
        catch (Exception e) {
            throw new LdapOperationErrorException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public final synchronized void moveAndRename(Dn oldDn, Dn newSuperiorDn, Rdn newRdn, Entry modifiedEntry, boolean deleteOldRdn) throws Exception {
        ID oldId = this.getEntryId(oldDn);
        if (oldId == null) {
            LdapNoSuchObjectException nse = new LdapNoSuchObjectException(I18n.err((I18n)I18n.ERR_256_NO_SUCH_OBJECT, (Object[])new Object[]{oldDn}));
            throw nse;
        }
        ID newSuperiorId = this.getEntryId(newSuperiorDn);
        if (newSuperiorId == null) {
            LdapNoSuchObjectException nse = new LdapNoSuchObjectException(I18n.err((I18n)I18n.ERR_256_NO_SUCH_OBJECT, (Object[])new Object[]{newSuperiorDn}));
            throw nse;
        }
        Dn newDn = newSuperiorDn.add(newRdn);
        ID newId = this.getEntryId(newDn);
        if (newId != null) {
            LdapEntryAlreadyExistsException ne = new LdapEntryAlreadyExistsException(I18n.err((I18n)I18n.ERR_250_ENTRY_ALREADY_EXISTS, (Object[])new Object[]{newSuperiorDn.getName()}));
            throw ne;
        }
        this.rename(oldDn, newRdn, deleteOldRdn, modifiedEntry);
        this.moveAndRename(oldDn, oldId, newSuperiorDn, newRdn, modifiedEntry);
        if (this.isSyncOnWrite.get()) {
            this.sync();
        }
    }

    private void moveAndRename(Dn oldDn, ID childId, Dn newSuperior, Rdn newRdn, Entry modifiedEntry) throws Exception {
        ID newParentId = this.getEntryId(newSuperior);
        ID oldParentId = this.getParentId(childId);
        this.dropMovedAliasIndices(oldDn);
        this.oneLevelIdx.drop(oldParentId, childId);
        this.oneLevelIdx.add(newParentId, childId);
        this.updateSubLevelIndex(childId, oldParentId, newParentId);
        this.rdnIdx.drop(childId);
        ParentIdAndRdn<ID> key = new ParentIdAndRdn<ID>(newParentId, newRdn);
        this.rdnIdx.add(key, childId);
        String aliasTarget = this.aliasIdx.reverseLookup(childId);
        if (null != aliasTarget) {
            this.addAliasIndices(childId, this.buildEntryDn(childId), aliasTarget);
        }
        if (modifiedEntry != null) {
            modifiedEntry.put("entryParentId", new String[]{newParentId.toString()});
            this.master.put(childId, modifiedEntry);
        }
    }

    public void rename(RenameOperationContext renameContext) throws LdapException {
        try {
            Dn oldDn = renameContext.getDn();
            Rdn newRdn = renameContext.getNewRdn();
            boolean deleteOldRdn = renameContext.getDeleteOldRdn();
            if (renameContext.getEntry() != null) {
                Entry modifiedEntry = renameContext.getModifiedEntry();
                this.rename(oldDn, newRdn, deleteOldRdn, modifiedEntry);
            } else {
                this.rename(oldDn, newRdn, deleteOldRdn, null);
            }
        }
        catch (Exception e) {
            throw new LdapOperationErrorException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public final synchronized void rename(Dn dn, Rdn newRdn, boolean deleteOldRdn, Entry entry) throws Exception {
        ID id = this.getEntryId(dn);
        if (entry == null) {
            entry = (Entry)this.master.get(id);
        }
        Dn updn = entry.getDn();
        newRdn.apply(this.schemaManager);
        for (Ava newAtav : newRdn) {
            String newNormType = newAtav.getNormType();
            Object newNormValue = newAtav.getNormValue().getValue();
            AttributeType newRdnAttrType = this.schemaManager.lookupAttributeTypeRegistry(newNormType);
            entry.add(newRdnAttrType, new Value[]{newAtav.getNormValue()});
            if (!this.hasUserIndexOn(newRdnAttrType)) continue;
            Index<?, Entry, ID> index = this.getUserIndex(newRdnAttrType);
            index.add(newNormValue, id);
            if (this.presenceIdx.forward(newNormType, id)) continue;
            this.presenceIdx.add(newNormType, id);
        }
        if (deleteOldRdn) {
            Rdn oldRdn = updn.getRdn();
            for (Ava oldAtav : oldRdn) {
                boolean mustRemove = true;
                for (Ava newAtav : newRdn) {
                    if (!oldAtav.equals((Object)newAtav)) continue;
                    mustRemove = false;
                    break;
                }
                if (!mustRemove) continue;
                String oldNormType = oldAtav.getNormType();
                String oldNormValue = oldAtav.getNormValue().getString();
                AttributeType oldRdnAttrType = this.schemaManager.lookupAttributeTypeRegistry(oldNormType);
                entry.remove(oldRdnAttrType, new String[]{oldNormValue});
                if (!this.hasUserIndexOn(oldRdnAttrType)) continue;
                Index<?, Entry, ID> index = this.getUserIndex(oldRdnAttrType);
                index.drop(oldNormValue, id);
                if (null != index.reverseLookup(id)) continue;
                this.presenceIdx.drop(oldNormType, id);
            }
        }
        ID parentId = this.getParentId(id);
        this.rdnIdx.drop(id);
        ParentIdAndRdn<ID> key = new ParentIdAndRdn<ID>(parentId, newRdn);
        this.rdnIdx.add(key, id);
        this.master.put(id, entry);
        if (this.isSyncOnWrite.get()) {
            this.sync();
        }
    }

    public final void unbind(UnbindOperationContext unbindContext) throws LdapException {
    }

    public boolean hasEntry(HasEntryOperationContext entryContext) throws LdapException {
        try {
            ID id = this.getEntryId(entryContext.getDn());
            Entry entry = this.lookup(id);
            return entry != null;
        }
        catch (LdapException e) {
            return false;
        }
    }

    private void updateCsnIndex(Entry entry, ID id) throws Exception {
        this.entryCsnIdx.drop(id);
        this.entryCsnIdx.add(entry.get("entryCSN").getString(), id);
    }

    private void updateSubLevelIndex(ID entryId, ID oldParentId, ID newParentId) throws Exception {
        ID tempId = oldParentId;
        ArrayList<ID> parentIds = new ArrayList<ID>();
        while (tempId != null && !tempId.equals(this.getRootId()) && !tempId.equals(this.getSuffixId())) {
            parentIds.add(tempId);
            tempId = this.getParentId(tempId);
        }
        IndexCursor<ID, Entry, ID> cursor = this.subLevelIdx.forwardCursor(entryId);
        ArrayList childIds = new ArrayList();
        childIds.add(entryId);
        while (cursor.next()) {
            childIds.add(((IndexEntry)cursor.get()).getId());
        }
        cursor.close();
        for (Comparable pid : parentIds) {
            for (Comparable cid : childIds) {
                this.subLevelIdx.drop(pid, cid);
            }
        }
        parentIds.clear();
        tempId = newParentId;
        while (tempId != null && !tempId.equals(this.getRootId()) && !tempId.equals(this.getSuffixId())) {
            parentIds.add(tempId);
            tempId = this.getParentId(tempId);
        }
        for (Comparable id : parentIds) {
            for (Comparable cid : childIds) {
                this.subLevelIdx.add(id, cid);
            }
        }
    }

    protected Dn buildEntryDn(ID id) throws Exception {
        ParentIdAndRdn<ID> cur;
        ID parentId = id;
        ID rootId = this.getRootId();
        StringBuilder upName = new StringBuilder();
        boolean isFirst = true;
        do {
            Rdn[] rdns;
            cur = this.rdnIdx.reverseLookup(parentId);
            for (Rdn rdn : rdns = cur.getRdns()) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    upName.append(',');
                }
                upName.append(rdn.getName());
            }
        } while (!(parentId = cur.getParentId()).equals(rootId));
        Dn dn = new Dn(this.schemaManager, new String[]{upName.toString()});
        return dn;
    }

    @Override
    public int count() throws Exception {
        return this.master.count();
    }

    @Override
    public final int getChildCount(ID id) throws LdapException {
        try {
            return this.oneLevelIdx.count(id);
        }
        catch (Exception e) {
            throw new LdapOperationErrorException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public final Dn getEntryDn(ID id) throws Exception {
        return this.buildEntryDn(id);
    }

    @Override
    public final ID getEntryId(Dn dn) throws LdapException {
        try {
            if (Dn.isNullOrEmpty((Dn)dn)) {
                return this.getRootId();
            }
            ParentIdAndRdn<ID> suffixKey = new ParentIdAndRdn<ID>(this.getRootId(), this.suffixDn.getRdns());
            Comparable currentId = (Comparable)this.rdnIdx.forwardLookup(suffixKey);
            for (int i = dn.size() - this.suffixDn.size(); i > 0; --i) {
                Rdn rdn = dn.getRdn(i - 1);
                ParentIdAndRdn<Comparable> currentRdn = new ParentIdAndRdn<Comparable>(currentId, rdn);
                if ((currentId = (Comparable)this.rdnIdx.forwardLookup(currentRdn)) == null) break;
            }
            return (ID)currentId;
        }
        catch (Exception e) {
            throw new LdapException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public ID getParentId(ID childId) throws Exception {
        ParentIdAndRdn<ID> key = this.rdnIdx.reverseLookup(childId);
        if (key == null) {
            return null;
        }
        return key.getParentId();
    }

    protected ID getSuffixId() throws Exception {
        if (this.suffixId == null) {
            ParentIdAndRdn<ID> key = new ParentIdAndRdn<ID>(this.getRootId(), this.suffixDn.getRdns());
            this.suffixId = (Comparable)this.rdnIdx.forwardLookup(key);
        }
        return this.suffixId;
    }

    @Override
    public void addIndex(Index<?, Entry, ID> index) throws Exception {
        this.checkInitialized("addIndex");
        AttributeType attributeType = this.schemaManager.lookupAttributeTypeRegistry(index.getAttributeId());
        if (attributeType == null) {
            throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_309, (Object[])new Object[]{index.getAttributeId()}));
        }
        String oid = attributeType.getOid();
        if (SYS_INDEX_OIDS.contains(oid)) {
            if (!this.systemIndices.containsKey(oid)) {
                this.systemIndices.put(oid, index);
            }
        } else if (!this.userIndices.containsKey(oid)) {
            this.userIndices.put(oid, index);
        }
    }

    public void addIndexedAttributes(Index<?, Entry, ID> ... indexes) {
        for (Index<?, Entry, ID> index : indexes) {
            this.indexedAttributes.add(index);
        }
    }

    public void setIndexedAttributes(Set<Index<?, Entry, ID>> indexedAttributes) {
        this.indexedAttributes = indexedAttributes;
    }

    public Set<Index<?, Entry, ID>> getIndexedAttributes() {
        return this.indexedAttributes;
    }

    @Override
    public Iterator<String> getUserIndices() {
        return this.userIndices.keySet().iterator();
    }

    @Override
    public Iterator<String> getSystemIndices() {
        return this.systemIndices.keySet().iterator();
    }

    @Override
    public Index<?, Entry, ID> getIndex(AttributeType attributeType) throws IndexNotFoundException {
        String id = attributeType.getOid();
        if (this.userIndices.containsKey(id)) {
            return this.userIndices.get(id);
        }
        if (this.systemIndices.containsKey(id)) {
            return this.systemIndices.get(id);
        }
        throw new IndexNotFoundException(I18n.err((I18n)I18n.ERR_3, (Object[])new Object[]{id, id}));
    }

    @Override
    public Index<?, Entry, ID> getUserIndex(AttributeType attributeType) throws IndexNotFoundException {
        if (attributeType == null) {
            throw new IndexNotFoundException(I18n.err((I18n)I18n.ERR_3, (Object[])new Object[]{attributeType, attributeType}));
        }
        String oid = attributeType.getOid();
        if (this.userIndices.containsKey(oid)) {
            return this.userIndices.get(oid);
        }
        throw new IndexNotFoundException(I18n.err((I18n)I18n.ERR_3, (Object[])new Object[]{attributeType, attributeType}));
    }

    @Override
    public Index<?, Entry, ID> getSystemIndex(AttributeType attributeType) throws IndexNotFoundException {
        if (attributeType == null) {
            throw new IndexNotFoundException(I18n.err((I18n)I18n.ERR_2, (Object[])new Object[]{attributeType, attributeType}));
        }
        String oid = attributeType.getOid();
        if (this.systemIndices.containsKey(oid)) {
            return this.systemIndices.get(oid);
        }
        throw new IndexNotFoundException(I18n.err((I18n)I18n.ERR_2, (Object[])new Object[]{attributeType, attributeType}));
    }

    @Override
    public Index<ID, Entry, ID> getOneLevelIndex() {
        return this.systemIndices.get("1.3.6.1.4.1.18060.0.4.1.2.4");
    }

    @Override
    public Index<ID, Entry, ID> getSubLevelIndex() {
        return this.systemIndices.get("1.3.6.1.4.1.18060.0.4.1.2.43");
    }

    @Override
    public Index<String, Entry, ID> getAliasIndex() {
        return this.systemIndices.get("1.3.6.1.4.1.18060.0.4.1.2.7");
    }

    @Override
    public Index<ID, Entry, ID> getOneAliasIndex() {
        return this.systemIndices.get("1.3.6.1.4.1.18060.0.4.1.2.5");
    }

    @Override
    public Index<ID, Entry, ID> getSubAliasIndex() {
        return this.systemIndices.get("1.3.6.1.4.1.18060.0.4.1.2.6");
    }

    @Override
    public Index<String, Entry, ID> getObjectClassIndex() {
        return this.systemIndices.get("2.5.4.0");
    }

    @Override
    public Index<String, Entry, ID> getEntryUuidIndex() {
        return this.systemIndices.get("1.3.6.1.1.16.4");
    }

    @Override
    public Index<String, Entry, ID> getEntryCsnIndex() {
        return this.systemIndices.get("1.3.6.1.4.1.4203.666.1.7");
    }

    @Override
    public Index<String, Entry, ID> getPresenceIndex() {
        return this.systemIndices.get("1.3.6.1.4.1.18060.0.4.1.2.3");
    }

    @Override
    public Index<ParentIdAndRdn<ID>, Entry, ID> getRdnIndex() {
        return this.systemIndices.get("1.3.6.1.4.1.18060.0.4.1.2.50");
    }

    @Override
    public boolean hasUserIndexOn(AttributeType attributeType) throws LdapException {
        return this.userIndices.containsKey(attributeType.getOid());
    }

    @Override
    public boolean hasSystemIndexOn(AttributeType attributeType) throws LdapException {
        return this.systemIndices.containsKey(attributeType.getOid());
    }

    @Override
    public boolean hasIndexOn(AttributeType attributeType) throws LdapException {
        return this.hasUserIndexOn(attributeType) || this.hasSystemIndexOn(attributeType);
    }

    protected void addAliasIndices(ID aliasId, Dn aliasDn, String aliasTarget) throws Exception {
        Dn normalizedAliasTargetDn = new Dn(this.schemaManager, new String[]{aliasTarget});
        if (!normalizedAliasTargetDn.isDescendantOf(this.suffixDn)) {
            String msg = I18n.err((I18n)I18n.ERR_225, (Object[])new Object[]{this.suffixDn.getName()});
            LdapAliasDereferencingException e = new LdapAliasDereferencingException(msg);
            throw e;
        }
        ID targetId = this.getEntryId(normalizedAliasTargetDn);
        if (null == targetId) {
            String msg = I18n.err((I18n)I18n.ERR_581, (Object[])new Object[]{aliasDn.getName(), aliasTarget});
            LdapAliasException e = new LdapAliasException(msg);
            throw e;
        }
        if (null != this.aliasIdx.reverseLookup(targetId)) {
            String msg = I18n.err((I18n)I18n.ERR_227, (Object[])new Object[0]);
            LdapAliasDereferencingException e = new LdapAliasDereferencingException(msg);
            throw e;
        }
        this.aliasIdx.add(normalizedAliasTargetDn.getNormName(), aliasId);
        Dn ancestorDn = aliasDn.getParent();
        ID ancestorId = this.getEntryId(ancestorDn);
        Dn normalizedAliasTargetParentDn = normalizedAliasTargetDn.getParent();
        if (!aliasDn.isDescendantOf(normalizedAliasTargetParentDn)) {
            this.oneAliasIdx.add(ancestorId, targetId);
        }
        while (!ancestorDn.equals((Object)this.suffixDn) && null != ancestorId) {
            if (!normalizedAliasTargetDn.isDescendantOf(ancestorDn)) {
                this.subAliasIdx.add(ancestorId, targetId);
            }
            ancestorDn = ancestorDn.getParent();
            ancestorId = this.getEntryId(ancestorDn);
        }
    }

    protected void dropAliasIndices(ID aliasId) throws Exception {
        String targetDn = this.aliasIdx.reverseLookup(aliasId);
        ID targetId = this.getEntryId(new Dn(this.schemaManager, new String[]{targetDn}));
        if (targetId == null) {
            return;
        }
        Dn aliasDn = this.getEntryDn(aliasId);
        Dn ancestorDn = aliasDn.getParent();
        ID ancestorId = this.getEntryId(ancestorDn);
        this.oneAliasIdx.drop(ancestorId, targetId);
        this.subAliasIdx.drop(ancestorId, targetId);
        while (!ancestorDn.equals((Object)this.suffixDn) && ancestorDn.size() > this.suffixDn.size()) {
            ancestorDn = ancestorDn.getParent();
            ancestorId = this.getEntryId(ancestorDn);
            this.subAliasIdx.drop(ancestorId, targetId);
        }
        this.aliasIdx.drop(aliasId);
    }

    protected void dropMovedAliasIndices(Dn movedBase) throws Exception {
        ID movedBaseId = this.getEntryId(movedBase);
        if (this.aliasIdx.reverseLookup(movedBaseId) != null) {
            this.dropAliasIndices(movedBaseId, movedBase);
        }
    }

    protected void dropAliasIndices(ID aliasId, Dn movedBase) throws Exception {
        String targetDn = this.aliasIdx.reverseLookup(aliasId);
        ID targetId = this.getEntryId(new Dn(this.schemaManager, new String[]{targetDn}));
        Dn aliasDn = this.getEntryDn(aliasId);
        Dn ancestorDn = new Dn(this.schemaManager, new Rdn[]{movedBase.getRdn(movedBase.size() - 1)});
        ID ancestorId = this.getEntryId(ancestorDn);
        if (aliasDn.equals((Object)movedBase)) {
            this.oneAliasIdx.drop(ancestorId, targetId);
        }
        this.subAliasIdx.drop(ancestorId, targetId);
        while (!ancestorDn.equals((Object)this.suffixDn)) {
            ancestorDn = new Dn(this.schemaManager, new Rdn[]{ancestorDn.getRdn(ancestorDn.size() - 1)});
            ancestorId = this.getEntryId(ancestorDn);
            this.subAliasIdx.drop(ancestorId, targetId);
        }
    }

    private void dumpIndex(OutputStream stream, Index<?, Entry, ID> index) {
        try {
            IndexCursor<?, Entry, ID> cursor = index.forwardCursor();
            while (cursor.next()) {
                IndexEntry entry = (IndexEntry)cursor.get();
                System.out.println(entry);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void dumpIndex(OutputStream stream, String name) throws IOException {
        try {
            AttributeType attributeType = this.schemaManager.lookupAttributeTypeRegistry(name);
            if (attributeType == null) {
                stream.write(Strings.getBytesUtf8((String)("Cannot find an index for AttributeType names " + name)));
                return;
            }
            if (attributeType.getOid().equals("1.3.6.1.4.1.18060.0.4.1.2.50")) {
                this.dumpIndex(stream, this.rdnIdx);
            }
        }
        catch (LdapException le) {
            stream.write(Strings.getBytesUtf8((String)("Cannot find an index for AttributeType names " + name)));
        }
    }

    public String toString() {
        return "Partition<" + this.id + ">";
    }
}

