/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.AbstractIndexCursor;
import org.apache.directory.server.xdbm.IndexCursor;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.search.Evaluator;
import org.apache.directory.server.xdbm.search.impl.ScanCountComparator;
import org.apache.directory.shared.ldap.model.cursor.InvalidCursorPositionException;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.filter.ExprNode;

public class AndCursor<V, ID>
extends AbstractIndexCursor<V, Entry, ID> {
    private static final String UNSUPPORTED_MSG = I18n.err((I18n)I18n.ERR_707, (Object[])new Object[0]);
    private final IndexCursor<V, Entry, ID> wrapped;
    private final List<Evaluator<? extends ExprNode, Entry, ID>> evaluators;

    public AndCursor(IndexCursor<V, Entry, ID> wrapped, List<Evaluator<? extends ExprNode, Entry, ID>> evaluators) {
        this.wrapped = wrapped;
        this.evaluators = this.optimize(evaluators);
    }

    @Override
    protected String getUnsupportedMessage() {
        return UNSUPPORTED_MSG;
    }

    public void beforeFirst() throws Exception {
        this.checkNotClosed("beforeFirst()");
        this.wrapped.beforeFirst();
        this.setAvailable(false);
    }

    public void afterLast() throws Exception {
        this.checkNotClosed("afterLast()");
        this.wrapped.afterLast();
        this.setAvailable(false);
    }

    public boolean first() throws Exception {
        this.beforeFirst();
        return this.next();
    }

    public boolean last() throws Exception {
        this.afterLast();
        return this.previous();
    }

    public boolean previous() throws Exception {
        while (this.wrapped.previous()) {
            this.checkNotClosed("previous()");
            IndexEntry candidate = (IndexEntry)this.wrapped.get();
            if (!this.matches(candidate)) continue;
            return this.setAvailable(true);
        }
        return this.setAvailable(false);
    }

    public boolean next() throws Exception {
        while (this.wrapped.next()) {
            this.checkNotClosed("next()");
            IndexEntry candidate = (IndexEntry)this.wrapped.get();
            if (!this.matches(candidate)) continue;
            return this.setAvailable(true);
        }
        return this.setAvailable(false);
    }

    public IndexEntry<V, ID> get() throws Exception {
        this.checkNotClosed("get()");
        if (this.available()) {
            return (IndexEntry)this.wrapped.get();
        }
        throw new InvalidCursorPositionException(I18n.err((I18n)I18n.ERR_708, (Object[])new Object[0]));
    }

    public void close() throws Exception {
        super.close();
        this.wrapped.close();
    }

    private List<Evaluator<? extends ExprNode, Entry, ID>> optimize(List<Evaluator<? extends ExprNode, Entry, ID>> unoptimized) {
        ArrayList<Evaluator<ExprNode, Entry, ID>> optimized = new ArrayList<Evaluator<ExprNode, Entry, ID>>(unoptimized.size());
        optimized.addAll(unoptimized);
        Collections.sort(optimized, new ScanCountComparator());
        return optimized;
    }

    private boolean matches(IndexEntry<V, ID> indexEntry) throws Exception {
        for (Evaluator<ExprNode, Entry, ID> evaluator : this.evaluators) {
            if (evaluator.evaluate(indexEntry)) continue;
            return false;
        }
        return true;
    }
}

