/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search.impl;

import java.util.HashSet;
import java.util.List;
import org.apache.directory.api.ldap.model.cursor.Cursor;
import org.apache.directory.api.ldap.model.filter.AndNode;
import org.apache.directory.api.ldap.model.filter.ApproximateNode;
import org.apache.directory.api.ldap.model.filter.AssertionNode;
import org.apache.directory.api.ldap.model.filter.BranchNode;
import org.apache.directory.api.ldap.model.filter.EqualityNode;
import org.apache.directory.api.ldap.model.filter.ExprNode;
import org.apache.directory.api.ldap.model.filter.ExtensibleNode;
import org.apache.directory.api.ldap.model.filter.GreaterEqNode;
import org.apache.directory.api.ldap.model.filter.LeafNode;
import org.apache.directory.api.ldap.model.filter.LessEqNode;
import org.apache.directory.api.ldap.model.filter.NotNode;
import org.apache.directory.api.ldap.model.filter.OrNode;
import org.apache.directory.api.ldap.model.filter.PresenceNode;
import org.apache.directory.api.ldap.model.filter.ScopeNode;
import org.apache.directory.api.ldap.model.filter.SimpleNode;
import org.apache.directory.api.ldap.model.filter.SubstringNode;
import org.apache.directory.api.util.Strings;
import org.apache.directory.server.core.api.partition.Partition;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.Index;
import org.apache.directory.server.xdbm.Store;
import org.apache.directory.server.xdbm.search.Optimizer;

public class DefaultOptimizer<E>
implements Optimizer {
    static final String CANDIDATES_ANNOTATION_KEY = "candidates";
    private final Store db;
    private String contextEntryId;

    public DefaultOptimizer(Store db) throws Exception {
        this.db = db;
    }

    private String getContextEntryId() throws Exception {
        if (this.contextEntryId == null) {
            try {
                this.contextEntryId = this.db.getEntryId(((Partition)this.db).getSuffixDn());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.contextEntryId == null) {
            return Partition.DEFAULT_ID;
        }
        return this.contextEntryId;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Long annotate(ExprNode node) throws Exception {
        Long count = Long.MAX_VALUE;
        if (node instanceof ScopeNode) {
            count = this.getScopeScan((ScopeNode)node);
        } else if (!(node instanceof AssertionNode)) {
            if (node.isLeaf()) {
                LeafNode leaf = (LeafNode)node;
                if (node instanceof PresenceNode) {
                    count = this.getPresenceScan((PresenceNode)leaf);
                } else if (node instanceof EqualityNode) {
                    count = this.getEqualityScan((SimpleNode)((EqualityNode)leaf));
                } else if (node instanceof GreaterEqNode) {
                    count = this.getGreaterLessScan((SimpleNode)((GreaterEqNode)leaf), true);
                } else if (node instanceof LessEqNode) {
                    count = this.getGreaterLessScan((SimpleNode)leaf, false);
                } else if (node instanceof SubstringNode) {
                    count = this.getSubstringScan((SubstringNode)leaf);
                } else if (node instanceof ExtensibleNode) {
                    count = this.getFullScan(leaf);
                } else {
                    if (!(node instanceof ApproximateNode)) throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_711, (Object[])new Object[0]));
                    count = this.getEqualityScan((SimpleNode)((ApproximateNode)leaf));
                }
            } else if (node instanceof AndNode) {
                count = this.getConjunctionScan((BranchNode)((AndNode)node));
            } else if (node instanceof OrNode) {
                count = this.getDisjunctionScan((BranchNode)((OrNode)node));
            } else {
                if (!(node instanceof NotNode)) throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_712, (Object[])new Object[0]));
                this.annotate(((NotNode)node).getFirstChild());
                count = Long.MAX_VALUE;
            }
        }
        if (count < 0L) {
            count = Long.MAX_VALUE;
        }
        node.set("count", (Object)count);
        return count;
    }

    private long getConjunctionScan(BranchNode node) throws Exception {
        long count = Long.MAX_VALUE;
        List children = node.getChildren();
        for (ExprNode child : children) {
            if (count == 1L && child instanceof ScopeNode) break;
            this.annotate(child);
            count = Math.min((Long)child.get((Object)"count"), count);
            if (count != 0L) continue;
            break;
        }
        return count;
    }

    private long getDisjunctionScan(BranchNode node) throws Exception {
        List children = node.getChildren();
        long total = 0L;
        for (ExprNode child : children) {
            this.annotate(child);
            if ((total += ((Long)child.get((Object)"count")).longValue()) != Long.MAX_VALUE) continue;
            break;
        }
        return total;
    }

    private <V> long getEqualityScan(SimpleNode<V> node) throws Exception {
        if (this.db.hasIndexOn(node.getAttributeType())) {
            Index<?, String> idx = this.db.getIndex(node.getAttributeType());
            Cursor<String> result = idx.forwardValueCursor(node.getValue().getValue());
            HashSet<String> values = new HashSet<String>();
            int nbFound = 0;
            for (String value : result) {
                values.add(value);
                if (++nbFound != 100) continue;
                break;
            }
            result.close();
            if (nbFound < 100) {
                node.set(CANDIDATES_ANNOTATION_KEY, values);
                return values.size();
            }
            node.set(CANDIDATES_ANNOTATION_KEY, null);
            return idx.count(node.getValue().getValue());
        }
        return Long.MAX_VALUE;
    }

    private <V> long getGreaterLessScan(SimpleNode<V> node, boolean isGreaterThan) throws Exception {
        if (this.db.hasIndexOn(node.getAttributeType())) {
            Index<?, String> idx = this.db.getIndex(node.getAttributeType());
            if (isGreaterThan) {
                return idx.greaterThanCount(node.getValue().getValue());
            }
            return idx.lessThanCount(node.getValue().getValue());
        }
        return Long.MAX_VALUE;
    }

    private long getSubstringScan(SubstringNode node) throws Exception {
        if (this.db.hasIndexOn(node.getAttributeType())) {
            Index<?, String> idx = this.db.getIndex(node.getAttributeType());
            String initial = node.getInitial();
            if (Strings.isEmpty((String)initial)) {
                return Long.MAX_VALUE;
            }
            return idx.greaterThanCount(initial);
        }
        return Long.MAX_VALUE;
    }

    private long getFullScan(LeafNode node) throws Exception {
        if (this.db.hasIndexOn(node.getAttributeType())) {
            Index<?, String> idx = this.db.getIndex(node.getAttributeType());
            return idx.count();
        }
        return Long.MAX_VALUE;
    }

    private long getPresenceScan(PresenceNode node) throws Exception {
        if (this.db.hasUserIndexOn(node.getAttributeType())) {
            Index<String, String> presenceIndex = this.db.getPresenceIndex();
            return presenceIndex.count(node.getAttributeType().getOid());
        }
        if (node.getAttributeType().getOid().equals("2.5.18.5")) {
            Index<String, String> presenceIndex = this.db.getPresenceIndex();
            return presenceIndex.count(node.getAttributeType().getOid());
        }
        if (this.db.hasSystemIndexOn(node.getAttributeType()) || node.getAttributeType().getOid() == "1.3.6.1.1.16.4") {
            return this.db.count();
        }
        return Long.MAX_VALUE;
    }

    private long getScopeScan(ScopeNode node) throws Exception {
        String id = node.getBaseId();
        switch (node.getScope()) {
            case OBJECT: {
                return 1L;
            }
            case ONELEVEL: {
                return this.db.getChildCount(id);
            }
            case SUBTREE: {
                if (id == this.getContextEntryId()) {
                    return this.db.count();
                }
                return this.db.getRdnIndex().reverseLookup(id).getNbDescendants() + 1;
            }
        }
        throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_713, (Object[])new Object[0]));
    }
}

