/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search.evaluator;

import java.util.Iterator;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.filter.GreaterEqNode;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.MatchingRule;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.Store;
import org.apache.directory.server.xdbm.search.evaluator.LeafEvaluator;

public class GreaterEqEvaluator<T>
extends LeafEvaluator<T> {
    public GreaterEqEvaluator(GreaterEqNode<T> node, Store db, SchemaManager schemaManager) throws Exception {
        super(node, db, schemaManager);
        this.idx = db.hasIndexOn(node.getAttributeType()) ? db.getIndex(this.attributeType) : null;
        MatchingRule mr = this.attributeType.getOrdering();
        if (mr == null) {
            mr = this.attributeType.getEquality();
        }
        if (mr == null) {
            throw new IllegalStateException(I18n.err((I18n)I18n.ERR_715, (Object[])new Object[]{node}));
        }
        this.normalizer = mr.getNormalizer();
        this.ldapComparator = mr.getLdapComparator();
    }

    @Override
    public GreaterEqNode getExpression() {
        return (GreaterEqNode)this.node;
    }

    @Override
    public boolean evaluate(IndexEntry<?, String> indexEntry) throws LdapException {
        Attribute attr;
        Entry entry = indexEntry.getEntry();
        if (null == entry) {
            entry = this.db.fetch(indexEntry.getId());
            if (null == entry) {
                return false;
            }
            indexEntry.setEntry(entry);
        }
        if ((attr = entry.get(this.attributeType)) != null && this.evaluate(indexEntry, attr)) {
            return true;
        }
        if (this.schemaManager.getAttributeTypeRegistry().hasDescendants(this.attributeType)) {
            Iterator descendants = this.schemaManager.getAttributeTypeRegistry().descendants(this.attributeType);
            while (descendants.hasNext()) {
                AttributeType descendant = (AttributeType)descendants.next();
                attr = entry.get(descendant);
                if (attr == null || !this.evaluate(indexEntry, attr)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean evaluate(Entry entry) throws Exception {
        Attribute attr = entry.get(this.attributeType);
        if (attr != null && this.evaluate(null, attr)) {
            return true;
        }
        if (this.schemaManager.getAttributeTypeRegistry().hasDescendants(this.attributeType)) {
            Iterator descendants = this.schemaManager.getAttributeTypeRegistry().descendants(this.attributeType);
            while (descendants.hasNext()) {
                AttributeType descendant = (AttributeType)descendants.next();
                attr = entry.get(descendant);
                if (attr == null || !this.evaluate(null, attr)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean evaluate(IndexEntry<Object, String> indexEntry, Attribute attribute) throws LdapException {
        for (Value value : attribute) {
            if (this.ldapComparator.compare(value.getNormValue(), this.node.getValue().getNormValue()) < 0) continue;
            if (indexEntry != null) {
                indexEntry.setKey(value.getNormValue());
            }
            return true;
        }
        return false;
    }

    @Override
    public String toString(String tabs) {
        StringBuilder sb = new StringBuilder();
        sb.append(tabs).append("GreaterEqEvaluator : ").append(super.toString()).append("\n");
        return sb.toString();
    }

    @Override
    public String toString() {
        return this.toString("");
    }
}

