/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm;

import org.apache.directory.api.ldap.model.cursor.Tuple;
import org.apache.directory.api.ldap.model.entry.Entry;

public class IndexEntry<K, ID> {
    private Entry entry;
    private final Tuple<K, ID> tuple = new Tuple();

    public void setTuple(Tuple<K, ID> tuple) {
        this.entry = null;
        this.tuple.setKey(tuple.getKey());
        this.tuple.setValue(tuple.getValue());
    }

    public ID getId() {
        return (ID)this.tuple.getValue();
    }

    public K getKey() {
        return (K)this.tuple.getKey();
    }

    public void setId(ID id) {
        this.tuple.setValue(id);
    }

    public void setKey(K value) {
        this.tuple.setKey(value);
    }

    public Entry getEntry() {
        return this.entry;
    }

    public void setEntry(Entry entry) {
        this.entry = entry;
    }

    public Tuple<K, ID> getTuple() {
        return this.tuple;
    }

    public void clear() {
        this.entry = null;
        this.tuple.setKey(null);
        this.tuple.setValue(null);
    }

    public void copy(IndexEntry<K, ID> entry) {
        this.entry = entry.getEntry();
        this.tuple.setKey(entry.getKey());
        this.tuple.setValue(entry.getId());
    }

    public int hashCode() {
        if (this.getId() == null) {
            return 0;
        }
        return this.getId().hashCode();
    }

    public boolean equals(IndexEntry<K, ID> that) {
        if (that == this) {
            return true;
        }
        if (!(that instanceof IndexEntry)) {
            return false;
        }
        IndexEntry<K, ID> thatIndexEntry = that;
        if (thatIndexEntry.getId() == null) {
            return this.getId() == null;
        }
        return thatIndexEntry.getId().equals(this.getId());
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("IndexEntry[ ");
        buf.append(this.tuple.getKey());
        buf.append(", ");
        buf.append(this.tuple.getValue());
        buf.append(" ]");
        return buf.toString();
    }
}

