/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search.cursor;

import java.io.IOException;
import org.apache.directory.api.ldap.model.cursor.CursorException;
import org.apache.directory.api.ldap.model.cursor.InvalidCursorPositionException;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.filter.ExprNode;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.AbstractIndexCursor;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.Store;
import org.apache.directory.server.xdbm.search.Evaluator;
import org.apache.directory.server.xdbm.search.cursor.AllEntriesCursor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotCursor<V>
extends AbstractIndexCursor<V> {
    private static final Logger LOG_CURSOR = LoggerFactory.getLogger((String)"CURSOR");
    private static final boolean IS_DEBUG = LOG_CURSOR.isDebugEnabled();
    private static final String UNSUPPORTED_MSG = I18n.err((I18n)I18n.ERR_718, (Object[])new Object[0]);
    private final AllEntriesCursor uuidCursor;
    private final Evaluator<? extends ExprNode> childEvaluator;

    public NotCursor(Store store, Evaluator<? extends ExprNode> childEvaluator) throws Exception {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Creating NotCursor {}", (Object)this);
        }
        this.childEvaluator = childEvaluator;
        this.uuidCursor = new AllEntriesCursor(store);
    }

    @Override
    protected String getUnsupportedMessage() {
        return UNSUPPORTED_MSG;
    }

    public void beforeFirst() throws LdapException, CursorException, IOException {
        this.checkNotClosed("beforeFirst()");
        this.uuidCursor.beforeFirst();
        this.setAvailable(false);
    }

    public void afterLast() throws LdapException, CursorException, IOException {
        this.checkNotClosed("afterLast()");
        this.uuidCursor.afterLast();
        this.setAvailable(false);
    }

    public boolean first() throws LdapException, CursorException, IOException {
        this.beforeFirst();
        return this.next();
    }

    public boolean last() throws LdapException, CursorException, IOException {
        this.afterLast();
        return this.previous();
    }

    public boolean previous() throws LdapException, CursorException, IOException {
        while (this.uuidCursor.previous()) {
            this.checkNotClosed("previous()");
            Object candidate = this.uuidCursor.get();
            if (this.childEvaluator.evaluate((IndexEntry<?, String>)candidate)) continue;
            return this.setAvailable(true);
        }
        return this.setAvailable(false);
    }

    public boolean next() throws LdapException, CursorException, IOException {
        while (this.uuidCursor.next()) {
            this.checkNotClosed("next()");
            Object candidate = this.uuidCursor.get();
            if (this.childEvaluator.evaluate((IndexEntry<?, String>)candidate)) continue;
            return this.setAvailable(true);
        }
        return this.setAvailable(false);
    }

    public IndexEntry<V, String> get() throws CursorException, IOException {
        this.checkNotClosed("get()");
        if (this.available()) {
            return this.uuidCursor.get();
        }
        throw new InvalidCursorPositionException(I18n.err((I18n)I18n.ERR_708, (Object[])new Object[0]));
    }

    public void close() {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Closing NotCursor {}", (Object)this);
        }
        super.close();
        this.uuidCursor.close();
    }

    public void close(Exception cause) {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Closing NotCursor {}", (Object)this);
        }
        super.close(cause);
        this.uuidCursor.close(cause);
    }

    public String toString(String tabs) {
        StringBuilder sb = new StringBuilder();
        sb.append(tabs).append("NotCursor (");
        if (this.available()) {
            sb.append("available)");
        } else {
            sb.append("absent)");
        }
        sb.append(tabs + "  >>").append(this.childEvaluator).append('\n');
        sb.append(this.uuidCursor.toString(tabs + "    "));
        return sb.toString();
    }

    public String toString() {
        return this.toString("");
    }
}

