/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree;

import java.io.IOException;
import org.apache.directory.api.ldap.model.cursor.AbstractCursor;
import org.apache.directory.api.ldap.model.cursor.ClosureMonitor;
import org.apache.directory.api.ldap.model.cursor.Cursor;
import org.apache.directory.api.ldap.model.cursor.CursorException;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.filter.ExprNode;
import org.apache.directory.server.core.partition.impl.btree.AbstractBTreePartition;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.search.Evaluator;
import org.apache.directory.server.xdbm.search.PartitionSearchResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntryCursorAdaptor
extends AbstractCursor<Entry> {
    private static final Logger LOG_CURSOR = LoggerFactory.getLogger((String)"CURSOR");
    private static final boolean IS_DEBUG = LOG_CURSOR.isDebugEnabled();
    private final Cursor<IndexEntry<String, String>> indexCursor;
    private final Evaluator<? extends ExprNode> evaluator;

    public EntryCursorAdaptor(AbstractBTreePartition db, PartitionSearchResult searchResult) {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Creating EntryCursorAdaptor {}", (Object)this);
        }
        this.indexCursor = searchResult.getResultSet();
        this.evaluator = searchResult.getEvaluator();
    }

    public void after(Entry element) throws LdapException, CursorException, IOException {
        throw new UnsupportedOperationException();
    }

    public void afterLast() throws LdapException, CursorException, IOException {
        this.indexCursor.afterLast();
    }

    public boolean available() {
        return this.indexCursor.available();
    }

    public void before(Entry element) throws LdapException, CursorException, IOException {
        throw new UnsupportedOperationException();
    }

    public void beforeFirst() throws LdapException, CursorException, IOException {
        this.indexCursor.beforeFirst();
    }

    public final void setClosureMonitor(ClosureMonitor monitor) {
        this.indexCursor.setClosureMonitor(monitor);
    }

    public void close() {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Closing EntryCursorAdaptor {}", (Object)this);
        }
        this.indexCursor.close();
    }

    public void close(Exception cause) {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Closing EntryCursorAdaptor {}", (Object)this);
        }
        this.indexCursor.close(cause);
    }

    public boolean first() throws LdapException, CursorException, IOException {
        return this.indexCursor.first();
    }

    public Entry get() throws CursorException, IOException {
        IndexEntry indexEntry = (IndexEntry)this.indexCursor.get();
        try {
            if (this.evaluator.evaluate(indexEntry)) {
                Entry entry = indexEntry.getEntry();
                indexEntry.setEntry(null);
                return entry;
            }
            indexEntry.setEntry(null);
            return null;
        }
        catch (Exception e) {
            throw new CursorException(e.getMessage(), (Throwable)e);
        }
    }

    public boolean isClosed() {
        return this.indexCursor.isClosed();
    }

    public boolean last() throws LdapException, CursorException, IOException {
        return this.indexCursor.last();
    }

    public boolean next() throws LdapException, CursorException, IOException {
        return this.indexCursor.next();
    }

    public boolean previous() throws LdapException, CursorException, IOException {
        return this.indexCursor.previous();
    }

    public String toString(String tabs) {
        StringBuilder sb = new StringBuilder();
        sb.append(tabs).append("EntryCursorAdaptor\n");
        if (this.indexCursor != null) {
            sb.append(tabs).append("    ").append("IndexCursor : \n");
            sb.append(this.indexCursor.toString(tabs + "        "));
        }
        if (this.evaluator != null) {
            sb.append(tabs).append("    ").append("Evaluator : \n");
            sb.append(this.evaluator.toString(tabs + "        "));
        }
        return sb.toString();
    }

    public String toString() {
        return this.toString("");
    }
}

