/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree;

import java.util.Arrays;
import java.util.List;
import org.apache.directory.server.xdbm.Tuple;
import org.apache.directory.shared.ldap.NotImplementedException;
import org.apache.directory.shared.ldap.cursor.AbstractCursor;
import org.apache.directory.shared.ldap.cursor.InvalidCursorPositionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueArrayCursor<K, V>
extends AbstractCursor<Tuple> {
    private static final int BEFORE_FIRST = -1;
    private final K key;
    private final List<V> values;
    private final Tuple<K, V> tuple = new Tuple();
    private int pos = -1;

    public ValueArrayCursor(K key, V[] values) {
        this.key = key;
        this.tuple.setKey(key);
        this.values = Arrays.asList(values);
    }

    public ValueArrayCursor(K key, List<V> values) {
        this.key = key;
        this.tuple.setKey(key);
        this.values = values;
    }

    public boolean available() {
        return this.inRangeOnValue();
    }

    public void before(Tuple element) throws Exception {
        throw new NotImplementedException();
    }

    public void after(Tuple element) throws Exception {
        throw new NotImplementedException();
    }

    public void beforeFirst() throws Exception {
        this.checkNotClosed("beforeFirst()");
        this.pos = -1;
    }

    public void afterLast() throws Exception {
        this.checkNotClosed("afterLast()");
        this.pos = this.values.size();
    }

    public boolean absolute(int absolutePosition) throws Exception {
        this.checkNotClosed("absolute()");
        if (absolutePosition >= this.values.size()) {
            this.pos = this.values.size();
            return false;
        }
        if (absolutePosition < 0) {
            this.pos = -1;
            return false;
        }
        this.pos = absolutePosition;
        return true;
    }

    public boolean first() throws Exception {
        this.checkNotClosed("first()");
        this.pos = 0;
        return true;
    }

    public boolean last() throws Exception {
        this.checkNotClosed("last()");
        this.pos = this.values.size() - 1;
        return true;
    }

    public boolean isFirst() throws Exception {
        this.checkNotClosed("isFirst()");
        return this.pos == 0;
    }

    public boolean isLast() throws Exception {
        this.checkNotClosed("isLast()");
        return this.pos == this.values.size() - 1;
    }

    public boolean isAfterLast() throws Exception {
        this.checkNotClosed("isAfterLast()");
        return this.pos == this.values.size();
    }

    public boolean isBeforeFirst() throws Exception {
        this.checkNotClosed("isBeforeFirst()");
        return this.pos == -1;
    }

    public boolean previous() throws Exception {
        this.checkNotClosed("previous()");
        if (this.pos <= -1) {
            return false;
        }
        --this.pos;
        return this.inRangeOnValue();
    }

    private boolean inRangeOnValue() {
        return this.pos > -1 && this.pos < this.values.size();
    }

    public boolean next() throws Exception {
        this.checkNotClosed("next()");
        if (this.pos >= this.values.size()) {
            return false;
        }
        ++this.pos;
        return this.inRangeOnValue();
    }

    public Tuple get() throws Exception {
        this.checkNotClosed("get()");
        if (this.inRangeOnValue()) {
            return this.tuple.setBoth(this.key, this.values.get(this.pos));
        }
        throw new InvalidCursorPositionException("Cursor pos (" + this.pos + ") not in value range [0-" + (this.values.size() - 1) + "]");
    }

    public boolean isElementReused() {
        return true;
    }
}

