/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.wrapper;

import org.apache.directory.server.ApacheDsService;
import org.apache.directory.server.core.api.InstanceLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tanukisoftware.wrapper.WrapperListener;
import org.tanukisoftware.wrapper.WrapperManager;

public final class ApacheDsTanukiWrapper
implements WrapperListener {
    private static final Logger LOG = LoggerFactory.getLogger(ApacheDsTanukiWrapper.class);
    private ApacheDsService service;

    private ApacheDsTanukiWrapper() {
    }

    public static void main(String[] args) {
        WrapperManager.start((WrapperListener)new ApacheDsTanukiWrapper(), (String[])args);
    }

    public Integer start(String[] args) {
        LOG.info("Starting the service...");
        if (args != null && args.length == 1) {
            this.service = new ApacheDsService();
            InstanceLayout instanceLayout = new InstanceLayout(args[0]);
            try {
                this.service.start(instanceLayout);
            }
            catch (Exception e) {
                LOG.error("Failed to start the service.", (Throwable)e);
                System.exit(5);
            }
        } else {
            throw new IllegalArgumentException("Program must be launched with 1 arguement, the path to the instance directory.");
        }
        return null;
    }

    public int stop(int exitCode) {
        LOG.info("Attempting graceful shutdown of the service...");
        try {
            this.service.stop();
        }
        catch (Exception e) {
            LOG.error("Failed to stop the service.", (Throwable)e);
            System.exit(6);
        }
        LOG.info("Completed graceful shutdown of the service...");
        return exitCode;
    }

    public void controlEvent(int event) {
        if (!(WrapperManager.isControlledByNativeWrapper() || event != 200 && event != 201 && event != 203)) {
            WrapperManager.stop((int)0);
        }
    }
}

