/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.utils;

import java.util.Comparator;
import javax.naming.NamingException;
import org.apache.directory.server.core.entry.DefaultServerAttribute;
import org.apache.directory.server.core.entry.DefaultServerEntry;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.schema.bootstrap.Schema;
import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.DITContentRule;
import org.apache.directory.shared.ldap.schema.DITStructureRule;
import org.apache.directory.shared.ldap.schema.MatchingRule;
import org.apache.directory.shared.ldap.schema.MatchingRuleUse;
import org.apache.directory.shared.ldap.schema.NameForm;
import org.apache.directory.shared.ldap.schema.Normalizer;
import org.apache.directory.shared.ldap.schema.ObjectClass;
import org.apache.directory.shared.ldap.schema.SchemaObject;
import org.apache.directory.shared.ldap.schema.Syntax;
import org.apache.directory.shared.ldap.schema.syntax.SyntaxChecker;
import org.apache.directory.shared.ldap.util.DateUtils;

public class AttributesFactory {
    public ServerEntry getAttributes(SchemaObject obj, Schema schema, Registries registries) throws NamingException {
        if (obj instanceof Syntax) {
            return this.getAttributes((Syntax)obj, schema, registries);
        }
        if (obj instanceof MatchingRule) {
            return this.getAttributes((MatchingRule)obj, schema, registries);
        }
        if (obj instanceof AttributeType) {
            return this.getAttributes((AttributeType)obj, schema, registries);
        }
        if (obj instanceof ObjectClass) {
            return this.getAttributes((ObjectClass)obj, schema, registries);
        }
        if (obj instanceof MatchingRuleUse) {
            return this.getAttributes((MatchingRuleUse)obj, schema, registries);
        }
        if (obj instanceof DITStructureRule) {
            return this.getAttributes((DITStructureRule)obj, schema, registries);
        }
        if (obj instanceof DITContentRule) {
            return this.getAttributes((DITContentRule)obj, schema, registries);
        }
        if (obj instanceof NameForm) {
            return this.getAttributes((NameForm)obj, schema, registries);
        }
        throw new IllegalArgumentException("Unknown SchemaObject type: " + obj.getClass());
    }

    public ServerEntry getAttributes(Schema schema, Registries registries) throws NamingException {
        String[] dependencies;
        DefaultServerEntry entry = new DefaultServerEntry(registries);
        entry.put("objectClass", new String[]{"top", "metaSchema"});
        entry.put("cn", new String[]{schema.getSchemaName()});
        entry.put("creatorsName", new String[]{schema.getOwner()});
        entry.put("createTimestamp", new String[]{DateUtils.getGeneralizedTime()});
        if (schema.isDisabled()) {
            entry.put("m-disabled", new String[]{"TRUE"});
        }
        if ((dependencies = schema.getDependencies()) != null && dependencies.length > 0) {
            DefaultServerAttribute attr = new DefaultServerAttribute(registries.getAttributeTypeRegistry().lookup("m-dependencies"));
            for (String dependency : dependencies) {
                attr.add(new String[]{dependency});
            }
            entry.put(new EntryAttribute[]{attr});
        }
        return entry;
    }

    public ServerEntry getAttributes(SyntaxChecker syntaxChecker, Schema schema, Registries registries) {
        DefaultServerEntry entry = new DefaultServerEntry(registries);
        entry.put("objectClass", new String[]{"top", "metaSyntaxChecker"});
        entry.put("m-oid", new String[]{syntaxChecker.getSyntaxOid()});
        entry.put("m-fqcn", new String[]{syntaxChecker.getClass().getName()});
        entry.put("creatorsName", new String[]{schema.getOwner()});
        entry.put("createTimestamp", new String[]{DateUtils.getGeneralizedTime()});
        return entry;
    }

    public ServerEntry getAttributes(Syntax syntax, Schema schema, Registries registries) throws NamingException {
        DefaultServerEntry entry = new DefaultServerEntry(registries);
        entry.put("objectClass", new String[]{"top", "metaSyntax"});
        entry.put("x-humanReadable", new String[]{this.getBoolean(syntax.isHumanReadable())});
        entry.put("creatorsName", new String[]{schema.getOwner()});
        entry.put("createTimestamp", new String[]{DateUtils.getGeneralizedTime()});
        this.injectCommon((SchemaObject)syntax, (ServerEntry)entry, registries);
        return entry;
    }

    public ServerEntry getAttributes(String oid, Normalizer normalizer, Schema schema, Registries registries) {
        DefaultServerEntry entry = new DefaultServerEntry(registries);
        entry.put("objectClass", new String[]{"top", "metaNormalizer"});
        entry.put("m-oid", new String[]{oid});
        entry.put("m-fqcn", new String[]{normalizer.getClass().getName()});
        entry.put("creatorsName", new String[]{schema.getOwner()});
        entry.put("createTimestamp", new String[]{DateUtils.getGeneralizedTime()});
        return entry;
    }

    public ServerEntry getAttributes(String oid, Comparator comparator, Schema schema, Registries registries) {
        DefaultServerEntry entry = new DefaultServerEntry(registries);
        entry.put("objectClass", new String[]{"top", "metaComparator"});
        entry.put("m-oid", new String[]{oid});
        entry.put("m-fqcn", new String[]{comparator.getClass().getName()});
        entry.put("creatorsName", new String[]{schema.getOwner()});
        entry.put("createTimestamp", new String[]{DateUtils.getGeneralizedTime()});
        return entry;
    }

    public ServerEntry getAttributes(MatchingRule matchingRule, Schema schema, Registries registries) throws NamingException {
        DefaultServerEntry entry = new DefaultServerEntry(registries);
        entry.put("objectClass", new String[]{"top", "metaMatchingRule"});
        entry.put("m-syntax", new String[]{matchingRule.getSyntax().getOid()});
        entry.put("creatorsName", new String[]{schema.getOwner()});
        entry.put("createTimestamp", new String[]{DateUtils.getGeneralizedTime()});
        this.injectCommon((SchemaObject)matchingRule, (ServerEntry)entry, registries);
        return entry;
    }

    public ServerEntry getAttributes(MatchingRuleUse matchingRuleUse, Schema schema, Registries registries) {
        DefaultServerEntry entry = new DefaultServerEntry(registries);
        entry.put("objectClass", new String[]{"top", ""});
        entry.put("creatorsName", new String[]{schema.getOwner()});
        entry.put("createTimestamp", new String[]{DateUtils.getGeneralizedTime()});
        return entry;
    }

    public ServerEntry getAttributes(DITStructureRule dITStructureRule, Schema schema, Registries registries) {
        DefaultServerEntry entry = new DefaultServerEntry(registries);
        entry.put("objectClass", new String[]{"top", ""});
        entry.put("creatorsName", new String[]{schema.getOwner()});
        entry.put("createTimestamp", new String[]{DateUtils.getGeneralizedTime()});
        return entry;
    }

    public ServerEntry getAttributes(DITContentRule dITContentRule, Schema schema, Registries registries) {
        DefaultServerEntry entry = new DefaultServerEntry(registries);
        entry.put("objectClass", new String[]{"top", ""});
        entry.put("creatorsName", new String[]{schema.getOwner()});
        entry.put("createTimestamp", new String[]{DateUtils.getGeneralizedTime()});
        return entry;
    }

    public ServerEntry getAttributes(NameForm nameForm, Schema schema, Registries registries) {
        DefaultServerEntry entry = new DefaultServerEntry(registries);
        entry.put("objectClass", new String[]{"top", ""});
        entry.put("creatorsName", new String[]{schema.getOwner()});
        entry.put("createTimestamp", new String[]{DateUtils.getGeneralizedTime()});
        return entry;
    }

    public ServerEntry getAttributes(AttributeType attributeType, Schema schema, Registries registries) throws NamingException {
        DefaultServerEntry entry = new DefaultServerEntry(registries);
        entry.put("objectClass", new String[]{"top", "metaAttributeType"});
        entry.put("m-syntax", new String[]{attributeType.getSyntax().getOid()});
        entry.put("m-collective", new String[]{this.getBoolean(attributeType.isCollective())});
        entry.put("m-noUserModification", new String[]{this.getBoolean(!attributeType.isCanUserModify())});
        entry.put("m-singleValue", new String[]{this.getBoolean(attributeType.isSingleValue())});
        entry.put("m-usage", new String[]{attributeType.getUsage().toString()});
        entry.put("creatorsName", new String[]{schema.getOwner()});
        entry.put("createTimestamp", new String[]{DateUtils.getGeneralizedTime()});
        this.injectCommon((SchemaObject)attributeType, (ServerEntry)entry, registries);
        AttributeType superior = attributeType.getSuperior();
        if (superior != null) {
            String sup = superior.getName();
            if (sup == null) {
                sup = superior.getOid();
            }
            entry.put("m-supAttributeType", new String[]{sup});
        }
        if (attributeType.getEquality() != null) {
            String equality = attributeType.getEquality().getName();
            if (equality == null) {
                equality = attributeType.getEquality().getOid();
            }
            entry.put("m-equality", new String[]{equality});
        }
        if (attributeType.getSubstr() != null) {
            String substr = attributeType.getSubstr().getName();
            if (substr == null) {
                substr = attributeType.getSubstr().getOid();
            }
            entry.put("m-substr", new String[]{substr});
        }
        if (attributeType.getOrdering() != null) {
            String ordering = attributeType.getOrdering().getName();
            if (ordering == null) {
                ordering = attributeType.getOrdering().getOid();
            }
            entry.put("m-ordering", new String[]{ordering});
        }
        return entry;
    }

    public ServerEntry getAttributes(ObjectClass objectClass, Schema schema, Registries registries) throws NamingException {
        DefaultServerAttribute attr;
        DefaultServerEntry entry = new DefaultServerEntry(registries);
        entry.put("objectClass", new String[]{"top", "metaObjectClass"});
        entry.put("m-typeObjectClass", new String[]{objectClass.getType().toString()});
        entry.put("creatorsName", new String[]{schema.getOwner()});
        entry.put("createTimestamp", new String[]{DateUtils.getGeneralizedTime()});
        this.injectCommon((SchemaObject)objectClass, (ServerEntry)entry, registries);
        if (objectClass.getSuperClasses() != null && objectClass.getSuperClasses().length != 0) {
            ObjectClass[] superClasses;
            attr = new DefaultServerAttribute(registries.getAttributeTypeRegistry().lookup("m-supObjectClass"));
            for (ObjectClass objectClass2 : superClasses = objectClass.getSuperClasses()) {
                attr.add(new String[]{this.getNameOrNumericoid((SchemaObject)objectClass2)});
            }
            entry.put(new EntryAttribute[]{attr});
        }
        if (objectClass.getMustList() != null && objectClass.getMustList().length != 0) {
            attr = new DefaultServerAttribute(registries.getAttributeTypeRegistry().lookup("m-must"));
            AttributeType[] mustList = objectClass.getMustList();
            for (ObjectClass objectClass3 : mustList) {
                attr.add(new String[]{this.getNameOrNumericoid((SchemaObject)objectClass3)});
            }
            entry.put(new EntryAttribute[]{attr});
        }
        if (objectClass.getMayList() != null && objectClass.getMayList().length != 0) {
            attr = new DefaultServerAttribute(registries.getAttributeTypeRegistry().lookup("m-may"));
            AttributeType[] mayList = objectClass.getMayList();
            for (ObjectClass objectClass4 : mayList) {
                attr.add(new String[]{this.getNameOrNumericoid((SchemaObject)objectClass4)});
            }
            entry.put(new EntryAttribute[]{attr});
        }
        return entry;
    }

    private final String getNameOrNumericoid(SchemaObject object) {
        if (object.getName() != null) {
            return object.getName();
        }
        return object.getOid();
    }

    private final void injectCommon(SchemaObject object, ServerEntry entry, Registries registries) throws NamingException {
        this.injectNames(object.getNamesRef(), entry, registries);
        entry.put("m-obsolete", new String[]{this.getBoolean(object.isObsolete())});
        entry.put("m-oid", new String[]{object.getOid()});
        if (object.getDescription() != null) {
            entry.put("m-description", new String[]{object.getDescription()});
        }
    }

    private final void injectNames(String[] names, ServerEntry entry, Registries registries) throws NamingException {
        if (names == null || names.length == 0) {
            return;
        }
        DefaultServerAttribute attr = new DefaultServerAttribute(registries.getAttributeTypeRegistry().lookup("m-name"));
        for (String name : names) {
            attr.add(new String[]{name});
        }
        entry.put(new EntryAttribute[]{attr});
    }

    private final String getBoolean(boolean value) {
        if (value) {
            return "TRUE";
        }
        return "FALSE";
    }
}

