/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.avltree;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Comparator;
import org.apache.directory.api.util.Strings;
import org.apache.directory.server.core.avltree.ArrayTree;
import org.apache.directory.server.core.avltree.DefaultMarshaller;
import org.apache.directory.server.core.avltree.Marshaller;
import org.apache.directory.server.i18n.I18n;

public class ArrayMarshaller<E>
implements Marshaller<ArrayTree<E>> {
    private static final byte[] EMPTY_TREE = new byte[1];
    private Marshaller<E> keyMarshaller;
    private Comparator<E> comparator;

    public ArrayMarshaller(Comparator<E> comparator, Marshaller<E> keyMarshaller) {
        this.comparator = comparator;
        this.keyMarshaller = keyMarshaller;
    }

    public ArrayMarshaller(Comparator<E> comparator) {
        this.comparator = comparator;
        this.keyMarshaller = DefaultMarshaller.INSTANCE;
    }

    @Override
    public byte[] serialize(ArrayTree<E> tree) {
        if (tree == null || tree.size() == 0) {
            return EMPTY_TREE;
        }
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(byteStream);
        byte[] data = null;
        try {
            out.writeByte(0);
            out.writeInt(tree.size());
            for (int position = 0; position < tree.size(); ++position) {
                E value = tree.get(position);
                byte[] bytes = this.keyMarshaller.serialize(value);
                out.writeInt(bytes.length);
                if (bytes.length == 0) continue;
                out.write(bytes);
            }
            out.flush();
            data = byteStream.toByteArray();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return data;
    }

    @Override
    public ArrayTree<E> deserialize(byte[] data) throws IOException {
        try {
            if (data == null || data.length == 0) {
                throw new IOException(I18n.err(I18n.ERR_439, new Object[0]));
            }
            if (data.length == 1 && data[0] == 0) {
                Object[] array = new Object[]{};
                return new ArrayTree<Object>(this.comparator, array);
            }
            ByteArrayInputStream bin = new ByteArrayInputStream(data);
            DataInputStream din = new DataInputStream(bin);
            byte startByte = din.readByte();
            if (startByte != 0) {
                throw new IOException(I18n.err(I18n.ERR_440, new Object[0]));
            }
            int size = din.readInt();
            Object[] nodes = new Object[size];
            for (int i = 0; i < size; ++i) {
                int dataSize = din.readInt();
                if (dataSize == 0) continue;
                byte[] bytes = new byte[dataSize];
                din.readFully(bytes);
                E key = this.keyMarshaller.deserialize(bytes);
                nodes[i] = key;
            }
            return new ArrayTree<Object>(this.comparator, nodes);
        }
        catch (NullPointerException npe) {
            System.out.println(I18n.err(I18n.ERR_441, Strings.dumpBytes(data)));
            throw npe;
        }
    }
}

