/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.protocol.shared;

import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class StandardThreadPool
implements Executor {
    private final ExecutorService delegate;

    public StandardThreadPool(int maxThreads) {
        this.delegate = Executors.newFixedThreadPool(maxThreads);
    }

    @Override
    public void execute(Runnable command) {
        this.delegate.execute(command);
    }

    public void stop() {
        this.delegate.shutdown();
        while (true) {
            try {
                while (!this.delegate.awaitTermination(Integer.MAX_VALUE, TimeUnit.SECONDS)) {
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }
}

