/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.journal;

import java.io.IOException;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.ldif.LdifEntry;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.LdapPrincipal;
import org.apache.directory.server.core.api.journal.Journal;
import org.apache.directory.server.core.api.journal.JournalStore;
import org.apache.directory.server.core.journal.DefaultJournalStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultJournal
implements Journal {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultJournal.class);
    private boolean enabled;
    private JournalStore store;
    private int rotation;

    @Override
    public void destroy() throws LdapException {
        LOG.debug("Stopping the journal");
        if (this.store != null) {
            try {
                this.store.destroy();
            }
            catch (IOException ioe) {
                throw new LdapException(ioe.getMessage(), ioe);
            }
        }
    }

    @Override
    public JournalStore getJournalStore() {
        return this.store;
    }

    @Override
    public void init(DirectoryService directoryService) throws LdapException {
        LOG.debug("Starting the journal");
        if (this.store == null) {
            this.store = new DefaultJournalStore();
        }
        try {
            this.store.init(directoryService);
        }
        catch (IOException ioe) {
            throw new LdapException(ioe.getMessage(), ioe);
        }
        LOG.debug("The Journal service has been initialized");
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void log(LdapPrincipal principal, long revision, LdifEntry entry) throws LdapException {
        this.store.log(principal, revision, entry);
    }

    @Override
    public void ack(long revision) {
        this.store.ack(revision);
    }

    @Override
    public void nack(long revision) {
        this.store.nack(revision);
    }

    @Override
    public int getRotation() {
        return this.rotation;
    }

    @Override
    public void setRotation(int rotation) {
        this.rotation = rotation;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public void setJournalStore(JournalStore store) {
        this.store = store;
    }
}

