/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.ldap.client.api;

import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.nio.channels.UnresolvedAddressException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.security.auth.Subject;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.util.Oid;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.BinaryAttributeDetector;
import org.apache.directory.api.ldap.codec.api.DefaultConfigurableBinaryAttributeDetector;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.codec.api.LdapApiServiceFactory;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.codec.api.MessageEncoderException;
import org.apache.directory.api.ldap.codec.api.SchemaBinaryAttributeDetector;
import org.apache.directory.api.ldap.extras.extended.startTls.StartTlsRequestImpl;
import org.apache.directory.api.ldap.model.constants.SchemaConstants;
import org.apache.directory.api.ldap.model.cursor.CursorException;
import org.apache.directory.api.ldap.model.cursor.EntryCursor;
import org.apache.directory.api.ldap.model.cursor.SearchCursor;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Modification;
import org.apache.directory.api.ldap.model.entry.ModificationOperation;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapAuthenticationException;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.exception.LdapNoPermissionException;
import org.apache.directory.api.ldap.model.exception.LdapOperationException;
import org.apache.directory.api.ldap.model.exception.LdapOtherException;
import org.apache.directory.api.ldap.model.message.AbandonRequest;
import org.apache.directory.api.ldap.model.message.AbandonRequestImpl;
import org.apache.directory.api.ldap.model.message.AddRequest;
import org.apache.directory.api.ldap.model.message.AddRequestImpl;
import org.apache.directory.api.ldap.model.message.AddResponse;
import org.apache.directory.api.ldap.model.message.AliasDerefMode;
import org.apache.directory.api.ldap.model.message.BindRequest;
import org.apache.directory.api.ldap.model.message.BindRequestImpl;
import org.apache.directory.api.ldap.model.message.BindResponse;
import org.apache.directory.api.ldap.model.message.CompareRequest;
import org.apache.directory.api.ldap.model.message.CompareRequestImpl;
import org.apache.directory.api.ldap.model.message.CompareResponse;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.message.DeleteRequest;
import org.apache.directory.api.ldap.model.message.DeleteRequestImpl;
import org.apache.directory.api.ldap.model.message.DeleteResponse;
import org.apache.directory.api.ldap.model.message.ExtendedRequest;
import org.apache.directory.api.ldap.model.message.ExtendedResponse;
import org.apache.directory.api.ldap.model.message.IntermediateResponse;
import org.apache.directory.api.ldap.model.message.IntermediateResponseImpl;
import org.apache.directory.api.ldap.model.message.LdapResult;
import org.apache.directory.api.ldap.model.message.Message;
import org.apache.directory.api.ldap.model.message.ModifyDnRequest;
import org.apache.directory.api.ldap.model.message.ModifyDnRequestImpl;
import org.apache.directory.api.ldap.model.message.ModifyDnResponse;
import org.apache.directory.api.ldap.model.message.ModifyRequest;
import org.apache.directory.api.ldap.model.message.ModifyRequestImpl;
import org.apache.directory.api.ldap.model.message.ModifyResponse;
import org.apache.directory.api.ldap.model.message.Request;
import org.apache.directory.api.ldap.model.message.Response;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.message.SearchRequest;
import org.apache.directory.api.ldap.model.message.SearchRequestImpl;
import org.apache.directory.api.ldap.model.message.SearchResultDone;
import org.apache.directory.api.ldap.model.message.SearchResultEntry;
import org.apache.directory.api.ldap.model.message.SearchResultReference;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.api.ldap.model.message.UnbindRequestImpl;
import org.apache.directory.api.ldap.model.message.controls.ManageDsaITImpl;
import org.apache.directory.api.ldap.model.message.controls.OpaqueControl;
import org.apache.directory.api.ldap.model.message.extended.AddNoDResponse;
import org.apache.directory.api.ldap.model.message.extended.BindNoDResponse;
import org.apache.directory.api.ldap.model.message.extended.CompareNoDResponse;
import org.apache.directory.api.ldap.model.message.extended.DeleteNoDResponse;
import org.apache.directory.api.ldap.model.message.extended.ExtendedNoDResponse;
import org.apache.directory.api.ldap.model.message.extended.ModifyDnNoDResponse;
import org.apache.directory.api.ldap.model.message.extended.ModifyNoDResponse;
import org.apache.directory.api.ldap.model.message.extended.SearchNoDResponse;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.name.Rdn;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.ObjectClass;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.ldap.model.schema.parsers.OpenLdapSchemaParser;
import org.apache.directory.api.ldap.model.schema.registries.Registries;
import org.apache.directory.api.ldap.model.schema.registries.SchemaLoader;
import org.apache.directory.api.ldap.schema.manager.impl.DefaultSchemaManager;
import org.apache.directory.api.util.Network;
import org.apache.directory.api.util.Strings;
import org.apache.directory.ldap.client.api.AbstractLdapConnection;
import org.apache.directory.ldap.client.api.ConnectionClosedEventListener;
import org.apache.directory.ldap.client.api.DefaultSchemaLoader;
import org.apache.directory.ldap.client.api.EntryCursorImpl;
import org.apache.directory.ldap.client.api.Krb5LoginConfiguration;
import org.apache.directory.ldap.client.api.LdapAsyncConnection;
import org.apache.directory.ldap.client.api.LdapConnection;
import org.apache.directory.ldap.client.api.LdapConnectionConfig;
import org.apache.directory.ldap.client.api.NoVerificationTrustManager;
import org.apache.directory.ldap.client.api.SaslCramMd5Request;
import org.apache.directory.ldap.client.api.SaslDigestMd5Request;
import org.apache.directory.ldap.client.api.SaslExternalRequest;
import org.apache.directory.ldap.client.api.SaslGssApiRequest;
import org.apache.directory.ldap.client.api.SaslPlainRequest;
import org.apache.directory.ldap.client.api.SaslRequest;
import org.apache.directory.ldap.client.api.SearchCursorImpl;
import org.apache.directory.ldap.client.api.callback.SaslCallbackHandler;
import org.apache.directory.ldap.client.api.exception.InvalidConnectionException;
import org.apache.directory.ldap.client.api.future.AddFuture;
import org.apache.directory.ldap.client.api.future.BindFuture;
import org.apache.directory.ldap.client.api.future.CompareFuture;
import org.apache.directory.ldap.client.api.future.DeleteFuture;
import org.apache.directory.ldap.client.api.future.ExtendedFuture;
import org.apache.directory.ldap.client.api.future.HandshakeFuture;
import org.apache.directory.ldap.client.api.future.ModifyDnFuture;
import org.apache.directory.ldap.client.api.future.ModifyFuture;
import org.apache.directory.ldap.client.api.future.ResponseFuture;
import org.apache.directory.ldap.client.api.future.SearchFuture;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.future.CloseFuture;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.future.IoFuture;
import org.apache.mina.core.future.IoFutureListener;
import org.apache.mina.core.future.WriteFuture;
import org.apache.mina.core.service.IoConnector;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.FilterEvent;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.codec.ProtocolEncoderException;
import org.apache.mina.filter.ssl.SslEvent;
import org.apache.mina.filter.ssl.SslFilter;
import org.apache.mina.transport.socket.SocketSessionConfig;
import org.apache.mina.transport.socket.nio.NioSocketConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapNetworkConnection
extends AbstractLdapConnection
implements LdapAsyncConnection {
    private static final Logger LOG = LoggerFactory.getLogger(LdapNetworkConnection.class);
    private long timeout = 30000L;
    private LdapConnectionConfig config;
    private SocketSessionConfig connectionConfig;
    private IoConnector connector;
    private ReentrantLock connectorMutex = new ReentrantLock();
    private IoSession ldapSession;
    private Map<Integer, ResponseFuture<? extends Response>> futureMap = new ConcurrentHashMap<Integer, ResponseFuture<? extends Response>>();
    private List<String> supportedControls;
    private Entry rootDse;
    private AtomicBoolean authenticated = new AtomicBoolean(false);
    private AtomicBoolean connected = new AtomicBoolean(false);
    private List<ConnectionClosedEventListener> conCloseListeners;
    private IoFilter ldapProtocolFilter = new ProtocolCodecFilter(this.codec.getProtocolCodecFactory());
    private static final String SSL_FILTER_KEY = "sslFilter";
    private static final String EXCEPTION_KEY = "sessionException";
    private static final String KRB5_CONF = "java.security.krb5.conf";
    private HandshakeFuture handshakeFuture;
    static final String TIME_OUT_ERROR = I18n.err(I18n.ERR_04170_TIMEOUT_OCCURED, new Object[0]);
    static final String NO_RESPONSE_ERROR = I18n.err(I18n.ERR_04169_RESPONSE_QUEUE_EMPTIED, new Object[0]);

    public LdapNetworkConnection() {
        this(null, -1, false);
    }

    public LdapNetworkConnection(LdapConnectionConfig config) {
        this(config, LdapApiServiceFactory.getSingleton());
    }

    public LdapNetworkConnection(LdapConnectionConfig config, LdapApiService ldapApiService) {
        super(ldapApiService);
        this.config = config;
        if (config.getBinaryAttributeDetector() == null) {
            config.setBinaryAttributeDetector(new DefaultConfigurableBinaryAttributeDetector());
        }
        this.timeout = config.getTimeout();
    }

    public LdapNetworkConnection(boolean useSsl) {
        this(null, -1, useSsl);
    }

    public LdapNetworkConnection(boolean useSsl, LdapApiService ldapApiService) {
        this(null, -1, useSsl, ldapApiService);
    }

    public LdapNetworkConnection(String server) {
        this(server, -1, false);
    }

    public LdapNetworkConnection(String server, LdapApiService ldapApiService) {
        this(server, -1, false, ldapApiService);
    }

    public LdapNetworkConnection(String server, boolean useSsl) {
        this(server, -1, useSsl);
    }

    public LdapNetworkConnection(String server, boolean useSsl, LdapApiService ldapApiService) {
        this(server, -1, useSsl, ldapApiService);
    }

    public LdapNetworkConnection(String server, int port) {
        this(server, port, false);
    }

    public LdapNetworkConnection(String server, int port, LdapApiService ldapApiService) {
        this(server, port, false, ldapApiService);
    }

    public LdapNetworkConnection(String server, int port, boolean useSsl) {
        this(LdapNetworkConnection.buildConfig(server, port, useSsl));
    }

    public LdapNetworkConnection(String server, int port, TrustManager ... trustManagers) {
        this(LdapNetworkConnection.buildConfig(server, port, true));
        this.config.setTrustManagers(trustManagers);
    }

    public LdapNetworkConnection(String server, int port, boolean useSsl, LdapApiService ldapApiService) {
        this(LdapNetworkConnection.buildConfig(server, port, useSsl), ldapApiService);
    }

    private static LdapConnectionConfig buildConfig(String server, int port, boolean useSsl) {
        LdapConnectionConfig config = new LdapConnectionConfig();
        config.setUseSsl(useSsl);
        if (port != -1) {
            config.setLdapPort(port);
        } else if (useSsl) {
            config.setLdapPort(config.getDefaultLdapsPort());
        } else {
            config.setLdapPort(config.getDefaultLdapPort());
        }
        if (Strings.isEmpty(server)) {
            config.setLdapHost(Network.LOOPBACK_HOSTNAME);
        } else {
            config.setLdapHost(server);
        }
        config.setBinaryAttributeDetector(new DefaultConfigurableBinaryAttributeDetector());
        return config;
    }

    private void createConnector() throws LdapException {
        this.connector = new NioSocketConnector(1);
        if (this.connectionConfig != null) {
            ((SocketSessionConfig)this.connector.getSessionConfig()).setAll(this.connectionConfig);
        } else {
            ((SocketSessionConfig)this.connector.getSessionConfig()).setReuseAddress(true);
        }
        this.connector.getFilterChain().addLast("ldapCodec", this.ldapProtocolFilter);
        if (this.config.isUseSsl()) {
            this.addSslFilter();
        }
        this.connector.setHandler(this);
    }

    @Override
    public boolean isConnected() {
        return this.ldapSession != null && this.connected.get() && !this.ldapSession.isClosing();
    }

    @Override
    public boolean isAuthenticated() {
        return this.isConnected() && this.authenticated.get();
    }

    public boolean isSecured() {
        return this.isConnected() && this.ldapSession.isSecured();
    }

    private void checkSession() throws InvalidConnectionException {
        if (this.ldapSession == null) {
            throw new InvalidConnectionException(I18n.err(I18n.ERR_04104_NULL_CONNECTION_CANNOT_CONNECT, new Object[0]));
        }
        if (!this.connected.get()) {
            throw new InvalidConnectionException(I18n.err(I18n.ERR_04108_INVALID_CONNECTION, new Object[0]));
        }
    }

    private void addToFutureMap(int messageId, ResponseFuture<? extends Response> future) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg(I18n.MSG_04106_ADDING, messageId, future.getClass().getName()));
        }
        this.futureMap.put(messageId, future);
    }

    private ResponseFuture<? extends Response> getFromFutureMap(int messageId) {
        ResponseFuture<? extends Response> future = this.futureMap.remove(messageId);
        if (LOG.isDebugEnabled() && future != null) {
            LOG.debug(I18n.msg(I18n.MSG_04126_REMOVING, messageId, future.getClass().getName()));
        }
        return future;
    }

    private ResponseFuture<? extends Response> peekFromFutureMap(int messageId) {
        ResponseFuture<? extends Response> future = this.futureMap.get(messageId);
        if (LOG.isDebugEnabled() && future != null) {
            LOG.debug(I18n.msg(I18n.MSG_04119_GETTING, messageId, future.getClass().getName()));
        }
        return future;
    }

    public long getTimeout(long connectionTimoutInMS, int searchTimeLimitInSeconds) {
        if (searchTimeLimitInSeconds < 0) {
            return connectionTimoutInMS;
        }
        if (searchTimeLimitInSeconds == 0) {
            if (this.config.getTimeout() == 0L) {
                return Long.MAX_VALUE;
            }
            return this.config.getTimeout();
        }
        long searchTimeLimitInMS = (long)searchTimeLimitInSeconds * 1000L;
        return Math.max(searchTimeLimitInMS, connectionTimoutInMS);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean connect() throws LdapException {
        if (this.ldapSession != null && this.connected.get()) {
            return true;
        }
        if (this.connector == null) {
            this.createConnector();
        }
        InetSocketAddress address = new InetSocketAddress(this.config.getLdapHost(), this.config.getLdapPort());
        long maxRetry = System.currentTimeMillis() + this.timeout;
        ConnectFuture connectionFuture = null;
        boolean interrupted = false;
        while (maxRetry > System.currentTimeMillis() && !interrupted) {
            block30: {
                Throwable connectionException;
                connectionFuture = this.connector.connect(address);
                if (this.config.isUseSsl()) {
                    try {
                        boolean isSecured = this.handshakeFuture.get(this.timeout, TimeUnit.MILLISECONDS);
                        if (!isSecured) {
                            throw new LdapOperationException(ResultCodeEnum.OTHER, I18n.err(I18n.ERR_04120_TLS_HANDSHAKE_ERROR, new Object[0]));
                        }
                    }
                    catch (Exception e) {
                        String msg = I18n.err(I18n.ERR_04122_SSL_CONTEXT_INIT_FAILURE, new Object[0]);
                        LOG.error(msg, e);
                        throw new LdapException(msg, e);
                    }
                }
                boolean result = false;
                try {
                    result = connectionFuture.await(this.timeout);
                    if (!result) continue;
                    boolean isConnected = connectionFuture.isConnected();
                    if (isConnected) break;
                    connectionException = connectionFuture.getException();
                    if (!LOG.isDebugEnabled()) break block30;
                }
                catch (InterruptedException e) {
                    try {
                        this.connector.dispose();
                        this.connector = null;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug(I18n.msg(I18n.MSG_04120_INTERRUPTED_WAITING_FOR_CONNECTION, this.config.getLdapHost(), this.config.getLdapPort()), e);
                        }
                        interrupted = true;
                        throw new LdapOtherException(e.getMessage(), e);
                    }
                    catch (Throwable throwable) {
                        if (!result) throw throwable;
                        boolean isConnected = connectionFuture.isConnected();
                        if (isConnected) break;
                        Throwable connectionException2 = connectionFuture.getException();
                        if (LOG.isDebugEnabled()) {
                            if (connectionException2 instanceof ConnectException || connectionException2 instanceof UnresolvedAddressException) {
                                LOG.debug(I18n.msg(I18n.MSG_04144_CONNECTION_ERROR, connectionFuture.getException().getMessage()));
                            }
                            LOG.debug(I18n.msg(I18n.MSG_04143_CONNECTION_RETRYING, new Object[0]));
                        }
                        try {
                            Thread.sleep(500L);
                            throw throwable;
                        }
                        catch (InterruptedException e2) {
                            this.connector = null;
                            if (LOG.isDebugEnabled()) {
                                LOG.debug(I18n.msg(I18n.MSG_04120_INTERRUPTED_WAITING_FOR_CONNECTION, this.config.getLdapHost(), this.config.getLdapPort()), e2);
                            }
                            interrupted = true;
                            throw new LdapOtherException(e2.getMessage(), e2);
                        }
                    }
                }
                if (connectionException instanceof ConnectException || connectionException instanceof UnresolvedAddressException) {
                    LOG.debug(I18n.msg(I18n.MSG_04144_CONNECTION_ERROR, connectionFuture.getException().getMessage()));
                }
                LOG.debug(I18n.msg(I18n.MSG_04143_CONNECTION_RETRYING, new Object[0]));
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                this.connector = null;
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.msg(I18n.MSG_04120_INTERRUPTED_WAITING_FOR_CONNECTION, this.config.getLdapHost(), this.config.getLdapPort()), e);
                }
                interrupted = true;
                throw new LdapOtherException(e.getMessage(), e);
            }
        }
        if (connectionFuture == null) {
            this.connector.dispose();
            throw new InvalidConnectionException(I18n.err(I18n.ERR_04109_CANNOT_CONNECT, new Object[0]));
        }
        boolean isConnected = connectionFuture.isConnected();
        if (!isConnected) {
            try {
                this.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            Throwable e = connectionFuture.getException();
            if (e == null) return false;
            if (e instanceof UnresolvedAddressException && e.getMessage() == null) {
                throw new InvalidConnectionException(I18n.err(I18n.ERR_04121_CANNOT_RESOLVE_HOSTNAME, this.config.getLdapHost()), e);
            }
            throw new InvalidConnectionException(I18n.err(I18n.ERR_04110_CANNOT_CONNECT_TO_SERVER, e.getMessage()), e);
        }
        CloseFuture closeFuture = connectionFuture.getSession().getCloseFuture();
        closeFuture.addListener(new IoFutureListener<IoFuture>(){

            @Override
            public void operationComplete(IoFuture future) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.msg(I18n.MSG_04137_NOD_RECEIVED, new Object[0]));
                }
                for (ResponseFuture responseFuture : LdapNetworkConnection.this.futureMap.values()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(I18n.msg(I18n.MSG_04134_CLOSING, responseFuture));
                    }
                    responseFuture.cancel();
                    try {
                        if (responseFuture instanceof AddFuture) {
                            ((AddFuture)responseFuture).set(AddNoDResponse.PROTOCOLERROR);
                        } else if (responseFuture instanceof BindFuture) {
                            ((BindFuture)responseFuture).set(BindNoDResponse.PROTOCOLERROR);
                        } else if (responseFuture instanceof CompareFuture) {
                            ((CompareFuture)responseFuture).set(CompareNoDResponse.PROTOCOLERROR);
                        } else if (responseFuture instanceof DeleteFuture) {
                            ((DeleteFuture)responseFuture).set(DeleteNoDResponse.PROTOCOLERROR);
                        } else if (responseFuture instanceof ExtendedFuture) {
                            ((ExtendedFuture)responseFuture).set(ExtendedNoDResponse.PROTOCOLERROR);
                        } else if (responseFuture instanceof ModifyFuture) {
                            ((ModifyFuture)responseFuture).set(ModifyNoDResponse.PROTOCOLERROR);
                        } else if (responseFuture instanceof ModifyDnFuture) {
                            ((ModifyDnFuture)responseFuture).set(ModifyDnNoDResponse.PROTOCOLERROR);
                        } else if (responseFuture instanceof SearchFuture) {
                            ((SearchFuture)responseFuture).set(SearchNoDResponse.PROTOCOLERROR);
                        }
                    }
                    catch (InterruptedException e) {
                        LOG.error(I18n.err(I18n.ERR_04113_ERROR_PROCESSING_NOD, responseFuture), e);
                    }
                    LdapNetworkConnection.this.futureMap.remove(LdapNetworkConnection.this.messageId.get());
                }
                LdapNetworkConnection.this.futureMap.clear();
            }
        });
        this.ldapSession = connectionFuture.getSession();
        LdapMessageContainer container = (LdapMessageContainer)this.ldapSession.getAttribute("LDAP-container");
        if (container != null) {
            if (this.schemaManager != null && !(container.getBinaryAttributeDetector() instanceof SchemaBinaryAttributeDetector)) {
                container.setBinaryAttributeDetector(new SchemaBinaryAttributeDetector(this.schemaManager));
            }
        } else {
            SchemaBinaryAttributeDetector atDetector = new DefaultConfigurableBinaryAttributeDetector();
            if (this.schemaManager != null) {
                atDetector = new SchemaBinaryAttributeDetector(this.schemaManager);
            }
            this.ldapSession.setAttribute("LDAP-container", new LdapMessageContainer(this.codec, atDetector));
        }
        this.messageId.set(0);
        return true;
    }

    @Override
    public void close() throws IOException {
        if (this.ldapSession != null && this.connected.get()) {
            this.ldapSession.closeNow();
            this.connected.set(false);
        }
        this.connectorMutex.lock();
        try {
            if (this.connector != null) {
                this.connector.dispose();
                this.connector = null;
            }
        }
        finally {
            this.connectorMutex.unlock();
        }
        this.messageId.set(0);
    }

    @Override
    public void add(Entry entry) throws LdapException {
        if (entry == null) {
            String msg = I18n.err(I18n.ERR_04123_CANNOT_ADD_EMPTY_ENTRY, new Object[0]);
            if (LOG.isDebugEnabled()) {
                LOG.debug(msg);
            }
            throw new IllegalArgumentException(msg);
        }
        AddRequestImpl addRequest = new AddRequestImpl();
        addRequest.setEntry(entry);
        AddResponse addResponse = this.add(addRequest);
        ResultCodeEnum.processResponse(addResponse);
    }

    @Override
    public AddFuture addAsync(Entry entry) throws LdapException {
        if (entry == null) {
            String msg = I18n.err(I18n.ERR_04125_CANNOT_ADD_NULL_ENTRY, new Object[0]);
            if (LOG.isDebugEnabled()) {
                LOG.debug(msg);
            }
            throw new IllegalArgumentException(msg);
        }
        AddRequestImpl addRequest = new AddRequestImpl();
        addRequest.setEntry(entry);
        return this.addAsync(addRequest);
    }

    @Override
    public AddResponse add(AddRequest addRequest) throws LdapException {
        if (addRequest == null) {
            String msg = I18n.err(I18n.ERR_04124_CANNOT_PROCESS_NULL_ADD_REQUEST, new Object[0]);
            if (LOG.isDebugEnabled()) {
                LOG.debug(msg);
            }
            throw new IllegalArgumentException(msg);
        }
        if (addRequest.getEntry() == null) {
            String msg = I18n.err(I18n.ERR_04125_CANNOT_ADD_NULL_ENTRY, new Object[0]);
            if (LOG.isDebugEnabled()) {
                LOG.debug(msg);
            }
            throw new IllegalArgumentException(msg);
        }
        AddFuture addFuture = this.addAsync(addRequest);
        try {
            AddResponse addResponse = (AddResponse)addFuture.get(this.timeout, TimeUnit.MILLISECONDS);
            if (addResponse == null) {
                if (LOG.isErrorEnabled()) {
                    LOG.error(I18n.err(I18n.ERR_04112_OP_FAILED_TIMEOUT, "Add"));
                }
                throw new LdapException(TIME_OUT_ERROR);
            }
            if (addResponse.getLdapResult().getResultCode() == ResultCodeEnum.SUCCESS) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.msg(I18n.MSG_04108_ADD_SUCCESSFUL, addResponse));
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.msg(I18n.MSG_04107_ADD_FAILED, addResponse));
            }
            return addResponse;
        }
        catch (Exception ie) {
            LOG.error(NO_RESPONSE_ERROR, ie);
            if (!addFuture.isCancelled()) {
                this.abandon(addRequest.getMessageId());
            }
            throw new LdapException(NO_RESPONSE_ERROR, ie);
        }
    }

    @Override
    public AddFuture addAsync(AddRequest addRequest) throws LdapException {
        if (addRequest == null) {
            String msg = I18n.err(I18n.ERR_04124_CANNOT_PROCESS_NULL_ADD_REQUEST, new Object[0]);
            if (LOG.isDebugEnabled()) {
                LOG.debug(msg);
            }
            throw new IllegalArgumentException(msg);
        }
        if (addRequest.getEntry() == null) {
            String msg = I18n.err(I18n.ERR_04125_CANNOT_ADD_NULL_ENTRY, new Object[0]);
            if (LOG.isDebugEnabled()) {
                LOG.debug(msg);
            }
            throw new IllegalArgumentException(msg);
        }
        this.connect();
        this.checkSession();
        int newId = this.messageId.incrementAndGet();
        addRequest.setMessageId(newId);
        AddFuture addFuture = new AddFuture(this, newId);
        this.addToFutureMap(newId, addFuture);
        this.writeRequest(addRequest);
        return addFuture;
    }

    @Override
    public void abandon(int messageId) {
        if (messageId < 0) {
            String msg = I18n.err(I18n.ERR_04126_CANNOT_ABANDON_NEG_MSG_ID, new Object[0]);
            if (LOG.isDebugEnabled()) {
                LOG.debug(msg);
            }
            throw new IllegalArgumentException(msg);
        }
        AbandonRequestImpl abandonRequest = new AbandonRequestImpl();
        abandonRequest.setAbandoned(messageId);
        this.abandonInternal(abandonRequest);
    }

    @Override
    public void abandon(AbandonRequest abandonRequest) {
        if (abandonRequest == null) {
            String msg = I18n.err(I18n.ERR_04127_CANNOT_PROCESS_NULL_ABANDON_REQ, new Object[0]);
            if (LOG.isDebugEnabled()) {
                LOG.debug(msg);
            }
            throw new IllegalArgumentException(msg);
        }
        this.abandonInternal(abandonRequest);
    }

    private void abandonInternal(AbandonRequest abandonRequest) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg(I18n.MSG_04104_SENDING_REQUEST, abandonRequest));
        }
        int newId = this.messageId.incrementAndGet();
        abandonRequest.setMessageId(newId);
        this.ldapSession.write(abandonRequest);
        int abandonId = abandonRequest.getAbandoned();
        ResponseFuture<? extends Response> rf = this.getFromFutureMap(abandonId);
        if (rf != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.msg(I18n.MSG_04141_SENDING_CANCEL, new Object[0]));
            }
            rf.cancel(true);
        } else {
            LOG.warn(I18n.msg(I18n.MSG_04165_NO_FUTURE_ASSOCIATED_TO_MSG_ID_COMPLETED, abandonId));
        }
    }

    @Override
    public void bind() throws LdapException {
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg(I18n.MSG_04112_BIND, new Object[0]));
        }
        BindRequest bindRequest = this.createBindRequest(this.config.getName(), Strings.getBytesUtf8(this.config.getCredentials()));
        BindResponse bindResponse = this.bind(bindRequest);
        ResultCodeEnum.processResponse(bindResponse);
    }

    @Override
    public void anonymousBind() throws LdapException {
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg(I18n.MSG_04109_ANONYMOUS_BIND, new Object[0]));
        }
        BindRequest bindRequest = this.createBindRequest("", Strings.EMPTY_BYTES);
        BindResponse bindResponse = this.bind(bindRequest);
        ResultCodeEnum.processResponse(bindResponse);
    }

    @Override
    public BindFuture bindAsync() throws LdapException {
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg(I18n.MSG_04111_ASYNC_BIND, new Object[0]));
        }
        BindRequest bindRequest = this.createBindRequest(this.config.getName(), Strings.getBytesUtf8(this.config.getCredentials()));
        return this.bindAsync(bindRequest);
    }

    @Override
    public BindFuture anonymousBindAsync() throws LdapException {
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg(I18n.MSG_04110_ANONYMOUS_ASYNC_BIND, new Object[0]));
        }
        BindRequest bindRequest = this.createBindRequest("", Strings.EMPTY_BYTES);
        return this.bindAsync(bindRequest);
    }

    public BindFuture bindAsync(String name) throws LdapException {
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg(I18n.MSG_04102_BIND_REQUEST, name));
        }
        BindRequest bindRequest = this.createBindRequest(name, Strings.EMPTY_BYTES);
        return this.bindAsync(bindRequest);
    }

    @Override
    public BindFuture bindAsync(String name, String credentials) throws LdapException {
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg(I18n.MSG_04102_BIND_REQUEST, name));
        }
        if (Strings.isEmpty(credentials) && Strings.isNotEmpty(name)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.msg(I18n.MSG_04105_MISSING_PASSWORD, new Object[0]));
            }
            throw new LdapAuthenticationException(I18n.msg(I18n.MSG_04105_MISSING_PASSWORD, new Object[0]));
        }
        BindRequest bindRequest = this.createBindRequest(name, Strings.getBytesUtf8(credentials));
        return this.bindAsync(bindRequest);
    }

    public BindFuture bindAsync(Dn name) throws LdapException {
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg(I18n.MSG_04102_BIND_REQUEST, name));
        }
        BindRequest bindRequest = this.createBindRequest(name, Strings.EMPTY_BYTES);
        return this.bindAsync(bindRequest);
    }

    @Override
    public BindFuture bindAsync(Dn name, String credentials) throws LdapException {
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg(I18n.MSG_04102_BIND_REQUEST, name));
        }
        if (Strings.isEmpty(credentials) && !Dn.EMPTY_DN.equals(name)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.msg(I18n.MSG_04105_MISSING_PASSWORD, new Object[0]));
            }
            throw new LdapAuthenticationException(I18n.msg(I18n.MSG_04105_MISSING_PASSWORD, new Object[0]));
        }
        BindRequest bindRequest = this.createBindRequest(name, Strings.getBytesUtf8(credentials));
        return this.bindAsync(bindRequest);
    }

    @Override
    public BindResponse bind(BindRequest bindRequest) throws LdapException {
        if (bindRequest == null) {
            String msg = I18n.err(I18n.ERR_04128_CANNOT_PROCESS_NULL_BIND_REQ, new Object[0]);
            if (LOG.isDebugEnabled()) {
                LOG.debug(msg);
            }
            throw new IllegalArgumentException(msg);
        }
        BindFuture bindFuture = this.bindAsync(bindRequest);
        try {
            BindResponse bindResponse = (BindResponse)bindFuture.get(this.timeout, TimeUnit.MILLISECONDS);
            if (bindResponse == null) {
                if (LOG.isErrorEnabled()) {
                    LOG.error(I18n.err(I18n.ERR_04112_OP_FAILED_TIMEOUT, "Bind"));
                }
                throw new LdapException(TIME_OUT_ERROR);
            }
            if (bindResponse.getLdapResult().getResultCode() == ResultCodeEnum.SUCCESS) {
                this.authenticated.set(true);
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.msg(I18n.MSG_04101_BIND_SUCCESSFUL, bindResponse));
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.msg(I18n.MSG_04100_BIND_FAIL, bindResponse));
            }
            return bindResponse;
        }
        catch (Exception ie) {
            LOG.error(NO_RESPONSE_ERROR, ie);
            throw new LdapException(NO_RESPONSE_ERROR, ie);
        }
    }

    private BindRequest createBindRequest(String name, byte[] credentials) {
        return this.createBindRequest(name, credentials, null, null);
    }

    private BindRequest createBindRequest(Dn name, byte[] credentials) {
        return this.createBindRequest(name.getName(), credentials, null, null);
    }

    @Override
    public BindFuture bindAsync(BindRequest bindRequest) throws LdapException {
        if (bindRequest == null) {
            String msg = I18n.err(I18n.ERR_04128_CANNOT_PROCESS_NULL_BIND_REQ, new Object[0]);
            if (LOG.isDebugEnabled()) {
                LOG.debug(msg);
            }
            throw new IllegalArgumentException(msg);
        }
        this.authenticated.set(false);
        this.connect();
        if (this.config.isUseTls() && !this.config.isUseSsl()) {
            this.startTls();
        }
        this.checkSession();
        int newId = this.messageId.incrementAndGet();
        bindRequest.setMessageId(newId);
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg(I18n.MSG_04104_SENDING_REQUEST, bindRequest));
        }
        BindFuture bindFuture = new BindFuture(this, newId);
        this.addToFutureMap(newId, bindFuture);
        this.writeRequest(bindRequest);
        return bindFuture;
    }

    public BindResponse bindSaslPlain(String authcid, String credentials) throws LdapException {
        return this.bindSaslPlain(null, authcid, credentials);
    }

    public BindResponse bindSaslPlain(String authzid, String authcid, String credentials) throws LdapException {
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg(I18n.MSG_04127_SASL_PLAIN_BIND, new Object[0]));
        }
        SaslPlainRequest saslRequest = new SaslPlainRequest();
        saslRequest.setAuthorizationId(authzid);
        saslRequest.setUsername(authcid);
        saslRequest.setCredentials(credentials);
        BindFuture bindFuture = this.bindAsync(saslRequest);
        try {
            BindResponse bindResponse = (BindResponse)bindFuture.get(this.timeout, TimeUnit.MILLISECONDS);
            if (bindResponse == null) {
                if (LOG.isErrorEnabled()) {
                    LOG.error(I18n.err(I18n.ERR_04112_OP_FAILED_TIMEOUT, "Bind"));
                }
                throw new LdapException(TIME_OUT_ERROR);
            }
            if (bindResponse.getLdapResult().getResultCode() == ResultCodeEnum.SUCCESS) {
                this.authenticated.set(true);
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.msg(I18n.MSG_04101_BIND_SUCCESSFUL, bindResponse));
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.msg(I18n.MSG_04100_BIND_FAIL, bindResponse));
            }
            return bindResponse;
        }
        catch (Exception ie) {
            LOG.error(NO_RESPONSE_ERROR, ie);
            throw new LdapException(NO_RESPONSE_ERROR, ie);
        }
    }

    @Override
    public BindResponse bind(SaslRequest request) throws LdapException {
        if (request == null) {
            String msg = I18n.msg(I18n.MSG_04103_NULL_REQUEST, new Object[0]);
            if (LOG.isDebugEnabled()) {
                LOG.debug(msg);
            }
            throw new IllegalArgumentException(msg);
        }
        BindFuture bindFuture = this.bindAsync(request);
        try {
            BindResponse bindResponse = (BindResponse)bindFuture.get(this.timeout, TimeUnit.MILLISECONDS);
            if (bindResponse == null) {
                if (LOG.isErrorEnabled()) {
                    LOG.error(I18n.err(I18n.ERR_04112_OP_FAILED_TIMEOUT, "Bind"));
                }
                throw new LdapException(TIME_OUT_ERROR);
            }
            if (bindResponse.getLdapResult().getResultCode() == ResultCodeEnum.SUCCESS) {
                this.authenticated.set(true);
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.msg(I18n.MSG_04101_BIND_SUCCESSFUL, bindResponse));
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.msg(I18n.MSG_04100_BIND_FAIL, bindResponse));
            }
            return bindResponse;
        }
        catch (Exception ie) {
            LOG.error(NO_RESPONSE_ERROR, ie);
            throw new LdapException(NO_RESPONSE_ERROR, ie);
        }
    }

    public BindResponse bindSaslCramMd5(String userName, String credentials) throws LdapException {
        SaslCramMd5Request request = new SaslCramMd5Request();
        request.setUsername(userName);
        request.setCredentials("secret");
        return this.bind(request);
    }

    public BindResponse bindSaslDigestMd5(String userName, String credentials) throws LdapException {
        SaslDigestMd5Request request = new SaslDigestMd5Request();
        request.setUsername(userName);
        request.setCredentials("secret");
        return this.bind(request);
    }

    public BindResponse bind(SaslCramMd5Request request) throws LdapException {
        if (request == null) {
            String msg = I18n.msg(I18n.MSG_04103_NULL_REQUEST, new Object[0]);
            if (LOG.isDebugEnabled()) {
                LOG.debug(msg);
            }
            throw new IllegalArgumentException(msg);
        }
        BindFuture bindFuture = this.bindAsync(request);
        try {
            BindResponse bindResponse = (BindResponse)bindFuture.get(this.timeout, TimeUnit.MILLISECONDS);
            if (bindResponse == null) {
                if (LOG.isErrorEnabled()) {
                    LOG.error(I18n.err(I18n.ERR_04112_OP_FAILED_TIMEOUT, "Bind"));
                }
                throw new LdapException(TIME_OUT_ERROR);
            }
            if (bindResponse.getLdapResult().getResultCode() == ResultCodeEnum.SUCCESS) {
                this.authenticated.set(true);
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.msg(I18n.MSG_04101_BIND_SUCCESSFUL, bindResponse));
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.msg(I18n.MSG_04100_BIND_FAIL, bindResponse));
            }
            return bindResponse;
        }
        catch (Exception ie) {
            LOG.error(NO_RESPONSE_ERROR, ie);
            throw new LdapException(NO_RESPONSE_ERROR, ie);
        }
    }

    public BindFuture bindAsync(SaslRequest request) throws LdapException {
        return this.bindSasl(request);
    }

    public BindResponse bind(SaslDigestMd5Request request) throws LdapException {
        if (request == null) {
            String msg = I18n.msg(I18n.MSG_04103_NULL_REQUEST, new Object[0]);
            if (LOG.isDebugEnabled()) {
                LOG.debug(msg);
            }
            throw new IllegalArgumentException(msg);
        }
        BindFuture bindFuture = this.bindAsync(request);
        try {
            BindResponse bindResponse = (BindResponse)bindFuture.get(this.timeout, TimeUnit.MILLISECONDS);
            if (bindResponse == null) {
                if (LOG.isErrorEnabled()) {
                    LOG.error(I18n.err(I18n.ERR_04112_OP_FAILED_TIMEOUT, "Bind"));
                }
                throw new LdapException(TIME_OUT_ERROR);
            }
            if (bindResponse.getLdapResult().getResultCode() == ResultCodeEnum.SUCCESS) {
                this.authenticated.set(true);
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.msg(I18n.MSG_04101_BIND_SUCCESSFUL, bindResponse));
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.msg(I18n.MSG_04100_BIND_FAIL, bindResponse));
            }
            return bindResponse;
        }
        catch (Exception ie) {
            LOG.error(NO_RESPONSE_ERROR, ie);
            throw new LdapException(NO_RESPONSE_ERROR, ie);
        }
    }

    public BindResponse bind(SaslGssApiRequest request) throws LdapException {
        if (request == null) {
            String msg = I18n.msg(I18n.MSG_04103_NULL_REQUEST, new Object[0]);
            if (LOG.isDebugEnabled()) {
                LOG.debug(msg);
            }
            throw new IllegalArgumentException(msg);
        }
        BindFuture bindFuture = this.bindAsync(request);
        try {
            BindResponse bindResponse = (BindResponse)bindFuture.get(this.timeout, TimeUnit.MILLISECONDS);
            if (bindResponse == null) {
                if (LOG.isErrorEnabled()) {
                    LOG.error(I18n.err(I18n.ERR_04112_OP_FAILED_TIMEOUT, "Bind"));
                }
                throw new LdapException(TIME_OUT_ERROR);
            }
            if (bindResponse.getLdapResult().getResultCode() == ResultCodeEnum.SUCCESS) {
                this.authenticated.set(true);
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.msg(I18n.MSG_04101_BIND_SUCCESSFUL, bindResponse));
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.msg(I18n.MSG_04100_BIND_FAIL, bindResponse));
            }
            return bindResponse;
        }
        catch (Exception ie) {
            LOG.error(NO_RESPONSE_ERROR, ie);
            throw new LdapException(NO_RESPONSE_ERROR, ie);
        }
    }

    public BindResponse bind(SaslExternalRequest request) throws LdapException {
        if (request == null) {
            String msg = I18n.msg(I18n.MSG_04103_NULL_REQUEST, new Object[0]);
            if (LOG.isDebugEnabled()) {
                LOG.debug(msg);
            }
            throw new IllegalArgumentException(msg);
        }
        BindFuture bindFuture = this.bindAsync(request);
        try {
            BindResponse bindResponse = (BindResponse)bindFuture.get(this.timeout, TimeUnit.MILLISECONDS);
            if (bindResponse == null) {
                if (LOG.isErrorEnabled()) {
                    LOG.error(I18n.err(I18n.ERR_04112_OP_FAILED_TIMEOUT, "Bind"));
                }
                throw new LdapException(TIME_OUT_ERROR);
            }
            if (bindResponse.getLdapResult().getResultCode() == ResultCodeEnum.SUCCESS) {
                this.authenticated.set(true);
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.msg(I18n.MSG_04101_BIND_SUCCESSFUL, bindResponse));
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.msg(I18n.MSG_04100_BIND_FAIL, bindResponse));
            }
            return bindResponse;
        }
        catch (Exception ie) {
            LOG.error(NO_RESPONSE_ERROR, ie);
            throw new LdapException(NO_RESPONSE_ERROR, ie);
        }
    }

    public BindFuture bindAsync(SaslGssApiRequest request) throws LdapException {
        if (request.getKrb5ConfFilePath() != null) {
            System.setProperty(KRB5_CONF, request.getKrb5ConfFilePath());
        } else if (request.getRealmName() != null && request.getKdcHost() != null && request.getKdcPort() != 0) {
            try {
                String krb5ConfPath = this.createKrb5ConfFile(request.getRealmName(), request.getKdcHost(), request.getKdcPort());
                System.setProperty(KRB5_CONF, krb5ConfPath);
            }
            catch (IOException ioe) {
                throw new LdapException(ioe);
            }
        } else {
            System.clearProperty(KRB5_CONF);
        }
        if (request.getLoginModuleConfiguration() != null) {
            Configuration.setConfiguration(request.getLoginModuleConfiguration());
        } else {
            Configuration.setConfiguration(new Krb5LoginConfiguration());
        }
        try {
            System.setProperty("javax.security.auth.useSubjectCredsOnly", "true");
            LoginContext loginContext = new LoginContext(request.getLoginContextName(), new SaslCallbackHandler(request));
            loginContext.login();
            final SaslGssApiRequest requetFinal = request;
            return (BindFuture)Subject.doAs(loginContext.getSubject(), new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    return LdapNetworkConnection.this.bindSasl(requetFinal);
                }
            });
        }
        catch (Exception e) {
            throw new LdapException(e);
        }
    }

    @Override
    public EntryCursor search(Dn baseDn, String filter, SearchScope scope, String ... attributes) throws LdapException {
        if (baseDn == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.msg(I18n.MSG_04138_NULL_DN_SEARCH, new Object[0]));
            }
            throw new IllegalArgumentException(I18n.err(I18n.ERR_04129_NULL_BASE_DN, new Object[0]));
        }
        SearchRequestImpl searchRequest = new SearchRequestImpl();
        searchRequest.setBase(baseDn);
        searchRequest.setFilter(filter);
        searchRequest.setScope(scope);
        searchRequest.addAttributes(attributes);
        searchRequest.setDerefAliases(AliasDerefMode.DEREF_ALWAYS);
        return new EntryCursorImpl(this.search(searchRequest));
    }

    @Override
    public EntryCursor search(String baseDn, String filter, SearchScope scope, String ... attributes) throws LdapException {
        return this.search(new Dn(baseDn), filter, scope, attributes);
    }

    @Override
    public SearchFuture searchAsync(Dn baseDn, String filter, SearchScope scope, String ... attributes) throws LdapException {
        SearchRequestImpl searchRequest = new SearchRequestImpl();
        searchRequest.setBase(baseDn);
        searchRequest.setFilter(filter);
        searchRequest.setScope(scope);
        searchRequest.addAttributes(attributes);
        searchRequest.setDerefAliases(AliasDerefMode.DEREF_ALWAYS);
        return this.searchAsync(searchRequest);
    }

    @Override
    public SearchFuture searchAsync(String baseDn, String filter, SearchScope scope, String ... attributes) throws LdapException {
        return this.searchAsync(new Dn(baseDn), filter, scope, attributes);
    }

    @Override
    public SearchFuture searchAsync(SearchRequest searchRequest) throws LdapException {
        if (searchRequest == null) {
            String msg = I18n.err(I18n.ERR_04130_CANNOT_PROCESS_NULL_SEARCH_REQ, new Object[0]);
            if (LOG.isDebugEnabled()) {
                LOG.debug(msg);
            }
            throw new IllegalArgumentException(msg);
        }
        if (searchRequest.getBase() == null) {
            String msg = I18n.err(I18n.ERR_04131_CANNOT_PROCESS_SEARCH_NULL_DN, new Object[0]);
            if (LOG.isDebugEnabled()) {
                LOG.debug(msg);
            }
            throw new IllegalArgumentException(msg);
        }
        this.connect();
        this.checkSession();
        int newId = this.messageId.incrementAndGet();
        searchRequest.setMessageId(newId);
        if (searchRequest.isIgnoreReferrals()) {
            searchRequest.addControl(new ManageDsaITImpl());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg(I18n.MSG_04104_SENDING_REQUEST, searchRequest));
        }
        SearchFuture searchFuture = new SearchFuture(this, searchRequest.getMessageId());
        this.addToFutureMap(searchRequest.getMessageId(), searchFuture);
        this.writeRequest(searchRequest);
        if (searchFuture.isCancelled()) {
            throw new LdapException(searchFuture.getCause());
        }
        return searchFuture;
    }

    @Override
    public SearchCursor search(SearchRequest searchRequest) throws LdapException {
        if (searchRequest == null) {
            String msg = I18n.err(I18n.ERR_04130_CANNOT_PROCESS_NULL_SEARCH_REQ, new Object[0]);
            if (LOG.isDebugEnabled()) {
                LOG.debug(msg);
            }
            throw new IllegalArgumentException(msg);
        }
        SearchFuture searchFuture = this.searchAsync(searchRequest);
        long searchTimeout = this.getTimeout(this.timeout, searchRequest.getTimeLimit());
        return new SearchCursorImpl(searchFuture, searchTimeout, TimeUnit.MILLISECONDS);
    }

    @Override
    public void unBind() throws LdapException {
        this.checkSession();
        int newId = this.messageId.incrementAndGet();
        UnbindRequestImpl unbindRequest = new UnbindRequestImpl();
        unbindRequest.setMessageId(newId);
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg(I18n.MSG_04132_SENDING_UNBIND, unbindRequest));
        }
        WriteFuture unbindFuture = this.ldapSession.write(unbindRequest);
        unbindFuture.awaitUninterruptibly(this.timeout);
        this.authenticated.set(false);
        for (ResponseFuture<? extends Response> responseFuture : this.futureMap.values()) {
            responseFuture.cancel();
        }
        this.clearMaps();
        try {
            this.close();
        }
        catch (IOException e) {
            LOG.error(e.getMessage());
            throw new LdapException(e.getMessage());
        }
        this.connected.set(false);
        this.messageId.set(0);
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg(I18n.MSG_04133_UNBINDSUCCESSFUL, new Object[0]));
        }
    }

    public void setConnector(IoConnector connector) {
        this.connector = connector;
    }

    @Override
    public void setTimeOut(long timeout) {
        this.timeout = timeout <= 0L ? 3153600000000L : timeout;
    }

    @Override
    public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
        Throwable realCause;
        if (LOG.isWarnEnabled()) {
            LOG.warn(cause.getMessage(), cause);
        }
        session.setAttribute(EXCEPTION_KEY, cause);
        if (cause instanceof ProtocolEncoderException && (realCause = ((ProtocolEncoderException)cause).getCause()) instanceof MessageEncoderException) {
            int messageId = ((MessageEncoderException)realCause).getMessageId();
            ResponseFuture<? extends Response> response = this.futureMap.get(messageId);
            response.cancel(true);
            response.setCause(realCause);
        }
        session.closeNow();
    }

    private boolean isNoticeOfDisconnect(Message message) {
        String responseName;
        return message instanceof ExtendedResponse && "1.3.6.1.4.1.1466.20036".equals(responseName = ((ExtendedResponse)message).getResponseName());
    }

    @Override
    public void messageReceived(IoSession session, Object message) throws Exception {
        Message response = (Message)message;
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg(I18n.MSG_04142_MESSAGE_RECEIVED, response));
        }
        int messageId = response.getMessageId();
        ResponseFuture<? extends Response> responseFuture = this.peekFromFutureMap(messageId);
        boolean isNoD = this.isNoticeOfDisconnect(response);
        if (responseFuture == null && !isNoD) {
            if (LOG.isInfoEnabled()) {
                LOG.info(I18n.msg(I18n.MSG_04166_NO_FUTURE_ASSOCIATED_TO_MSG_ID_IGNORING, messageId));
            }
            return;
        }
        if (isNoD) {
            session.closeNow();
            return;
        }
        switch (response.getType()) {
            case ADD_RESPONSE: {
                AddResponse addResponse = (AddResponse)response;
                AddFuture addFuture = (AddFuture)responseFuture;
                if (LOG.isDebugEnabled()) {
                    if (addResponse.getLdapResult().getResultCode() == ResultCodeEnum.SUCCESS) {
                        LOG.debug(I18n.msg(I18n.MSG_04108_ADD_SUCCESSFUL, addResponse));
                    } else {
                        LOG.debug(I18n.msg(I18n.MSG_04107_ADD_FAILED, addResponse));
                    }
                }
                addFuture.set(addResponse);
                this.removeFromFutureMaps(messageId);
                break;
            }
            case BIND_RESPONSE: {
                BindResponse bindResponse = (BindResponse)response;
                BindFuture bindFuture = (BindFuture)responseFuture;
                if (bindResponse.getLdapResult().getResultCode() == ResultCodeEnum.SUCCESS) {
                    this.authenticated.set(true);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(I18n.msg(I18n.MSG_04101_BIND_SUCCESSFUL, bindResponse));
                    }
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.msg(I18n.MSG_04100_BIND_FAIL, bindResponse));
                }
                bindFuture.set(bindResponse);
                this.removeFromFutureMaps(messageId);
                break;
            }
            case COMPARE_RESPONSE: {
                CompareResponse compareResponse = (CompareResponse)response;
                CompareFuture compareFuture = (CompareFuture)responseFuture;
                if (LOG.isDebugEnabled()) {
                    if (compareResponse.getLdapResult().getResultCode() == ResultCodeEnum.SUCCESS) {
                        LOG.debug(I18n.msg(I18n.MSG_04114_COMPARE_SUCCESSFUL, compareResponse));
                    } else {
                        LOG.debug(I18n.msg(I18n.MSG_04113_COMPARE_FAILED, compareResponse));
                    }
                }
                compareFuture.set(compareResponse);
                this.removeFromFutureMaps(messageId);
                break;
            }
            case DEL_RESPONSE: {
                DeleteResponse deleteResponse = (DeleteResponse)response;
                DeleteFuture deleteFuture = (DeleteFuture)responseFuture;
                if (LOG.isDebugEnabled()) {
                    if (deleteResponse.getLdapResult().getResultCode() == ResultCodeEnum.SUCCESS) {
                        LOG.debug(I18n.msg(I18n.MSG_04116_DELETE_SUCCESSFUL, deleteResponse));
                    } else {
                        LOG.debug(I18n.msg(I18n.MSG_04115_DELETE_FAILED, deleteResponse));
                    }
                }
                deleteFuture.set(deleteResponse);
                this.removeFromFutureMaps(messageId);
                break;
            }
            case EXTENDED_RESPONSE: {
                ExtendedResponse extendedResponse = (ExtendedResponse)response;
                ExtendedFuture extendedFuture = (ExtendedFuture)responseFuture;
                if (LOG.isDebugEnabled()) {
                    if (extendedResponse.getLdapResult().getResultCode() == ResultCodeEnum.SUCCESS) {
                        LOG.debug(I18n.msg(I18n.MSG_04118_EXTENDED_SUCCESSFUL, extendedResponse));
                    } else {
                        LOG.debug(I18n.msg(I18n.MSG_04117_EXTENDED_FAILED, extendedResponse));
                    }
                }
                extendedFuture.set(extendedResponse);
                this.removeFromFutureMaps(messageId);
                break;
            }
            case INTERMEDIATE_RESPONSE: {
                IntermediateResponseImpl intermediateResponse;
                if (responseFuture instanceof SearchFuture) {
                    intermediateResponse = new IntermediateResponseImpl(messageId);
                    this.addControls(intermediateResponse, response);
                    ((SearchFuture)responseFuture).set(intermediateResponse);
                } else if (responseFuture instanceof ExtendedFuture) {
                    intermediateResponse = new IntermediateResponseImpl(messageId);
                    this.addControls(intermediateResponse, response);
                    ((ExtendedFuture)responseFuture).set(intermediateResponse);
                } else {
                    throw new UnsupportedOperationException(I18n.err(I18n.ERR_04111_UNKNOWN_RESPONSE_FUTURE_TYPE, responseFuture.getClass().getName()));
                }
                intermediateResponse.setResponseName(((IntermediateResponse)response).getResponseName());
                intermediateResponse.setResponseValue(((IntermediateResponse)response).getResponseValue());
                break;
            }
            case MODIFY_RESPONSE: {
                ModifyResponse modifyResponse = (ModifyResponse)response;
                ModifyFuture modifyFuture = (ModifyFuture)responseFuture;
                if (LOG.isDebugEnabled()) {
                    if (modifyResponse.getLdapResult().getResultCode() == ResultCodeEnum.SUCCESS) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug(I18n.msg(I18n.MSG_04123_MODIFY_SUCCESSFUL, modifyResponse));
                        }
                    } else if (LOG.isDebugEnabled()) {
                        LOG.debug(I18n.msg(I18n.MSG_04122_MODIFY_FAILED, modifyResponse));
                    }
                }
                modifyFuture.set(modifyResponse);
                this.removeFromFutureMaps(messageId);
                break;
            }
            case MODIFYDN_RESPONSE: {
                ModifyDnResponse modifyDnResponse = (ModifyDnResponse)response;
                ModifyDnFuture modifyDnFuture = (ModifyDnFuture)responseFuture;
                if (LOG.isDebugEnabled()) {
                    if (modifyDnResponse.getLdapResult().getResultCode() == ResultCodeEnum.SUCCESS) {
                        LOG.debug(I18n.msg(I18n.MSG_04125_MODIFYDN_SUCCESSFUL, modifyDnResponse));
                    } else {
                        LOG.debug(I18n.msg(I18n.MSG_04124_MODIFYDN_FAILED, modifyDnResponse));
                    }
                }
                modifyDnFuture.set(modifyDnResponse);
                this.removeFromFutureMaps(messageId);
                break;
            }
            case SEARCH_RESULT_DONE: {
                SearchResultDone searchResultDone = (SearchResultDone)response;
                SearchFuture searchFuture = (SearchFuture)responseFuture;
                if (LOG.isDebugEnabled()) {
                    if (searchResultDone.getLdapResult().getResultCode() == ResultCodeEnum.SUCCESS) {
                        LOG.debug(I18n.msg(I18n.MSG_04131_SEARCH_SUCCESSFUL, searchResultDone));
                    } else {
                        LOG.debug(I18n.msg(I18n.MSG_04129_SEARCH_FAILED, searchResultDone));
                    }
                }
                searchFuture.set(searchResultDone);
                this.removeFromFutureMaps(messageId);
                break;
            }
            case SEARCH_RESULT_ENTRY: {
                SearchResultEntry searchResultEntry = (SearchResultEntry)response;
                if (this.schemaManager != null) {
                    searchResultEntry.setEntry(new DefaultEntry(this.schemaManager, searchResultEntry.getEntry()));
                }
                SearchFuture searchFuture = (SearchFuture)responseFuture;
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.msg(I18n.MSG_04128_SEARCH_ENTRY_FOUND, searchResultEntry));
                }
                searchFuture.set(searchResultEntry);
                break;
            }
            case SEARCH_RESULT_REFERENCE: {
                SearchResultReference searchResultReference = (SearchResultReference)response;
                SearchFuture searchFuture = (SearchFuture)responseFuture;
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.msg(I18n.MSG_04130_SEARCH_REFERENCE_FOUND, searchResultReference));
                }
                searchFuture.set(searchResultReference);
                break;
            }
            default: {
                throw new IllegalStateException(I18n.err(I18n.ERR_04132_UNEXPECTED_RESPONSE_TYPE, new Object[]{response.getType()}));
            }
        }
    }

    @Override
    public void modify(Entry entry, ModificationOperation modOp) throws LdapException {
        if (entry == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.msg(I18n.MSG_04140_NULL_ENTRY_MODIFY, new Object[0]));
            }
            throw new IllegalArgumentException(I18n.err(I18n.ERR_04133_NULL_MODIFIED_ENTRY, new Object[0]));
        }
        ModifyRequestImpl modReq = new ModifyRequestImpl();
        modReq.setName(entry.getDn());
        Iterator<Attribute> itr = entry.iterator();
        while (itr.hasNext()) {
            modReq.addModification(itr.next(), modOp);
        }
        ModifyResponse modifyResponse = this.modify(modReq);
        ResultCodeEnum.processResponse(modifyResponse);
    }

    @Override
    public void modify(Dn dn, Modification ... modifications) throws LdapException {
        if (dn == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.msg(I18n.MSG_04139_NULL_DN_MODIFY, new Object[0]));
            }
            throw new IllegalArgumentException(I18n.err(I18n.ERR_04134_NULL_MODIFIED_DN, new Object[0]));
        }
        if (modifications == null || modifications.length == 0) {
            String msg = I18n.err(I18n.ERR_04135_CANNOT_PROCESS_NO_MODIFICATION_MOD, new Object[0]);
            if (LOG.isDebugEnabled()) {
                LOG.debug(msg);
            }
            throw new IllegalArgumentException(msg);
        }
        ModifyRequestImpl modReq = new ModifyRequestImpl();
        modReq.setName(dn);
        for (Modification modification : modifications) {
            modReq.addModification(modification);
        }
        ModifyResponse modifyResponse = this.modify(modReq);
        ResultCodeEnum.processResponse(modifyResponse);
    }

    @Override
    public void modify(String dn, Modification ... modifications) throws LdapException {
        this.modify(new Dn(dn), modifications);
    }

    @Override
    public ModifyResponse modify(ModifyRequest modRequest) throws LdapException {
        if (modRequest == null) {
            String msg = I18n.err(I18n.ERR_04136_CANNOT_PROCESS_NULL_MOD_REQ, new Object[0]);
            if (LOG.isDebugEnabled()) {
                LOG.debug(msg);
            }
            throw new IllegalArgumentException(msg);
        }
        ModifyFuture modifyFuture = this.modifyAsync(modRequest);
        try {
            ModifyResponse modifyResponse = (ModifyResponse)modifyFuture.get(this.timeout, TimeUnit.MILLISECONDS);
            if (modifyResponse == null) {
                if (LOG.isErrorEnabled()) {
                    LOG.error(I18n.err(I18n.ERR_04112_OP_FAILED_TIMEOUT, "Modify"));
                }
                throw new LdapException(TIME_OUT_ERROR);
            }
            if (modifyResponse.getLdapResult().getResultCode() == ResultCodeEnum.SUCCESS) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.msg(I18n.MSG_04123_MODIFY_SUCCESSFUL, modifyResponse));
                }
            } else {
                if (modifyResponse instanceof ModifyNoDResponse) {
                    throw new LdapException(modifyResponse.getLdapResult().getDiagnosticMessage());
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.msg(I18n.MSG_04122_MODIFY_FAILED, modifyResponse));
                }
            }
            return modifyResponse;
        }
        catch (Exception ie) {
            LOG.error(NO_RESPONSE_ERROR, ie);
            if (!modifyFuture.isCancelled()) {
                this.abandon(modRequest.getMessageId());
            }
            throw new LdapException(ie.getMessage(), ie);
        }
    }

    @Override
    public ModifyFuture modifyAsync(ModifyRequest modRequest) throws LdapException {
        if (modRequest == null) {
            String msg = I18n.err(I18n.ERR_04136_CANNOT_PROCESS_NULL_MOD_REQ, new Object[0]);
            if (LOG.isDebugEnabled()) {
                LOG.debug(msg);
            }
            throw new IllegalArgumentException(msg);
        }
        if (modRequest.getName() == null) {
            String msg = I18n.err(I18n.ERR_04137_CANNOT_PROCESS_MOD_NULL_DN, new Object[0]);
            if (LOG.isDebugEnabled()) {
                LOG.debug(msg);
            }
            throw new IllegalArgumentException(msg);
        }
        this.connect();
        this.checkSession();
        int newId = this.messageId.incrementAndGet();
        modRequest.setMessageId(newId);
        ModifyFuture modifyFuture = new ModifyFuture(this, newId);
        this.addToFutureMap(newId, modifyFuture);
        this.writeRequest(modRequest);
        return modifyFuture;
    }

    @Override
    public void rename(String entryDn, String newRdn) throws LdapException {
        this.rename(entryDn, newRdn, true);
    }

    @Override
    public void rename(Dn entryDn, Rdn newRdn) throws LdapException {
        this.rename(entryDn, newRdn, true);
    }

    @Override
    public void rename(String entryDn, String newRdn, boolean deleteOldRdn) throws LdapException {
        if (entryDn == null) {
            String msg = I18n.err(I18n.ERR_04138_CANNOT_PROCESS_RENAME_NULL_DN, new Object[0]);
            if (LOG.isDebugEnabled()) {
                LOG.debug(msg);
            }
            throw new IllegalArgumentException(msg);
        }
        if (newRdn == null) {
            String msg = I18n.err(I18n.ERR_04139_CANNOT_PROCESS_RENAME_NULL_RDN, new Object[0]);
            if (LOG.isDebugEnabled()) {
                LOG.debug(msg);
            }
            throw new IllegalArgumentException(msg);
        }
        try {
            this.rename(new Dn(entryDn), new Rdn(newRdn), deleteOldRdn);
        }
        catch (LdapInvalidDnException e) {
            LOG.error(e.getMessage(), e);
            throw new LdapException(e.getMessage(), e);
        }
    }

    @Override
    public void rename(Dn entryDn, Rdn newRdn, boolean deleteOldRdn) throws LdapException {
        if (entryDn == null) {
            String msg = I18n.err(I18n.ERR_04138_CANNOT_PROCESS_RENAME_NULL_DN, new Object[0]);
            if (LOG.isDebugEnabled()) {
                LOG.debug(msg);
            }
            throw new IllegalArgumentException(msg);
        }
        if (newRdn == null) {
            String msg = I18n.err(I18n.ERR_04139_CANNOT_PROCESS_RENAME_NULL_RDN, new Object[0]);
            if (LOG.isDebugEnabled()) {
                LOG.debug(msg);
            }
            throw new IllegalArgumentException(msg);
        }
        ModifyDnRequestImpl modDnRequest = new ModifyDnRequestImpl();
        modDnRequest.setName(entryDn);
        modDnRequest.setNewRdn(newRdn);
        modDnRequest.setDeleteOldRdn(deleteOldRdn);
        ModifyDnResponse modifyDnResponse = this.modifyDn(modDnRequest);
        ResultCodeEnum.processResponse(modifyDnResponse);
    }

    @Override
    public void move(String entryDn, String newSuperiorDn) throws LdapException {
        if (entryDn == null) {
            String msg = I18n.err(I18n.ERR_04140_CANNOT_PROCESS_MOVE_NULL_DN, new Object[0]);
            if (LOG.isDebugEnabled()) {
                LOG.debug(msg);
            }
            throw new IllegalArgumentException(msg);
        }
        if (newSuperiorDn == null) {
            String msg = I18n.err(I18n.ERR_04141_CANNOT_PROCESS_MOVE_NULL_SUPERIOR, new Object[0]);
            if (LOG.isDebugEnabled()) {
                LOG.debug(msg);
            }
            throw new IllegalArgumentException(msg);
        }
        try {
            this.move(new Dn(entryDn), new Dn(newSuperiorDn));
        }
        catch (LdapInvalidDnException e) {
            LOG.error(e.getMessage(), e);
            throw new LdapException(e.getMessage(), e);
        }
    }

    @Override
    public void move(Dn entryDn, Dn newSuperiorDn) throws LdapException {
        if (entryDn == null) {
            String msg = I18n.err(I18n.ERR_04140_CANNOT_PROCESS_MOVE_NULL_DN, new Object[0]);
            if (LOG.isDebugEnabled()) {
                LOG.debug(msg);
            }
            throw new IllegalArgumentException(msg);
        }
        if (newSuperiorDn == null) {
            String msg = I18n.err(I18n.ERR_04141_CANNOT_PROCESS_MOVE_NULL_SUPERIOR, new Object[0]);
            if (LOG.isDebugEnabled()) {
                LOG.debug(msg);
            }
            throw new IllegalArgumentException(msg);
        }
        ModifyDnRequestImpl modDnRequest = new ModifyDnRequestImpl();
        modDnRequest.setName(entryDn);
        modDnRequest.setNewSuperior(newSuperiorDn);
        modDnRequest.setNewRdn(entryDn.getRdn());
        ModifyDnResponse modifyDnResponse = this.modifyDn(modDnRequest);
        ResultCodeEnum.processResponse(modifyDnResponse);
    }

    @Override
    public void moveAndRename(Dn entryDn, Dn newDn) throws LdapException {
        this.moveAndRename(entryDn, newDn, true);
    }

    @Override
    public void moveAndRename(String entryDn, String newDn) throws LdapException {
        this.moveAndRename(new Dn(entryDn), new Dn(newDn), true);
    }

    @Override
    public void moveAndRename(Dn entryDn, Dn newDn, boolean deleteOldRdn) throws LdapException {
        if (entryDn == null) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_04142_NULL_ENTRY_DN, new Object[0]));
        }
        if (entryDn.isRootDse()) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_04143_CANNOT_MOVE_ROOT_DSE, new Object[0]));
        }
        if (newDn == null) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_04144_NULL_NEW_DN, new Object[0]));
        }
        if (newDn.isRootDse()) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_04145_ROOT_DSE_CANNOT_BE_TARGET, new Object[0]));
        }
        ModifyDnRequestImpl modDnRequest = new ModifyDnRequestImpl();
        modDnRequest.setName(entryDn);
        modDnRequest.setNewRdn(newDn.getRdn());
        Dn newDnParent = newDn.getParent();
        if (newDnParent != null && !newDnParent.equals(entryDn.getParent())) {
            modDnRequest.setNewSuperior(newDnParent);
        }
        modDnRequest.setDeleteOldRdn(deleteOldRdn);
        ModifyDnResponse modifyDnResponse = this.modifyDn(modDnRequest);
        ResultCodeEnum.processResponse(modifyDnResponse);
    }

    @Override
    public void moveAndRename(String entryDn, String newDn, boolean deleteOldRdn) throws LdapException {
        this.moveAndRename(new Dn(entryDn), new Dn(newDn), true);
    }

    @Override
    public ModifyDnResponse modifyDn(ModifyDnRequest modDnRequest) throws LdapException {
        if (modDnRequest == null) {
            String msg = I18n.err(I18n.ERR_04145_ROOT_DSE_CANNOT_BE_TARGET, new Object[0]);
            if (LOG.isDebugEnabled()) {
                LOG.debug(msg);
            }
            throw new IllegalArgumentException(msg);
        }
        ModifyDnFuture modifyDnFuture = this.modifyDnAsync(modDnRequest);
        try {
            ModifyDnResponse modifyDnResponse = (ModifyDnResponse)modifyDnFuture.get(this.timeout, TimeUnit.MILLISECONDS);
            if (modifyDnResponse == null) {
                if (LOG.isErrorEnabled()) {
                    LOG.error(I18n.err(I18n.ERR_04112_OP_FAILED_TIMEOUT, "ModifyDn"));
                }
                throw new LdapException(TIME_OUT_ERROR);
            }
            if (modifyDnResponse.getLdapResult().getResultCode() == ResultCodeEnum.SUCCESS) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.msg(I18n.MSG_04125_MODIFYDN_SUCCESSFUL, modifyDnResponse));
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.msg(I18n.MSG_04124_MODIFYDN_FAILED, modifyDnResponse));
            }
            return modifyDnResponse;
        }
        catch (Exception ie) {
            LOG.error(NO_RESPONSE_ERROR, ie);
            if (!modifyDnFuture.isCancelled()) {
                this.abandon(modDnRequest.getMessageId());
            }
            throw new LdapException(NO_RESPONSE_ERROR, ie);
        }
    }

    @Override
    public ModifyDnFuture modifyDnAsync(ModifyDnRequest modDnRequest) throws LdapException {
        if (modDnRequest == null) {
            String msg = I18n.err(I18n.ERR_04145_ROOT_DSE_CANNOT_BE_TARGET, new Object[0]);
            if (LOG.isDebugEnabled()) {
                LOG.debug(msg);
            }
            throw new IllegalArgumentException(msg);
        }
        if (modDnRequest.getName() == null) {
            String msg = I18n.err(I18n.ERR_04137_CANNOT_PROCESS_MOD_NULL_DN, new Object[0]);
            if (LOG.isDebugEnabled()) {
                LOG.debug(msg);
            }
            throw new IllegalArgumentException(msg);
        }
        if (modDnRequest.getNewSuperior() == null && modDnRequest.getNewRdn() == null) {
            String msg = I18n.err(I18n.ERR_04147_CANNOT_PROCESS_MOD_NULL_DN_SUP, new Object[0]);
            if (LOG.isDebugEnabled()) {
                LOG.debug(msg);
            }
            throw new IllegalArgumentException(msg);
        }
        this.connect();
        this.checkSession();
        int newId = this.messageId.incrementAndGet();
        modDnRequest.setMessageId(newId);
        ModifyDnFuture modifyDnFuture = new ModifyDnFuture(this, newId);
        this.addToFutureMap(newId, modifyDnFuture);
        this.writeRequest(modDnRequest);
        return modifyDnFuture;
    }

    @Override
    public void delete(String dn) throws LdapException {
        this.delete(new Dn(dn));
    }

    @Override
    public void delete(Dn dn) throws LdapException {
        DeleteRequestImpl deleteRequest = new DeleteRequestImpl();
        deleteRequest.setName(dn);
        DeleteResponse deleteResponse = this.delete(deleteRequest);
        ResultCodeEnum.processResponse(deleteResponse);
    }

    public void deleteTree(Dn dn) throws LdapException {
        String treeDeleteOid = "1.2.840.113556.1.4.805";
        if (!this.isControlSupported(treeDeleteOid)) {
            String msg = I18n.err(I18n.ERR_04148_SUBTREE_CONTROL_NOT_SUPPORTED, new Object[0]);
            LOG.error(msg);
            throw new LdapException(msg);
        }
        DeleteRequestImpl deleteRequest = new DeleteRequestImpl();
        deleteRequest.setName(dn);
        deleteRequest.addControl(new OpaqueControl(treeDeleteOid));
        DeleteResponse deleteResponse = this.delete(deleteRequest);
        ResultCodeEnum.processResponse(deleteResponse);
    }

    public void deleteTree(String dn) throws LdapException {
        try {
            String treeDeleteOid = "1.2.840.113556.1.4.805";
            Dn newDn = new Dn(dn);
            if (!this.isControlSupported(treeDeleteOid)) {
                String msg = I18n.err(I18n.ERR_04148_SUBTREE_CONTROL_NOT_SUPPORTED, new Object[0]);
                LOG.error(msg);
                throw new LdapException(msg);
            }
            DeleteRequestImpl deleteRequest = new DeleteRequestImpl();
            deleteRequest.setName(newDn);
            deleteRequest.addControl(new OpaqueControl(treeDeleteOid));
            DeleteResponse deleteResponse = this.delete(deleteRequest);
            ResultCodeEnum.processResponse(deleteResponse);
        }
        catch (LdapInvalidDnException e) {
            LOG.error(e.getMessage(), e);
            throw new LdapException(e.getMessage(), e);
        }
    }

    @Override
    public DeleteResponse delete(DeleteRequest deleteRequest) throws LdapException {
        if (deleteRequest == null) {
            String msg = I18n.err(I18n.ERR_04149_CANNOT_PROCESS_NULL_DEL_REQ, new Object[0]);
            if (LOG.isDebugEnabled()) {
                LOG.debug(msg);
            }
            throw new IllegalArgumentException(msg);
        }
        DeleteFuture deleteFuture = this.deleteAsync(deleteRequest);
        try {
            DeleteResponse delResponse = (DeleteResponse)deleteFuture.get(this.timeout, TimeUnit.MILLISECONDS);
            if (delResponse == null) {
                if (LOG.isErrorEnabled()) {
                    LOG.error(I18n.err(I18n.ERR_04112_OP_FAILED_TIMEOUT, "Delete"));
                }
                throw new LdapException(TIME_OUT_ERROR);
            }
            if (delResponse.getLdapResult().getResultCode() == ResultCodeEnum.SUCCESS) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.msg(I18n.MSG_04116_DELETE_SUCCESSFUL, delResponse));
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.msg(I18n.MSG_04115_DELETE_FAILED, delResponse));
            }
            return delResponse;
        }
        catch (Exception ie) {
            LOG.error(NO_RESPONSE_ERROR, ie);
            if (!deleteFuture.isCancelled()) {
                this.abandon(deleteRequest.getMessageId());
            }
            throw new LdapException(NO_RESPONSE_ERROR, ie);
        }
    }

    @Override
    public DeleteFuture deleteAsync(DeleteRequest deleteRequest) throws LdapException {
        if (deleteRequest == null) {
            String msg = I18n.err(I18n.ERR_04149_CANNOT_PROCESS_NULL_DEL_REQ, new Object[0]);
            if (LOG.isDebugEnabled()) {
                LOG.debug(msg);
            }
            throw new IllegalArgumentException(msg);
        }
        if (deleteRequest.getName() == null) {
            String msg = I18n.err(I18n.ERR_04150_CANNOT_PROCESS_NULL_DEL_NULL_DN, new Object[0]);
            if (LOG.isDebugEnabled()) {
                LOG.debug(msg);
            }
            throw new IllegalArgumentException(msg);
        }
        this.connect();
        this.checkSession();
        int newId = this.messageId.incrementAndGet();
        deleteRequest.setMessageId(newId);
        DeleteFuture deleteFuture = new DeleteFuture(this, newId);
        this.addToFutureMap(newId, deleteFuture);
        this.writeRequest(deleteRequest);
        return deleteFuture;
    }

    @Override
    public boolean compare(String dn, String attributeName, String value) throws LdapException {
        return this.compare(new Dn(dn), attributeName, value);
    }

    @Override
    public boolean compare(String dn, String attributeName, byte[] value) throws LdapException {
        return this.compare(new Dn(dn), attributeName, value);
    }

    @Override
    public boolean compare(String dn, String attributeName, Value value) throws LdapException {
        return this.compare(new Dn(dn), attributeName, value);
    }

    @Override
    public boolean compare(Dn dn, String attributeName, String value) throws LdapException {
        CompareRequestImpl compareRequest = new CompareRequestImpl();
        compareRequest.setName(dn);
        compareRequest.setAttributeId(attributeName);
        compareRequest.setAssertionValue(value);
        CompareResponse compareResponse = this.compare(compareRequest);
        return ResultCodeEnum.processResponse(compareResponse);
    }

    @Override
    public boolean compare(Dn dn, String attributeName, byte[] value) throws LdapException {
        CompareRequestImpl compareRequest = new CompareRequestImpl();
        compareRequest.setName(dn);
        compareRequest.setAttributeId(attributeName);
        compareRequest.setAssertionValue(value);
        CompareResponse compareResponse = this.compare(compareRequest);
        return ResultCodeEnum.processResponse(compareResponse);
    }

    @Override
    public boolean compare(Dn dn, String attributeName, Value value) throws LdapException {
        CompareRequestImpl compareRequest = new CompareRequestImpl();
        compareRequest.setName(dn);
        compareRequest.setAttributeId(attributeName);
        if (value.isHumanReadable()) {
            compareRequest.setAssertionValue(value.getValue());
        } else {
            compareRequest.setAssertionValue(value.getBytes());
        }
        CompareResponse compareResponse = this.compare(compareRequest);
        return ResultCodeEnum.processResponse(compareResponse);
    }

    @Override
    public CompareResponse compare(CompareRequest compareRequest) throws LdapException {
        if (compareRequest == null) {
            String msg = I18n.err(I18n.ERR_04151_CANNOT_PROCESS_NULL_COMP_REQ, new Object[0]);
            if (LOG.isDebugEnabled()) {
                LOG.debug(msg);
            }
            throw new IllegalArgumentException(msg);
        }
        CompareFuture compareFuture = this.compareAsync(compareRequest);
        try {
            CompareResponse compareResponse = (CompareResponse)compareFuture.get(this.timeout, TimeUnit.MILLISECONDS);
            if (compareResponse == null) {
                if (LOG.isErrorEnabled()) {
                    LOG.error(I18n.err(I18n.ERR_04112_OP_FAILED_TIMEOUT, "Compare"));
                }
                throw new LdapException(TIME_OUT_ERROR);
            }
            if (compareResponse.getLdapResult().getResultCode() == ResultCodeEnum.SUCCESS) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.msg(I18n.MSG_04114_COMPARE_SUCCESSFUL, compareResponse));
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.msg(I18n.MSG_04113_COMPARE_FAILED, compareResponse));
            }
            return compareResponse;
        }
        catch (Exception ie) {
            LOG.error(NO_RESPONSE_ERROR, ie);
            if (!compareFuture.isCancelled()) {
                this.abandon(compareRequest.getMessageId());
            }
            throw new LdapException(NO_RESPONSE_ERROR, ie);
        }
    }

    @Override
    public CompareFuture compareAsync(CompareRequest compareRequest) throws LdapException {
        if (compareRequest == null) {
            String msg = I18n.err(I18n.ERR_04151_CANNOT_PROCESS_NULL_COMP_REQ, new Object[0]);
            if (LOG.isDebugEnabled()) {
                LOG.debug(msg);
            }
            throw new IllegalArgumentException(msg);
        }
        if (compareRequest.getName() == null) {
            String msg = I18n.err(I18n.ERR_04152_CANNOT_PROCESS_NULL_DN_COMP_REQ, new Object[0]);
            if (LOG.isDebugEnabled()) {
                LOG.debug(msg);
            }
            throw new IllegalArgumentException(msg);
        }
        this.connect();
        this.checkSession();
        int newId = this.messageId.incrementAndGet();
        compareRequest.setMessageId(newId);
        CompareFuture compareFuture = new CompareFuture(this, newId);
        this.addToFutureMap(newId, compareFuture);
        this.writeRequest(compareRequest);
        return compareFuture;
    }

    @Override
    public ExtendedResponse extended(String oid) throws LdapException {
        return this.extended(oid, null);
    }

    @Override
    public ExtendedResponse extended(String oid, byte[] value) throws LdapException {
        try {
            return this.extended(Oid.fromString(oid), value);
        }
        catch (DecoderException e) {
            String msg = I18n.err(I18n.ERR_04153_OID_DECODING_FAILURE, oid);
            LOG.error(msg);
            throw new LdapException(msg, e);
        }
    }

    @Override
    public ExtendedResponse extended(Oid oid) throws LdapException {
        return this.extended(oid, null);
    }

    @Override
    public ExtendedResponse extended(Oid oid, byte[] value) throws LdapException {
        ExtendedRequest extendedRequest = LdapApiServiceFactory.getSingleton().newExtendedRequest(oid.toString(), value);
        return this.extended(extendedRequest);
    }

    @Override
    public ExtendedResponse extended(ExtendedRequest extendedRequest) throws LdapException {
        if (extendedRequest == null) {
            String msg = I18n.err(I18n.ERR_04154_CANNOT_PROCESS_NULL_EXT_REQ, new Object[0]);
            if (LOG.isDebugEnabled()) {
                LOG.debug(msg);
            }
            throw new IllegalArgumentException(msg);
        }
        ExtendedFuture extendedFuture = this.extendedAsync(extendedRequest);
        try {
            ExtendedResponse response = (ExtendedResponse)extendedFuture.get(this.timeout, TimeUnit.MILLISECONDS);
            if (response == null) {
                if (LOG.isErrorEnabled()) {
                    LOG.error(I18n.err(I18n.ERR_04112_OP_FAILED_TIMEOUT, "Extended"));
                }
                throw new LdapException(TIME_OUT_ERROR);
            }
            if (response.getLdapResult().getResultCode() == ResultCodeEnum.SUCCESS) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.msg(I18n.MSG_04118_EXTENDED_SUCCESSFUL, response));
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.msg(I18n.MSG_04117_EXTENDED_FAILED, response));
            }
            if (Strings.isEmpty(response.getResponseName())) {
                response.setResponseName(extendedRequest.getRequestName());
            }
            return this.codec.decorate(response);
        }
        catch (Exception ie) {
            LOG.error(NO_RESPONSE_ERROR, ie);
            if (!extendedFuture.isCancelled()) {
                this.abandon(extendedRequest.getMessageId());
            }
            throw new LdapException(NO_RESPONSE_ERROR, ie);
        }
    }

    @Override
    public ExtendedFuture extendedAsync(ExtendedRequest extendedRequest) throws LdapException {
        if (extendedRequest == null) {
            String msg = I18n.err(I18n.ERR_04154_CANNOT_PROCESS_NULL_EXT_REQ, new Object[0]);
            if (LOG.isDebugEnabled()) {
                LOG.debug(msg);
            }
            throw new IllegalArgumentException(msg);
        }
        this.connect();
        this.checkSession();
        int newId = this.messageId.incrementAndGet();
        extendedRequest.setMessageId(newId);
        ExtendedFuture extendedFuture = new ExtendedFuture(this, newId);
        this.addToFutureMap(newId, extendedFuture);
        this.writeRequest(extendedRequest);
        return extendedFuture;
    }

    @Override
    public boolean exists(String dn) throws LdapException {
        return this.exists(new Dn(dn));
    }

    @Override
    public boolean exists(Dn dn) throws LdapException {
        try {
            Entry entry = this.lookup(dn, SchemaConstants.NO_ATTRIBUTE_ARRAY);
            return entry != null;
        }
        catch (LdapNoPermissionException lnpe) {
            return false;
        }
        catch (LdapException le) {
            throw le;
        }
    }

    @Override
    public Entry getRootDse() throws LdapException {
        return this.lookup(Dn.ROOT_DSE, SchemaConstants.ALL_USER_ATTRIBUTES_ARRAY);
    }

    @Override
    public Entry getRootDse(String ... attributes) throws LdapException {
        return this.lookup(Dn.ROOT_DSE, attributes);
    }

    @Override
    public Entry lookup(Dn dn) throws LdapException {
        return this.lookup(dn, SchemaConstants.ALL_USER_ATTRIBUTES_ARRAY);
    }

    @Override
    public Entry lookup(String dn) throws LdapException {
        return this.lookup(dn, SchemaConstants.ALL_USER_ATTRIBUTES_ARRAY);
    }

    @Override
    public Entry lookup(Dn dn, String ... attributes) throws LdapException {
        return this.lookup(dn, (Control[])null, attributes);
    }

    @Override
    public Entry lookup(Dn dn, Control[] controls, String ... attributes) throws LdapException {
        Entry entry = null;
        try {
            SearchRequestImpl searchRequest = new SearchRequestImpl();
            searchRequest.setBase(dn);
            searchRequest.setFilter("(objectClass=*)");
            searchRequest.setScope(SearchScope.OBJECT);
            searchRequest.addAttributes(attributes);
            searchRequest.setDerefAliases(AliasDerefMode.DEREF_ALWAYS);
            if (controls != null && controls.length > 0) {
                searchRequest.addAllControls(controls);
            }
            try (SearchCursor cursor = this.search(searchRequest);){
                if (cursor.next()) {
                    entry = ((SearchResultEntry)cursor.get()).getEntry();
                }
                cursor.next();
            }
        }
        catch (CursorException e) {
            throw new LdapException(e.getMessage(), e);
        }
        catch (IOException ioe) {
            throw new LdapException(ioe.getMessage(), ioe);
        }
        return entry;
    }

    @Override
    public Entry lookup(String dn, String ... attributes) throws LdapException {
        return this.lookup(new Dn(dn), (Control[])null, attributes);
    }

    @Override
    public Entry lookup(String dn, Control[] controls, String ... attributes) throws LdapException {
        return this.lookup(new Dn(dn), controls, attributes);
    }

    @Override
    public boolean isControlSupported(String controlOID) throws LdapException {
        return this.getSupportedControls().contains(controlOID);
    }

    @Override
    public List<String> getSupportedControls() throws LdapException {
        if (this.supportedControls != null) {
            return this.supportedControls;
        }
        if (this.rootDse == null) {
            this.fetchRootDSE(new String[0]);
        }
        this.supportedControls = new ArrayList<String>();
        Attribute attr = this.rootDse.get("supportedControl");
        if (attr == null) {
            this.fetchRootDSE("*", "+", "supportedControl");
            attr = this.rootDse.get("supportedControl");
            if (attr == null) {
                return this.supportedControls;
            }
        }
        for (Value value : attr) {
            this.supportedControls.add(value.getValue());
        }
        return this.supportedControls;
    }

    @Override
    public void loadSchema() throws LdapException {
        this.loadSchema(new DefaultSchemaLoader(this));
    }

    @Override
    public void loadSchemaRelaxed() throws LdapException {
        this.loadSchema(new DefaultSchemaLoader((LdapConnection)this, true));
    }

    public void loadSchema(SchemaLoader loader) throws LdapException {
        try {
            DefaultSchemaManager tmp = new DefaultSchemaManager(loader);
            tmp.loadAllEnabled();
            if (!tmp.getErrors().isEmpty() && loader.isStrict()) {
                String msg = I18n.err(I18n.ERR_04115_ERROR_LOADING_SCHEMA, new Object[0]);
                if (LOG.isErrorEnabled()) {
                    LOG.error(I18n.err(I18n.ERR_05114_ERROR_MESSAGE, msg, Strings.listToString(tmp.getErrors())));
                }
                throw new LdapException(msg);
            }
            this.schemaManager = tmp;
            this.ldapSession.setAttribute("LDAP-container", new LdapMessageContainer(this.codec, new SchemaBinaryAttributeDetector(this.schemaManager)));
        }
        catch (LdapException le) {
            throw le;
        }
        catch (Exception e) {
            LOG.error(I18n.err(I18n.ERR_04116_FAIL_LOAD_SCHEMA, new Object[0]), e);
            throw new LdapException(e);
        }
    }

    public void addSchema(File schemaFile) throws LdapException {
        try {
            if (this.schemaManager == null) {
                this.loadSchema();
            }
            if (this.schemaManager == null) {
                throw new LdapException(I18n.err(I18n.ERR_04116_FAIL_LOAD_SCHEMA, new Object[0]));
            }
            OpenLdapSchemaParser olsp = new OpenLdapSchemaParser();
            olsp.setQuirksMode(true);
            olsp.parse(schemaFile);
            Registries registries = this.schemaManager.getRegistries();
            for (AttributeType attributeType : olsp.getAttributeTypes()) {
                registries.buildReference(attributeType);
                registries.getAttributeTypeRegistry().register(attributeType);
            }
            for (ObjectClass objectClass : olsp.getObjectClasses()) {
                registries.buildReference(objectClass);
                registries.getObjectClassRegistry().register(objectClass);
            }
            if (LOG.isInfoEnabled()) {
                LOG.info(I18n.msg(I18n.MSG_04167_SCHEMA_LOADED_SUCCESSFULLY, schemaFile.getAbsolutePath()));
            }
        }
        catch (Exception e) {
            LOG.error(I18n.err(I18n.ERR_04117_FAIL_LOAD_SCHEMA_FILE, schemaFile.getAbsolutePath()));
            throw new LdapException(e);
        }
    }

    public void addSchema(String schemaFileName) throws LdapException {
        this.addSchema(new File(schemaFileName));
    }

    @Override
    public LdapApiService getCodecService() {
        return this.codec;
    }

    @Override
    public SchemaManager getSchemaManager() {
        return this.schemaManager;
    }

    private void fetchRootDSE(String ... explicitAttributes) throws LdapException {
        block12: {
            EntryCursor cursor = null;
            String[] attributes = explicitAttributes;
            if (attributes.length == 0) {
                attributes = new String[]{"*", "+"};
            }
            try {
                cursor = this.search("", "(objectClass=*)", SearchScope.OBJECT, attributes);
                if (cursor.next()) {
                    this.rootDse = (Entry)cursor.get();
                    break block12;
                }
                throw new LdapException(I18n.err(I18n.ERR_04155_ROOT_DSE_SEARCH_FAILED, new Object[0]));
            }
            catch (Exception e) {
                String msg = I18n.err(I18n.ERR_04156_FAILED_FETCHING_ROOT_DSE, new Object[0]);
                LOG.error(msg);
                throw new LdapException(msg, e);
            }
            finally {
                if (cursor != null) {
                    try {
                        cursor.close();
                    }
                    catch (Exception e) {
                        LOG.error(I18n.err(I18n.ERR_04114_CURSOR_CLOSE_FAIL, new Object[0]), e);
                    }
                }
            }
        }
    }

    @Override
    public LdapConnectionConfig getConfig() {
        return this.config;
    }

    private void addControls(Message codec, Message message) {
        Map<String, Control> controls = codec.getControls();
        if (controls != null) {
            for (Control cc : controls.values()) {
                if (cc == null) continue;
                message.addControl(cc);
            }
        }
    }

    private void removeFromFutureMaps(int msgId) {
        this.getFromFutureMap(msgId);
    }

    private void clearMaps() {
        this.futureMap.clear();
    }

    @Override
    public boolean isRequestCompleted(int messageId) {
        ResponseFuture<? extends Response> responseFuture = this.futureMap.get(messageId);
        return responseFuture == null;
    }

    @Override
    public boolean doesFutureExistFor(int messageId) {
        ResponseFuture<? extends Response> responseFuture = this.futureMap.get(messageId);
        return responseFuture != null;
    }

    public void addConnectionClosedEventListener(ConnectionClosedEventListener ccListener) {
        if (this.conCloseListeners == null) {
            this.conCloseListeners = new ArrayList<ConnectionClosedEventListener>();
        }
        this.conCloseListeners.add(ccListener);
    }

    @Override
    public void inputClosed(IoSession session) throws Exception {
        session.closeNow();
    }

    @Override
    public void sessionCreated(IoSession session) throws Exception {
        LdapMessageContainer ldapMessageContainer = new LdapMessageContainer(this.codec, this.config.getBinaryAttributeDetector());
        session.setAttribute("LDAP-container", ldapMessageContainer);
        this.connected.set(true);
    }

    @Override
    public void sessionClosed(IoSession session) throws Exception {
        if (!this.connected.get()) {
            return;
        }
        this.ldapSession.closeNow();
        this.connected.set(false);
        this.messageId.set(0);
        this.connectorMutex.lock();
        try {
            if (this.connector != null) {
                this.connector.dispose();
                this.connector = null;
            }
        }
        finally {
            this.connectorMutex.unlock();
        }
        this.clearMaps();
        if (this.conCloseListeners != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.msg(I18n.MSG_04136_NOTIFYING_CLOSE_LISTENERS, new Object[0]));
            }
            for (ConnectionClosedEventListener listener : this.conCloseListeners) {
                listener.connectionClosed();
            }
        }
    }

    public void startTls() throws LdapException {
        try {
            if (this.config.isUseSsl()) {
                throw new LdapException(I18n.err(I18n.ERR_04157_CANNOT_USE_TLS_WITH_SSL_FLAG, new Object[0]));
            }
            this.connect();
            this.checkSession();
            IoFilter sslFilter = this.ldapSession.getFilterChain().get(SSL_FILTER_KEY);
            if (sslFilter != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.msg(I18n.MSG_04121_LDAP_ALREADY_USING_START_TLS, new Object[0]));
                }
                return;
            }
            ExtendedResponse resp = this.extended(new StartTlsRequestImpl());
            LdapResult result = resp.getLdapResult();
            if (result.getResultCode() != ResultCodeEnum.SUCCESS) {
                throw new LdapOperationException(result.getResultCode(), result.getDiagnosticMessage());
            }
            this.addSslFilter();
        }
        catch (LdapException e) {
            throw e;
        }
        catch (Exception e) {
            throw new LdapException(e);
        }
    }

    private void addSslFilter() throws LdapException {
        try {
            String[] enabledProtocols;
            SSLContext sslContext = SSLContext.getInstance(this.config.getSslProtocol());
            TrustManager[] trustManagers = this.config.getTrustManagers();
            if (trustManagers == null || trustManagers.length == 0) {
                trustManagers = new TrustManager[]{new NoVerificationTrustManager()};
            }
            sslContext.init(this.config.getKeyManagers(), trustManagers, this.config.getSecureRandom());
            SslFilter sslFilter = new SslFilter(sslContext);
            sslFilter.setUseClientMode(true);
            String[] enabledCipherSuite = this.config.getEnabledCipherSuites();
            if (enabledCipherSuite != null && enabledCipherSuite.length != 0) {
                sslFilter.setEnabledCipherSuites(enabledCipherSuite);
            }
            if ((enabledProtocols = this.config.getEnabledProtocols()) != null && enabledProtocols.length != 0) {
                sslFilter.setEnabledProtocols(enabledProtocols);
            } else {
                sslFilter.setEnabledProtocols(new String[]{"TLSv1", "TLSv1.1", "TLSv1.2"});
            }
            this.handshakeFuture = new HandshakeFuture();
            if (this.ldapSession == null || !this.connected.get()) {
                this.connector.getFilterChain().addFirst(SSL_FILTER_KEY, sslFilter);
            } else {
                this.ldapSession.getFilterChain().addFirst(SSL_FILTER_KEY, sslFilter);
                boolean isSecured = this.handshakeFuture.get(this.timeout, TimeUnit.MILLISECONDS);
                if (!isSecured) {
                    throw new LdapOperationException(ResultCodeEnum.OTHER, I18n.err(I18n.ERR_04120_TLS_HANDSHAKE_ERROR, new Object[0]));
                }
            }
        }
        catch (Exception e) {
            String msg = I18n.err(I18n.ERR_04122_SSL_CONTEXT_INIT_FAILURE, new Object[0]);
            LOG.error(msg, e);
            throw new LdapException(msg, e);
        }
    }

    public BindFuture bindSasl(SaslRequest saslRequest) throws LdapException {
        this.authenticated.set(false);
        this.connect();
        this.checkSession();
        BindRequest bindRequest = this.createBindRequest(null, null, saslRequest.getSaslMechanism(), saslRequest.getControls());
        int newId = this.messageId.incrementAndGet();
        bindRequest.setMessageId(newId);
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg(I18n.MSG_04104_SENDING_REQUEST, bindRequest));
        }
        BindFuture bindFuture = new BindFuture(this, newId);
        this.addToFutureMap(newId, bindFuture);
        try {
            ResultCodeEnum result;
            BindResponse bindResponse;
            SaslClient sc;
            HashMap<String, String> properties = new HashMap<String, String>();
            if (saslRequest.getQualityOfProtection() != null) {
                properties.put("javax.security.sasl.qop", saslRequest.getQualityOfProtection().getValue());
            }
            if (saslRequest.getSecurityStrength() != null) {
                properties.put("javax.security.sasl.strength", saslRequest.getSecurityStrength().getValue());
            }
            if (saslRequest.isMutualAuthentication()) {
                properties.put("javax.security.sasl.server.authentication", "true");
            }
            if ((sc = Sasl.createSaslClient(new String[]{bindRequest.getSaslMechanism()}, saslRequest.getAuthorizationId(), "ldap", this.config.getLdapHost(), properties, new SaslCallbackHandler(saslRequest))) == null) {
                String message = I18n.err(I18n.ERR_04158_CANNOT_FIND_SASL_FACTORY_FOR_MECH, bindRequest.getSaslMechanism());
                LOG.error(message);
                throw new LdapException(message);
            }
            if (sc.hasInitialResponse()) {
                byte[] challengeResponse = sc.evaluateChallenge(Strings.EMPTY_BYTES);
                bindRequest.setCredentials(challengeResponse);
                this.writeRequest(bindRequest);
                bindResponse = (BindResponse)bindFuture.get(this.timeout, TimeUnit.MILLISECONDS);
                if (bindResponse == null) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error(I18n.err(I18n.ERR_04112_OP_FAILED_TIMEOUT, "Bind"));
                    }
                    throw new LdapException(TIME_OUT_ERROR);
                }
                result = bindResponse.getLdapResult().getResultCode();
            } else {
                BindRequestImpl bindRequestCopy = new BindRequestImpl();
                bindRequestCopy.setMessageId(newId);
                bindRequestCopy.setName(bindRequest.getName());
                bindRequestCopy.setSaslMechanism(bindRequest.getSaslMechanism());
                bindRequestCopy.setSimple(bindRequest.isSimple());
                bindRequestCopy.setVersion3(bindRequest.getVersion3());
                bindRequestCopy.addAllControls(bindRequest.getControls().values().toArray(new Control[0]));
                this.writeRequest(bindRequestCopy);
                bindResponse = (BindResponse)bindFuture.get(this.timeout, TimeUnit.MILLISECONDS);
                if (bindResponse == null) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error(I18n.err(I18n.ERR_04112_OP_FAILED_TIMEOUT, "Bind"));
                    }
                    throw new LdapException(TIME_OUT_ERROR);
                }
                result = bindResponse.getLdapResult().getResultCode();
            }
            while (!(sc.isComplete() || result != ResultCodeEnum.SASL_BIND_IN_PROGRESS && result != ResultCodeEnum.SUCCESS)) {
                byte[] response = sc.evaluateChallenge(bindResponse.getServerSaslCreds());
                if (result == ResultCodeEnum.SUCCESS) {
                    if (response == null) continue;
                    throw new LdapException(I18n.err(I18n.ERR_04159_PROTOCOL_ERROR, new Object[0]));
                }
                newId = this.messageId.incrementAndGet();
                bindRequest.setMessageId(newId);
                bindRequest.setCredentials(response);
                this.addToFutureMap(newId, bindFuture);
                this.writeRequest(bindRequest);
                bindResponse = (BindResponse)bindFuture.get(this.timeout, TimeUnit.MILLISECONDS);
                if (bindResponse == null) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error(I18n.err(I18n.ERR_04112_OP_FAILED_TIMEOUT, "Bind"));
                    }
                    throw new LdapException(TIME_OUT_ERROR);
                }
                result = bindResponse.getLdapResult().getResultCode();
            }
            bindFuture.set(bindResponse);
            return bindFuture;
        }
        catch (LdapException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
            throw new LdapException(e);
        }
    }

    private void writeRequest(Request request) throws LdapException {
        WriteFuture writeFuture = this.ldapSession.write(request);
        for (long localTimeout = this.timeout; localTimeout > 0L; localTimeout -= 100L) {
            Exception exception;
            boolean done = writeFuture.awaitUninterruptibly(100L);
            if (done) {
                return;
            }
            if (this.ldapSession.isConnected()) continue;
            if (LOG.isErrorEnabled()) {
                LOG.error(I18n.err(I18n.ERR_04118_SOMETHING_WRONG_HAPPENED, new Object[0]));
            }
            if ((exception = (Exception)this.ldapSession.removeAttribute(EXCEPTION_KEY)) != null) {
                if (exception instanceof LdapException) {
                    throw (LdapException)exception;
                }
                throw new InvalidConnectionException(exception.getMessage(), exception);
            }
            throw new InvalidConnectionException(I18n.err(I18n.ERR_04160_SESSION_HAS_BEEN_CLOSED, new Object[0]));
        }
        if (LOG.isErrorEnabled()) {
            LOG.error(I18n.err(I18n.ERR_04119_TIMEOUT, new Object[0]));
        }
        throw new LdapException(TIME_OUT_ERROR);
    }

    private String createKrb5ConfFile(String realmName, String kdcHost, int kdcPort) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("[libdefaults]").append("\n\t");
        sb.append("default_realm = ").append(realmName).append("\n");
        sb.append("[realms]").append("\n\t");
        sb.append(realmName).append(" = {").append("\n\t\t");
        sb.append("kdc = ").append(kdcHost).append(":").append(kdcPort).append("\n\t}\n");
        File krb5Conf = File.createTempFile("client-api-krb5", ".conf");
        krb5Conf.deleteOnExit();
        try (OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(Paths.get(krb5Conf.getPath(), new String[0]), new OpenOption[0]), Charset.defaultCharset());){
            writer.write(sb.toString());
        }
        String krb5ConfPath = krb5Conf.getAbsolutePath();
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg(I18n.MSG_04135_KRB5_FILE_CREATED, krb5ConfPath));
        }
        return krb5ConfPath;
    }

    @Override
    public BinaryAttributeDetector getBinaryAttributeDetector() {
        if (this.config != null) {
            return this.config.getBinaryAttributeDetector();
        }
        return null;
    }

    @Override
    public void setBinaryAttributeDetector(BinaryAttributeDetector binaryAttributeDetector) {
        if (this.config != null) {
            this.config.setBinaryAttributeDetector(binaryAttributeDetector);
        }
    }

    @Override
    public void setSchemaManager(SchemaManager schemaManager) {
        this.schemaManager = schemaManager;
    }

    public SocketSessionConfig getConnectionConfig() {
        return this.connectionConfig;
    }

    public void setConnectionConfig(SocketSessionConfig connectionConfig) {
        this.connectionConfig = connectionConfig;
    }

    @Override
    public void event(IoSession session, FilterEvent event) throws Exception {
        if (event instanceof SslEvent && (SslEvent)event == SslEvent.SECURED) {
            this.handshakeFuture.secured();
        }
    }
}

