/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.extras.extended.ads_impl.endTransaction.controls.actions;

import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.CodecControl;
import org.apache.directory.api.ldap.extras.extended.ads_impl.endTransaction.controls.ControlsContainer;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreControlValue
extends GrammarAction<ControlsContainer> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreControlValue.class);

    public StoreControlValue() {
        super("Store the control value");
    }

    @Override
    public void action(ControlsContainer container) {
        TLV tlv = container.getCurrentTLV();
        CodecControl<?> control = container.getCurrentControl();
        BerValue value = tlv.getValue();
        if (tlv.getLength() == 0) {
            control.setValue(Strings.EMPTY_BYTES);
        } else {
            control.setValue(value.getData());
        }
        container.setGrammarEndAllowed(true);
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg(I18n.MSG_08203_CONTROL_VALUE, Strings.dumpBytes(control.getValue())));
        }
    }
}

