/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.decorators;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.codec.decorators.LdapResultDecorator;
import org.apache.directory.api.ldap.codec.decorators.ResponseDecorator;
import org.apache.directory.api.ldap.model.message.BindResponse;

public class BindResponseDecorator
extends ResponseDecorator<BindResponse>
implements BindResponse {
    private int bindResponseLength;

    public BindResponseDecorator(LdapApiService codec, BindResponse decoratedMessage) {
        super(codec, decoratedMessage);
    }

    @Override
    public byte[] getServerSaslCreds() {
        return ((BindResponse)this.getDecorated()).getServerSaslCreds();
    }

    @Override
    public void setServerSaslCreds(byte[] serverSaslCreds) {
        ((BindResponse)this.getDecorated()).setServerSaslCreds(serverSaslCreds);
    }

    @Override
    public int computeLength() {
        int ldapResultLength;
        BindResponse bindResponse = (BindResponse)this.getDecorated();
        this.bindResponseLength = ldapResultLength = ((LdapResultDecorator)this.getLdapResult()).computeLength();
        byte[] serverSaslCreds = bindResponse.getServerSaslCreds();
        if (serverSaslCreds != null) {
            this.bindResponseLength += 1 + TLV.getNbBytes(serverSaslCreds.length) + serverSaslCreds.length;
        }
        return 1 + TLV.getNbBytes(this.bindResponseLength) + this.bindResponseLength;
    }

    @Override
    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        BindResponse bindResponse = (BindResponse)this.getDecorated();
        try {
            buffer.put((byte)97);
            buffer.put(TLV.getBytes(this.bindResponseLength));
            ((LdapResultDecorator)this.getLdapResult()).encode(buffer);
            byte[] serverSaslCreds = bindResponse.getServerSaslCreds();
            if (serverSaslCreds != null) {
                buffer.put((byte)-121);
                buffer.put(TLV.getBytes(serverSaslCreds.length));
                if (serverSaslCreds.length != 0) {
                    buffer.put(serverSaslCreds);
                }
            }
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException(I18n.err(I18n.ERR_08212_PDU_BUFFER_TOO_SMALL, new Object[0]), boe);
        }
        return buffer;
    }
}

