/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.request.search.filter;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.codec.decorators.SearchRequestDecorator;
import org.apache.directory.api.ldap.codec.search.PresentFilter;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitPresentFilter
extends GrammarAction<LdapMessageContainer<SearchRequestDecorator>> {
    private static final Logger LOG = LoggerFactory.getLogger(InitPresentFilter.class);

    public InitPresentFilter() {
        super("Init present filter Value");
    }

    @Override
    public void action(LdapMessageContainer<SearchRequestDecorator> container) throws DecoderException {
        SearchRequestDecorator searchRequestDecorator = container.getMessage();
        TLV tlv = container.getCurrentTLV();
        PresentFilter presentFilter = new PresentFilter(container.getTlvId());
        searchRequestDecorator.addCurrentFilter(presentFilter);
        searchRequestDecorator.setTerminalFilter(presentFilter);
        String value = Strings.utf8ToString(tlv.getValue().getData());
        if (Strings.isEmpty(value)) {
            presentFilter.setAttributeDescription("");
        } else {
            String type = Strings.utf8ToString(tlv.getValue().getData());
            presentFilter.setAttributeDescription(type);
        }
        searchRequestDecorator.unstackFilters(container);
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg(I18n.MSG_05151_INITIALIZE_PRESENT_FILTER, new Object[0]));
        }
    }
}

