/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.request.search;

import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.codec.decorators.SearchRequestDecorator;
import org.apache.directory.api.ldap.model.message.SearchRequestImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitSearchRequest
extends GrammarAction<LdapMessageContainer<SearchRequestDecorator>> {
    private static final Logger LOG = LoggerFactory.getLogger(InitSearchRequest.class);

    public InitSearchRequest() {
        super("Init SearchRequest");
    }

    @Override
    public void action(LdapMessageContainer<SearchRequestDecorator> container) {
        TLV tlv = container.getCurrentTLV();
        SearchRequestImpl internalSearchRequest = new SearchRequestImpl();
        internalSearchRequest.setMessageId(container.getMessageId());
        SearchRequestDecorator searchRequest = new SearchRequestDecorator(container.getLdapCodecService(), internalSearchRequest);
        searchRequest.setTlvId(tlv.getId());
        container.setMessage(searchRequest);
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg(I18n.MSG_05157_SEARCH_REQUEST, new Object[0]));
        }
    }
}

